/*
 * Decompiled with CFR 0.152.
 */
package de.hysky.skyblocker.utils.render.primitive;

import de.hysky.skyblocker.utils.render.Renderer;
import de.hysky.skyblocker.utils.render.SkyblockerRenderPipelines;
import de.hysky.skyblocker.utils.render.primitive.PrimitiveRenderer;
import de.hysky.skyblocker.utils.render.state.OutlinedCircleRenderState;
import net.minecraft.class_12075;
import net.minecraft.class_287;
import org.joml.Matrix4f;

public final class OutlinedCircleRenderer
implements PrimitiveRenderer<OutlinedCircleRenderState> {
    protected static final OutlinedCircleRenderer INSTANCE = new OutlinedCircleRenderer();

    private OutlinedCircleRenderer() {
    }

    @Override
    public void submitPrimitives(OutlinedCircleRenderState state, class_12075 cameraState) {
        class_287 buffer = Renderer.getBuffer(SkyblockerRenderPipelines.CIRCLE_LINES);
        Matrix4f positionMatrix = new Matrix4f().translate((float)(-cameraState.field_63078.field_1352), (float)(-cameraState.field_63078.field_1351), (float)(-cameraState.field_63078.field_1350));
        float innerRadius = state.radius - state.thickness / 2.0f;
        float outerRadius = state.radius + state.thickness / 2.0f;
        for (int i = 0; i < state.segments; ++i) {
            double angle1 = Math.PI * 2 * (double)i / (double)state.segments;
            double angle2 = Math.PI * 2 * (double)(i + 1) / (double)state.segments;
            float x1Inner = (float)Math.cos(angle1) * innerRadius;
            float z1Inner = (float)Math.sin(angle1) * innerRadius;
            float x1Outer = (float)Math.cos(angle1) * outerRadius;
            float z1Outer = (float)Math.sin(angle1) * outerRadius;
            float x2Inner = (float)Math.cos(angle2) * innerRadius;
            float z2Inner = (float)Math.sin(angle2) * innerRadius;
            float x2Outer = (float)Math.cos(angle2) * outerRadius;
            float z2Outer = (float)Math.sin(angle2) * outerRadius;
            float cx = (float)state.centre.method_10216();
            float cy = (float)state.centre.method_10214();
            float cz = (float)state.centre.method_10215();
            buffer.method_22918(positionMatrix, cx + x1Inner, cy, cz + z1Inner).method_39415(state.colour);
            buffer.method_22918(positionMatrix, cx + x1Outer, cy, cz + z1Outer).method_39415(state.colour);
            buffer.method_22918(positionMatrix, cx + x2Outer, cy, cz + z2Outer).method_39415(state.colour);
            buffer.method_22918(positionMatrix, cx + x2Inner, cy, cz + z2Inner).method_39415(state.colour);
        }
    }
}

