/*
 * Decompiled with CFR 0.152.
 */
package de.hysky.skyblocker.utils.render.title;

import com.google.common.collect.ImmutableSet;
import de.hysky.skyblocker.config.HudConfigScreen;
import de.hysky.skyblocker.config.SkyblockerConfig;
import de.hysky.skyblocker.config.SkyblockerConfigManager;
import de.hysky.skyblocker.config.configs.UIAndVisualsConfig;
import de.hysky.skyblocker.utils.EnumUtils;
import de.hysky.skyblocker.utils.render.gui.AbstractWidget;
import de.hysky.skyblocker.utils.render.gui.EmptyWidget;
import de.hysky.skyblocker.utils.render.title.Title;
import de.hysky.skyblocker.utils.render.title.TitleContainer;
import it.unimi.dsi.fastutil.ints.IntIntMutablePair;
import java.awt.Color;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import net.minecraft.class_11908;
import net.minecraft.class_124;
import net.minecraft.class_2561;
import net.minecraft.class_332;
import net.minecraft.class_437;

public class TitleContainerConfigScreen
extends HudConfigScreen {
    public static final float MIN_TITLE_SCALE = 30.0f;
    public static final float MAX_TITLE_SCALE = 140.0f;
    private static final Set<Title> EXAMPLES = ImmutableSet.of((Object)new Title(class_2561.method_43470((String)"Test1").method_27692(class_124.field_1061)), (Object)new Title(class_2561.method_43470((String)"Test23").method_27692(class_124.field_1075)), (Object)new Title(class_2561.method_43470((String)"Testing1234").method_27692(class_124.field_1077)));

    protected TitleContainerConfigScreen() {
        this(null);
    }

    public TitleContainerConfigScreen(class_437 parent) {
        super(class_2561.method_30163((String)"Title Container HUD Config"), parent, new EmptyWidget());
    }

    @Override
    protected void method_25426() {
        super.method_25426();
        if (SkyblockerConfigManager.get().uiAndVisuals.titleContainer.x >= 0 && SkyblockerConfigManager.get().uiAndVisuals.titleContainer.y >= 0) {
            ((AbstractWidget)this.widgets.getFirst()).method_48229(SkyblockerConfigManager.get().uiAndVisuals.titleContainer.x, SkyblockerConfigManager.get().uiAndVisuals.titleContainer.y);
        }
        this.updateWidgetDimensions();
    }

    @Override
    protected void renderWidget(class_332 context, List<AbstractWidget> widgets, float delta) {
        super.renderWidget(context, widgets, delta);
        TitleContainer.render(context, EXAMPLES, widgets.getFirst().method_46426(), widgets.getFirst().method_46427(), delta);
        UIAndVisualsConfig.Direction direction = SkyblockerConfigManager.get().uiAndVisuals.titleContainer.direction;
        UIAndVisualsConfig.Alignment alignment = SkyblockerConfigManager.get().uiAndVisuals.titleContainer.alignment;
        String string = "Press Q/E to change Alignment: " + String.valueOf((Object)alignment);
        int n = this.field_22789 / 2;
        Objects.requireNonNull(this.field_22793);
        context.method_25300(this.field_22793, string, n, 9 * 2, Color.WHITE.getRGB());
        String string2 = "Press R to change Direction: " + String.valueOf((Object)direction);
        int n2 = this.field_22789 / 2;
        Objects.requireNonNull(this.field_22793);
        context.method_25300(this.field_22793, string2, n2, 9 * 3 + 5, Color.WHITE.getRGB());
        int n3 = this.field_22789 / 2;
        Objects.requireNonNull(this.field_22793);
        context.method_25300(this.field_22793, "Press +/- to change Scale", n3, 9 * 4 + 10, Color.WHITE.getRGB());
        int n4 = this.field_22789 / 2;
        Objects.requireNonNull(this.field_22793);
        context.method_25300(this.field_22793, "Right Click To Reset Position", n4, 9 * 5 + 15, Color.GRAY.getRGB());
        int selectionWidth = this.getSelectionWidth();
        int x1 = switch (alignment) {
            default -> throw new MatchException(null, null);
            case UIAndVisualsConfig.Alignment.LEFT -> widgets.getFirst().method_46426();
            case UIAndVisualsConfig.Alignment.MIDDLE -> widgets.getFirst().method_46426() - selectionWidth / 2;
            case UIAndVisualsConfig.Alignment.RIGHT -> widgets.getFirst().method_46426() - selectionWidth;
        };
        int y1 = widgets.getFirst().method_46427();
        int x2 = x1 + selectionWidth;
        int y2 = y1 + this.getSelectionHeight();
        context.method_51738(x1, x2, y1, Color.RED.getRGB());
        context.method_51738(x1, x2, y2, Color.RED.getRGB());
        context.method_51742(x1, y1, y2, Color.RED.getRGB());
        context.method_51742(x2, y1, y2, Color.RED.getRGB());
    }

    private void updateWidgetDimensions() {
        ((AbstractWidget)this.widgets.getFirst()).setDimensions(this.getSelectionWidth(), this.getSelectionHeight());
    }

    private int getSelectionWidth() {
        return TitleContainer.getWidth(this.field_22793, EXAMPLES);
    }

    private int getSelectionHeight() {
        return TitleContainer.getHeight(this.field_22793, EXAMPLES);
    }

    public boolean method_25404(class_11908 input) {
        switch (input.comp_4795()) {
            case 81: {
                SkyblockerConfigManager.get().uiAndVisuals.titleContainer.alignment = EnumUtils.cycle(SkyblockerConfigManager.get().uiAndVisuals.titleContainer.alignment);
                break;
            }
            case 69: {
                SkyblockerConfigManager.get().uiAndVisuals.titleContainer.alignment = EnumUtils.cycleBackwards(SkyblockerConfigManager.get().uiAndVisuals.titleContainer.alignment);
                break;
            }
            case 82: {
                SkyblockerConfigManager.get().uiAndVisuals.titleContainer.direction = EnumUtils.cycle(SkyblockerConfigManager.get().uiAndVisuals.titleContainer.direction);
                this.updateWidgetDimensions();
                break;
            }
            case 61: {
                UIAndVisualsConfig.TitleContainer conf = SkyblockerConfigManager.get().uiAndVisuals.titleContainer;
                conf.titleContainerScale = Math.min(140.0f, conf.titleContainerScale + 10.0f);
                this.updateWidgetDimensions();
                break;
            }
            case 45: {
                UIAndVisualsConfig.TitleContainer conf = SkyblockerConfigManager.get().uiAndVisuals.titleContainer;
                conf.titleContainerScale = Math.max(30.0f, conf.titleContainerScale - 10.0f);
                this.updateWidgetDimensions();
            }
        }
        return super.method_25404(input);
    }

    @Override
    protected int getWidgetXOffset(AbstractWidget widget) {
        return switch (SkyblockerConfigManager.get().uiAndVisuals.titleContainer.alignment) {
            default -> throw new MatchException(null, null);
            case UIAndVisualsConfig.Alignment.LEFT -> 0;
            case UIAndVisualsConfig.Alignment.MIDDLE -> -this.getSelectionWidth() / 2;
            case UIAndVisualsConfig.Alignment.RIGHT -> -this.getSelectionWidth();
        };
    }

    @Override
    protected List<IntIntMutablePair> getConfigPos(SkyblockerConfig config) {
        return List.of(IntIntMutablePair.of((int)(this.field_22789 / 2), (int)((int)((double)this.field_22790 * 0.6))));
    }

    @Override
    protected void savePos(SkyblockerConfig config, List<AbstractWidget> widgets) {
        List<IntIntMutablePair> defaultPos = this.getConfigPos(config);
        config.uiAndVisuals.titleContainer.x = widgets.getFirst().method_46426() != defaultPos.getFirst().leftInt() ? widgets.getFirst().method_46426() : -1;
        config.uiAndVisuals.titleContainer.y = widgets.getFirst().method_46427() != defaultPos.getFirst().rightInt() ? widgets.getFirst().method_46427() : -1;
    }
}

