/*
 * Decompiled with CFR 0.152.
 */
package de.hysky.skyblocker.utils.scheduler;

import de.hysky.skyblocker.utils.scheduler.Scheduler;
import net.minecraft.class_310;
import net.minecraft.class_3544;
import org.apache.commons.lang3.StringUtils;

public class MessageScheduler
extends Scheduler {
    private static final int MIN_DELAY = 200;
    public static final MessageScheduler INSTANCE = new MessageScheduler();
    private long lastMessage = 0L;

    protected MessageScheduler() {
    }

    public void sendMessageAfterCooldown(String message, boolean hide) {
        if (this.lastMessage + 200L < System.currentTimeMillis()) {
            this.sendMessage(message, hide);
            this.lastMessage = System.currentTimeMillis();
        } else {
            this.queueMessage(message, hide, 0);
        }
    }

    private void sendMessage(String message, boolean hide) {
        class_310 client = class_310.method_1551();
        if (client.field_1724 == null) {
            Scheduler.LOGGER.error("[Skyblocker Message Scheduler] Tried to send a message while player is null: {}", (Object)message);
            return;
        }
        message = class_3544.method_43681((String)StringUtils.normalizeSpace((String)message.trim()));
        if (!hide) {
            client.field_1705.method_1743().method_1803(message);
        }
        if (message.startsWith("/")) {
            client.field_1724.field_3944.method_45730(message.substring(1));
        } else {
            client.field_1724.field_3944.method_45729(message);
        }
    }

    public void queueMessage(String message, boolean hide, int delay) {
        this.schedule(() -> this.sendMessage(message, hide), delay);
    }

    @Override
    protected boolean runTask(Runnable task, boolean multithreaded) {
        if (this.lastMessage + 200L < System.currentTimeMillis()) {
            task.run();
            this.lastMessage = System.currentTimeMillis();
            return true;
        }
        return false;
    }
}

