/*
 * Decompiled with CFR 0.152.
 */
package de.hysky.skyblocker.utils.ws;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.mojang.logging.LogUtils;
import com.mojang.serialization.Codec;
import com.mojang.serialization.Dynamic;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import de.hysky.skyblocker.SkyblockerMod;
import de.hysky.skyblocker.utils.Utils;
import de.hysky.skyblocker.utils.ws.Payload;
import de.hysky.skyblocker.utils.ws.Service;
import de.hysky.skyblocker.utils.ws.SkyblockerWebSocket;
import de.hysky.skyblocker.utils.ws.Type;
import de.hysky.skyblocker.utils.ws.message.CrystalsWaypointMessage;
import de.hysky.skyblocker.utils.ws.message.EggWaypointMessage;
import de.hysky.skyblocker.utils.ws.message.Message;
import java.util.Optional;
import org.slf4j.Logger;

public class WsMessageHandler {
    private static final Logger LOGGER = LogUtils.getLogger();

    public static void sendLocationMessage(Service service, Message<? extends Message<?>> message) {
        WsMessageHandler.send(Type.PUBLISH, service, Utils.getLocation().toString(), Optional.of(WsMessageHandler.encodeMessage(message)));
    }

    public static void sendServerMessage(Service service, Message<? extends Message<?>> message) {
        WsMessageHandler.send(Type.PUBLISH, service, Utils.getServer(), Optional.of(WsMessageHandler.encodeMessage(message)));
    }

    static void sendSimple(Type type, Service service, String serverId, Optional<Message<? extends Message<?>>> message) {
        WsMessageHandler.send(type, service, serverId, message.map(WsMessageHandler::encodeMessage));
    }

    private static void send(Type type, Service service, String serverId, Optional<Dynamic<?>> message) {
        try {
            Payload payload = new Payload(type, service, serverId, message);
            JsonObject encoded = ((JsonElement)Payload.CODEC.encodeStart((DynamicOps)JsonOps.INSTANCE, (Object)payload).getOrThrow()).getAsJsonObject();
            SkyblockerWebSocket.send(SkyblockerMod.GSON_COMPACT.toJson((JsonElement)encoded));
        }
        catch (Exception e) {
            LOGGER.info("[Skyblocker WebSocket Message Handler] Failed to send message! Type: {}, Service: {}, Message: {}", new Object[]{type, service, message, e});
        }
    }

    private static Dynamic<?> encodeMessage(Message<? extends Message<?>> message) {
        try {
            Codec<? extends Message<?>> codec = message.getCodec();
            Dynamic dynamic = new Dynamic((DynamicOps)JsonOps.INSTANCE, (Object)((JsonElement)codec.encodeStart((DynamicOps)JsonOps.INSTANCE, message).getOrThrow()));
            return dynamic;
        }
        catch (Exception e) {
            LOGGER.info("[Skyblocker WebSocket Message Handler] Failed to encode message! Message: {}", message, (Object)e);
            return new Dynamic((DynamicOps)JsonOps.INSTANCE);
        }
    }

    static void handleMessage(String message) {
        try {
            JsonObject payloadEncoded = JsonParser.parseString((String)message).getAsJsonObject();
            if (payloadEncoded.has("type")) {
                Payload payload = (Payload)Payload.CODEC.parse((DynamicOps)JsonOps.INSTANCE, (Object)payloadEncoded).getOrThrow();
                switch (payload.service()) {
                    case CRYSTAL_WAYPOINTS: {
                        CrystalsWaypointMessage.handle(payload.type(), payload.message());
                        break;
                    }
                    case EGG_WAYPOINTS: {
                        EggWaypointMessage.handle(payload.type(), payload.message());
                    }
                }
            }
        }
        catch (Exception e) {
            LOGGER.error("[Skyblocker WebSocket Message Handler] Failed to handle incoming message!", (Throwable)e);
        }
    }
}

