/*
 * Decompiled with CFR 0.152.
 */
package potatowolfie.web.goals;

import java.util.ArrayList;
import java.util.EnumSet;
import java.util.List;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1309;
import net.minecraft.class_1352;
import net.minecraft.class_1628;
import net.minecraft.class_238;
import net.minecraft.class_243;
import net.minecraft.class_2960;
import net.minecraft.class_3417;
import net.minecraft.class_5321;
import net.minecraft.class_6862;
import net.minecraft.class_7924;
import potatowolfie.web.entity.custom.SpiderWebEntity;
import potatowolfie.web.interfaces.WebSpiderInterface;

public class WebShootingSpiderAttackGoal
extends class_1352 {
    private final class_1628 spider;
    private final WebSpiderInterface webSpider;
    private final double baseSpeed;
    private class_1309 target;
    private int attackCooldown = 0;
    private static final class_6862<class_1299<?>> WEB_IMMUNE_TAG = class_6862.method_40092((class_5321)class_7924.field_41266, (class_2960)class_2960.method_43902((String)"web", (String)"web_immune"));
    private SpiderState currentState = SpiderState.POSITIONING;
    private int stateTimer = 0;
    private int targetLostTimer = 0;
    private int postWebChaseTimer = 0;
    private boolean hasWebSuccessfullyHit = false;
    private SpiderRole assignedRole = SpiderRole.WEBBER;
    private int roleAssignmentTimer = 0;
    private List<class_1628> lastKnownGroup = new ArrayList<class_1628>();
    private int webAttempts = 0;
    private int maxWebAttempts = 3;
    private boolean isSoloChaseMode = false;
    private int soloChaseTimer = 0;
    private int maxSoloChaseTime = 300;

    private static boolean isWebImmune(class_1309 entity) {
        return entity.method_5864().method_20210(WEB_IMMUNE_TAG);
    }

    public WebShootingSpiderAttackGoal(class_1628 spider, WebSpiderInterface webSpider) {
        this.spider = spider;
        this.webSpider = webSpider;
        this.baseSpeed = 1.0;
        this.method_6265(EnumSet.of(class_1352.class_4134.field_18405, class_1352.class_4134.field_18406));
    }

    public boolean method_6264() {
        class_1309 target = this.spider.method_5968();
        if (target == null || !target.method_5805() || WebShootingSpiderAttackGoal.isWebImmune(target)) {
            return false;
        }
        this.target = target;
        return true;
    }

    public boolean method_6266() {
        class_1309 target = this.spider.method_5968();
        if (target == null || !target.method_5805() || WebShootingSpiderAttackGoal.isWebImmune(target)) {
            return false;
        }
        double distance = this.spider.method_5858((class_1297)target);
        if (distance > 1024.0) {
            return false;
        }
        boolean targetTrapped = this.isTargetTouchingWeb(target);
        if (!targetTrapped) {
            ++this.targetLostTimer;
            if (this.targetLostTimer > 60) {
                return false;
            }
        } else {
            this.targetLostTimer = 0;
        }
        return true;
    }

    public void method_6270() {
        this.target = null;
        this.attackCooldown = 0;
        this.currentState = SpiderState.POSITIONING;
        this.stateTimer = 0;
        this.targetLostTimer = 0;
        this.postWebChaseTimer = 0;
        this.hasWebSuccessfullyHit = false;
        this.webAttempts = 0;
        this.isSoloChaseMode = false;
        this.soloChaseTimer = 0;
        this.webSpider.setHasShootWeb(false);
        this.spider.method_5980(null);
    }

    private List<class_1628> getNearbySpiders() {
        class_238 searchBox = class_238.method_30048((class_243)this.spider.method_19538(), (double)64.0, (double)32.0, (double)64.0);
        return this.spider.method_5770().method_8390(class_1628.class, searchBox, spider -> spider.method_5805() && spider != this.spider && spider.method_5968() != null);
    }

    private void assignRoles() {
        ++this.roleAssignmentTimer;
        if (this.roleAssignmentTimer < 20) {
            return;
        }
        this.roleAssignmentTimer = 0;
        List<class_1628> nearbySpiders = this.getNearbySpiders();
        int groupSize = nearbySpiders.size() + 1;
        nearbySpiders.add(this.spider);
        nearbySpiders.sort((a, b) -> Integer.compare(a.method_5628(), b.method_5628()));
        int thisSpiderIndex = nearbySpiders.indexOf(this.spider);
        switch (groupSize) {
            case 1: {
                this.assignedRole = SpiderRole.WEBBER;
                break;
            }
            case 2: {
                if (thisSpiderIndex == 0) {
                    this.assignedRole = SpiderRole.WEBBER;
                    break;
                }
                this.assignedRole = SpiderRole.CHASER;
                break;
            }
            case 3: {
                if (thisSpiderIndex == 0) {
                    this.assignedRole = SpiderRole.WEBBER;
                    break;
                }
                if (thisSpiderIndex == 1) {
                    this.assignedRole = SpiderRole.CHASER;
                    break;
                }
                this.assignedRole = SpiderRole.FLEXIBLE;
                break;
            }
            default: {
                int chaserIndex;
                int webberCount = (groupSize + 1) / 2;
                int chaserCount = groupSize - webberCount;
                this.assignedRole = thisSpiderIndex < webberCount ? (thisSpiderIndex % 2 == 0 ? SpiderRole.WEBBER : SpiderRole.BACKUP_WEBBER) : ((chaserIndex = thisSpiderIndex - webberCount) % 2 == 0 ? SpiderRole.CHASER : SpiderRole.BACKUP_CHASER);
            }
        }
        this.lastKnownGroup = new ArrayList<class_1628>(nearbySpiders);
    }

    private boolean shouldUseWebBehavior() {
        if (this.lastKnownGroup.size() == 1) {
            return !this.isSoloChaseMode;
        }
        switch (this.assignedRole.ordinal()) {
            case 0: 
            case 3: {
                return true;
            }
            case 1: 
            case 4: {
                return false;
            }
            case 2: {
                if (this.hasWebSuccessfullyHit) {
                    return this.spider.method_6051().method_43057() < 0.3f;
                }
                return this.spider.method_6051().method_43057() < 0.7f;
            }
        }
        return true;
    }

    private double getMovementSpeed(class_1309 target) {
        return this.assignedRole == SpiderRole.CHASER || this.assignedRole == SpiderRole.BACKUP_CHASER ? this.baseSpeed * 1.3 : this.baseSpeed;
    }

    private double getChargingSpeed(class_1309 target) {
        return this.assignedRole == SpiderRole.CHASER || this.assignedRole == SpiderRole.BACKUP_CHASER ? this.baseSpeed * 1.5 : this.baseSpeed;
    }

    private boolean isTargetTouchingWeb(class_1309 target) {
        return SpiderWebEntity.isEntityTrapped(target) && !WebShootingSpiderAttackGoal.isWebImmune(target);
    }

    public void method_6268() {
        class_1309 target = this.spider.method_5968();
        if (target == null || WebShootingSpiderAttackGoal.isWebImmune(target)) {
            return;
        }
        this.assignRoles();
        if (this.attackCooldown > 0) {
            --this.attackCooldown;
        }
        if (this.postWebChaseTimer > 0) {
            --this.postWebChaseTimer;
        }
        if (this.lastKnownGroup.size() == 1) {
            if (this.isSoloChaseMode) {
                ++this.soloChaseTimer;
                if (this.soloChaseTimer >= this.maxSoloChaseTime) {
                    this.isSoloChaseMode = false;
                    this.soloChaseTimer = 0;
                    this.webAttempts = 0;
                }
            }
        } else {
            this.isSoloChaseMode = false;
            this.soloChaseTimer = 0;
            this.webAttempts = 0;
        }
        ++this.stateTimer;
        double actualDistance = this.spider.method_5739((class_1297)target);
        boolean canSeeTarget = this.spider.method_5985().method_6369((class_1297)target);
        boolean targetIsTouchingWeb = this.isTargetTouchingWeb(target);
        if (this.assignedRole == SpiderRole.CHASER || this.assignedRole == SpiderRole.BACKUP_CHASER || this.lastKnownGroup.size() == 1 && this.isSoloChaseMode) {
            this.handleChaserBehavior(target, actualDistance, targetIsTouchingWeb);
            return;
        }
        if (this.currentState == SpiderState.POST_WEB_CHASE) {
            this.handlePostWebChase(target, actualDistance, targetIsTouchingWeb);
            return;
        }
        if (targetIsTouchingWeb && !this.hasWebSuccessfullyHit && this.shouldUseWebBehavior()) {
            this.hasWebSuccessfullyHit = true;
            this.postWebChaseTimer = 40 + this.spider.method_6051().method_43048(40);
            this.transitionToState(SpiderState.POST_WEB_CHASE);
            return;
        }
        if (!targetIsTouchingWeb) {
            this.hasWebSuccessfullyHit = false;
        }
        if (!(targetIsTouchingWeb || this.currentState != SpiderState.CHARGING && this.currentState != SpiderState.ATTACKING)) {
            if (this.shouldUseWebBehavior()) {
                this.transitionToState(SpiderState.POSITIONING);
            } else if (this.assignedRole == SpiderRole.WEBBER && this.lastKnownGroup.size() == 3) {
                this.transitionToState(SpiderState.RETREATING);
            } else {
                this.transitionToState(SpiderState.POSITIONING);
            }
        }
        switch (this.currentState.ordinal()) {
            case 0: {
                this.handlePositioning(target, actualDistance, canSeeTarget, targetIsTouchingWeb);
                break;
            }
            case 1: {
                this.handleShooting(target, actualDistance, canSeeTarget, targetIsTouchingWeb);
                break;
            }
            case 2: {
                this.handleCharging(target, actualDistance, targetIsTouchingWeb);
                break;
            }
            case 3: {
                this.handleAttacking(target, actualDistance, targetIsTouchingWeb);
                break;
            }
            case 4: {
                this.handleCooldown(target, actualDistance, targetIsTouchingWeb);
                break;
            }
            case 6: {
                this.handleRetreating(target, actualDistance, targetIsTouchingWeb);
            }
        }
    }

    private void handleChaserBehavior(class_1309 target, double distance, boolean targetIsTouchingWeb) {
        this.spider.method_5988().method_6226((class_1297)target, 30.0f, 30.0f);
        double currentSpeed = this.getChargingSpeed(target);
        this.spider.method_5942().method_6337(target.method_23317(), target.method_23318(), target.method_23321(), currentSpeed);
        if (distance <= 3.5 && this.attackCooldown <= 0) {
            float damage = 4.0f;
            boolean damageDealt = target.method_5643(this.spider.method_48923().method_48812((class_1309)this.spider), damage);
            if (damageDealt) {
                class_243 targetPos = target.method_19538();
                class_243 spiderPos = this.spider.method_19538();
                class_243 direction = targetPos.method_1020(spiderPos).method_1029();
                double knockbackStrength = 0.5;
                target.method_6005(knockbackStrength, -direction.field_1352, -direction.field_1350);
                this.spider.method_5783(class_3417.field_14657, 1.0f, 1.2f);
                this.attackCooldown = 15;
            }
        }
    }

    private void handlePostWebChase(class_1309 target, double distance, boolean targetIsTouchingWeb) {
        this.spider.method_5988().method_6226((class_1297)target, 30.0f, 30.0f);
        double currentSpeed = this.getChargingSpeed(target);
        this.spider.method_5942().method_6337(target.method_23317(), target.method_23318(), target.method_23321(), currentSpeed);
        if (distance <= 3.5 && this.attackCooldown <= 0) {
            float damage = 4.0f;
            boolean damageDealt = target.method_5643(this.spider.method_48923().method_48812((class_1309)this.spider), damage);
            if (damageDealt) {
                class_243 targetPos = target.method_19538();
                class_243 spiderPos = this.spider.method_19538();
                class_243 direction = targetPos.method_1020(spiderPos).method_1029();
                double knockbackStrength = 0.4;
                target.method_6005(knockbackStrength, -direction.field_1352, -direction.field_1350);
                this.spider.method_5783(class_3417.field_14657, 1.0f, 1.2f);
                this.attackCooldown = 12;
            }
        }
        if (this.postWebChaseTimer <= 0) {
            this.transitionToState(SpiderState.POSITIONING);
        }
    }

    private void handleRetreating(class_1309 target, double distance, boolean targetIsTouchingWeb) {
        this.spider.method_5988().method_6226((class_1297)target, 30.0f, 30.0f);
        if (targetIsTouchingWeb) {
            this.transitionToState(SpiderState.CHARGING);
            return;
        }
        class_243 spiderPos = this.spider.method_19538();
        class_243 targetPos = target.method_19538();
        class_243 awayDirection = spiderPos.method_1020(targetPos).method_1029();
        class_243 retreatPos = spiderPos.method_1019(awayDirection.method_1021(8.0));
        this.spider.method_5942().method_6337(retreatPos.field_1352, retreatPos.field_1351, retreatPos.field_1350, this.baseSpeed);
        if (this.stateTimer > 60 || distance > 12.0) {
            this.transitionToState(SpiderState.POSITIONING);
        }
    }

    private void handlePositioning(class_1309 target, double distance, boolean canSeeTarget, boolean targetIsTouchingWeb) {
        this.spider.method_5988().method_6226((class_1297)target, 30.0f, 30.0f);
        double currentSpeed = this.getMovementSpeed(target);
        if (targetIsTouchingWeb) {
            this.transitionToState(SpiderState.CHARGING);
            return;
        }
        if (distance < 5.0) {
            class_243 spiderPos = this.spider.method_19538();
            class_243 targetPos = target.method_19538();
            class_243 awayDirection = spiderPos.method_1020(targetPos).method_1029();
            class_243 strafeDirection = new class_243(-awayDirection.field_1350, 0.0, awayDirection.field_1352);
            if ((this.stateTimer + this.spider.method_5628()) % 20 > 10) {
                strafeDirection = strafeDirection.method_1021(-1.0);
            }
            class_243 evasiveDirection = awayDirection.method_1021(2.0).method_1019(strafeDirection.method_1021(1.5));
            class_243 retreatPos = spiderPos.method_1019(evasiveDirection.method_1021(3.0));
            this.spider.method_5942().method_6337(retreatPos.field_1352, retreatPos.field_1351, retreatPos.field_1350, currentSpeed);
        } else if (distance >= 8.0) {
            class_243 spiderPos = this.spider.method_19538();
            class_243 targetPos = target.method_19538();
            class_243 directionToTarget = targetPos.method_1020(spiderPos).method_1029();
            class_243 strafeDirection = new class_243(-directionToTarget.field_1350, 0.0, directionToTarget.field_1352);
            double weavePhase = (double)(this.stateTimer + this.spider.method_5628()) * 0.15;
            class_243 weaveDirection = strafeDirection.method_1021(Math.sin(weavePhase) * 1.5);
            class_243 approachDirection = directionToTarget.method_1021(2.0).method_1019(weaveDirection);
            class_243 approachPos = spiderPos.method_1019(approachDirection.method_1021(2.0));
            this.spider.method_5942().method_6337(approachPos.field_1352, approachPos.field_1351, approachPos.field_1350, currentSpeed);
        } else if (canSeeTarget && distance >= 5.0 && distance <= 10.0 && this.shouldUseWebBehavior()) {
            this.transitionToState(SpiderState.SHOOTING);
        }
        if (this.stateTimer > 20 && this.shouldUseWebBehavior()) {
            this.transitionToState(SpiderState.SHOOTING);
        }
    }

    private void handleShooting(class_1309 target, double distance, boolean canSeeTarget, boolean targetIsTouchingWeb) {
        if (!this.shouldUseWebBehavior()) {
            this.handleChaserBehavior(target, distance, targetIsTouchingWeb);
            return;
        }
        this.spider.method_5988().method_6226((class_1297)target, 30.0f, 30.0f);
        double currentSpeed = this.getMovementSpeed(target);
        if (targetIsTouchingWeb) {
            this.transitionToState(SpiderState.CHARGING);
            return;
        }
        if (distance < 5.0) {
            this.transitionToState(SpiderState.POSITIONING);
            return;
        }
        if (distance >= 5.0 && distance <= 15.0) {
            class_243 spiderPos = this.spider.method_19538();
            class_243 targetPos = target.method_19538();
            class_243 directionToTarget = targetPos.method_1020(spiderPos).method_1029();
            double optimalRange = 8.0;
            double currentRange = spiderPos.method_1022(targetPos);
            class_243 strafeDirection = new class_243(-directionToTarget.field_1350, 0.0, directionToTarget.field_1352);
            double strafePhase = (double)(this.stateTimer + this.spider.method_5628()) * 0.1;
            if (Math.sin(strafePhase) > 0.0) {
                strafeDirection = strafeDirection.method_1021(-1.0);
            }
            class_243 rangeAdjustment = class_243.field_1353;
            if (currentRange < optimalRange - 1.0) {
                rangeAdjustment = directionToTarget.method_1021(-2.0);
            } else if (currentRange > optimalRange + 2.0) {
                rangeAdjustment = directionToTarget.method_1021(1.5);
            }
            class_243 moveDirection = strafeDirection.method_1021(3.0).method_1019(rangeAdjustment);
            class_243 moveTarget = spiderPos.method_1019(moveDirection);
            this.spider.method_5942().method_6337(moveTarget.field_1352, moveTarget.field_1351, moveTarget.field_1350, currentSpeed);
        }
        if (canSeeTarget && distance >= 5.0 && distance < 15.0 && this.stateTimer >= 5) {
            List<class_1628> nearbySpiders = this.getNearbySpiders();
            int cooldown = nearbySpiders.size() > 5 ? 20 : 10;
            this.webSpider.shootWeb(target);
            this.webSpider.setHasShootWeb(true);
            this.webSpider.setWebCooldown(cooldown);
            if (this.lastKnownGroup.size() == 1) {
                ++this.webAttempts;
                if (this.webAttempts >= this.maxWebAttempts) {
                    this.isSoloChaseMode = true;
                    this.soloChaseTimer = 0;
                    this.webAttempts = 0;
                }
            }
        }
    }

    private void handleCharging(class_1309 target, double distance, boolean targetIsTouchingWeb) {
        int maxChargeTime;
        if (!targetIsTouchingWeb) {
            if (this.shouldUseWebBehavior()) {
                this.transitionToState(SpiderState.POSITIONING);
            } else if (this.assignedRole == SpiderRole.WEBBER && this.lastKnownGroup.size() == 3) {
                this.transitionToState(SpiderState.RETREATING);
            } else {
                this.transitionToState(SpiderState.POSITIONING);
            }
            return;
        }
        this.spider.method_5988().method_6226((class_1297)target, 30.0f, 30.0f);
        double chargingSpeed = this.getChargingSpeed(target);
        this.spider.method_5942().method_6337(target.method_23317(), target.method_23318(), target.method_23321(), chargingSpeed);
        double attackDistance = targetIsTouchingWeb ? 4.5 : 4.0;
        int n = maxChargeTime = targetIsTouchingWeb ? 40 : 30;
        if (distance <= attackDistance || this.stateTimer > maxChargeTime) {
            this.transitionToState(SpiderState.ATTACKING);
        }
    }

    private void handleAttacking(class_1309 target, double distance, boolean targetIsTouchingWeb) {
        int maxAttackTime;
        if (!targetIsTouchingWeb) {
            if (this.shouldUseWebBehavior()) {
                this.transitionToState(SpiderState.POSITIONING);
            } else if (this.assignedRole == SpiderRole.WEBBER && this.lastKnownGroup.size() == 3) {
                this.transitionToState(SpiderState.RETREATING);
            } else {
                this.transitionToState(SpiderState.POSITIONING);
            }
            return;
        }
        this.spider.method_5988().method_6226((class_1297)target, 30.0f, 30.0f);
        if (this.spider.method_18798().field_1351 > 0.1) {
            this.spider.method_18800(this.spider.method_18798().field_1352, -0.1, this.spider.method_18798().field_1350);
        }
        double attackRange = targetIsTouchingWeb ? 4.0 : 3.0;
        double currentSpeed = this.getMovementSpeed(target);
        if (distance <= attackRange) {
            this.spider.method_5942().method_6340();
            class_243 targetPos = target.method_19538();
            class_243 spiderPos = this.spider.method_19538();
            class_243 direction = targetPos.method_1020(spiderPos).method_1029();
            double yaw = Math.atan2(-direction.field_1352, direction.field_1350) * 57.29577951308232;
            this.spider.method_36456((float)yaw);
            this.spider.method_5636((float)yaw);
            this.spider.method_5847((float)yaw);
            if (this.attackCooldown <= 0) {
                float damage = 4.0f;
                boolean damageDealt = target.method_5643(this.spider.method_48923().method_48812((class_1309)this.spider), damage);
                if (damageDealt) {
                    double knockbackStrength = targetIsTouchingWeb ? 0.6 : 0.4;
                    target.method_6005(knockbackStrength, -direction.field_1352, -direction.field_1350);
                    this.spider.method_5783(class_3417.field_14657, 1.0f, 1.2f);
                    this.attackCooldown = targetIsTouchingWeb ? 8 : 12;
                }
            }
        } else if (distance > attackRange && distance <= 8.0) {
            this.spider.method_5942().method_6337(target.method_23317(), target.method_23318(), target.method_23321(), currentSpeed);
        }
        int n = maxAttackTime = targetIsTouchingWeb ? 100 : 80;
        if (this.stateTimer >= maxAttackTime) {
            this.transitionToState(SpiderState.COOLDOWN);
        }
    }

    private void handleCooldown(class_1309 target, double distance, boolean targetIsTouchingWeb) {
        this.spider.method_5988().method_6226((class_1297)target, 30.0f, 30.0f);
        double currentSpeed = this.getMovementSpeed(target);
        if (targetIsTouchingWeb) {
            this.transitionToState(SpiderState.CHARGING);
            return;
        }
        if (distance >= 8.0 && this.shouldUseWebBehavior()) {
            this.spider.method_5942().method_6337(target.method_23317(), target.method_23318(), target.method_23321(), currentSpeed);
        } else {
            this.spider.method_5942().method_6340();
        }
        if (this.stateTimer >= 40) {
            this.transitionToState(SpiderState.POSITIONING);
        }
    }

    private void transitionToState(SpiderState newState) {
        this.currentState = newState;
        this.stateTimer = 0;
    }

    public static enum SpiderState {
        POSITIONING,
        SHOOTING,
        CHARGING,
        ATTACKING,
        COOLDOWN,
        POST_WEB_CHASE,
        RETREATING;

    }

    public static enum SpiderRole {
        WEBBER,
        CHASER,
        FLEXIBLE,
        BACKUP_WEBBER,
        BACKUP_CHASER;

    }
}

