/*
 * Decompiled with CFR 0.152.
 */
package potatowolfie.web.entity.custom;

import net.minecraft.class_1266;
import net.minecraft.class_1267;
import net.minecraft.class_1282;
import net.minecraft.class_1291;
import net.minecraft.class_1293;
import net.minecraft.class_1294;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1308;
import net.minecraft.class_1309;
import net.minecraft.class_1314;
import net.minecraft.class_1315;
import net.minecraft.class_1338;
import net.minecraft.class_1347;
import net.minecraft.class_1352;
import net.minecraft.class_1359;
import net.minecraft.class_1361;
import net.minecraft.class_1366;
import net.minecraft.class_1376;
import net.minecraft.class_1394;
import net.minecraft.class_1399;
import net.minecraft.class_1400;
import net.minecraft.class_1408;
import net.minecraft.class_1410;
import net.minecraft.class_1439;
import net.minecraft.class_1588;
import net.minecraft.class_1613;
import net.minecraft.class_1628;
import net.minecraft.class_1657;
import net.minecraft.class_1937;
import net.minecraft.class_2246;
import net.minecraft.class_2338;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_2680;
import net.minecraft.class_2940;
import net.minecraft.class_2941;
import net.minecraft.class_2943;
import net.minecraft.class_2945;
import net.minecraft.class_3414;
import net.minecraft.class_3417;
import net.minecraft.class_3730;
import net.minecraft.class_5132;
import net.minecraft.class_5134;
import net.minecraft.class_5425;
import net.minecraft.class_5819;
import net.minecraft.class_6880;
import net.minecraft.class_7094;
import net.minecraft.class_9069;
import org.jetbrains.annotations.Nullable;

public class BabySpiderEntity
extends class_1588 {
    public final class_7094 idleAnimationState = new class_7094();
    public final class_7094 walkingAnimationState = new class_7094();
    private int idleAnimationTimeout = 0;
    private boolean isIdleAnimationRunning = false;
    private boolean isWalkingAnimationRunning = false;
    private boolean animationStartedThisTick = false;
    private static final class_2940<Integer> DATA_ID_STATE = class_2945.method_12791(BabySpiderEntity.class, (class_2941)class_2943.field_13327);
    private SpiderState spiderState = SpiderState.IDLE;
    private SpiderState previousState = SpiderState.IDLE;
    private boolean isChangingState = false;
    private static final class_2940<Byte> SPIDER_FLAGS = class_2945.method_12791(BabySpiderEntity.class, (class_2941)class_2943.field_13319);
    private static final float field_30498 = 0.1f;
    private static final class_2940<Integer> AGE_TICKS = class_2945.method_12791(BabySpiderEntity.class, (class_2941)class_2943.field_13327);
    private static final class_2940<Integer> MATURE_TIME = class_2945.method_12791(BabySpiderEntity.class, (class_2941)class_2943.field_13327);
    private static final int MIN_MATURE_TIME = 18000;
    private static final int MAX_MATURE_TIME = 26400;
    private int climbingStateCooldown = 0;
    private int collisionCheckTicks = 0;
    private boolean stableHorizontalCollision = false;

    public BabySpiderEntity(class_1299<? extends BabySpiderEntity> entityType, class_1937 world) {
        super(entityType, world);
    }

    protected void method_5959() {
        this.field_6201.method_6277(1, (class_1352)new class_1347((class_1308)this));
        this.field_6201.method_6277(2, (class_1352)new class_1338((class_1314)this, class_9069.class, 6.0f, 1.0, 1.2, entity -> !((class_9069)entity).method_55723()));
        this.field_6201.method_6277(3, (class_1352)new class_1359((class_1308)this, 0.4f));
        this.field_6201.method_6277(4, (class_1352)new AttackGoal(this));
        this.field_6201.method_6277(5, (class_1352)new class_1394((class_1314)this, 0.8));
        this.field_6201.method_6277(6, (class_1352)new class_1361((class_1308)this, class_1657.class, 8.0f));
        this.field_6201.method_6277(7, (class_1352)new class_1376((class_1308)this));
        this.field_6185.method_6277(1, (class_1352)new class_1399((class_1314)this, new Class[0]));
        this.field_6185.method_6277(2, new TargetGoal<class_1657>(this, class_1657.class));
        this.field_6185.method_6277(3, new TargetGoal<class_1439>(this, class_1439.class));
    }

    protected class_1408 method_5965(class_1937 world) {
        return new class_1410(this, (class_1308)this, world){

            public void method_6360() {
                super.method_6360();
                if (this.method_6357() && this.field_6684.field_6012 % 20 == 0) {
                    this.method_6340();
                }
            }
        };
    }

    protected void method_5693(class_2945.class_9222 builder) {
        super.method_5693(builder);
        builder.method_56912(SPIDER_FLAGS, (Object)0);
        builder.method_56912(AGE_TICKS, (Object)0);
        builder.method_56912(MATURE_TIME, (Object)-1);
        builder.method_56912(DATA_ID_STATE, (Object)SpiderState.IDLE.ordinal());
    }

    private void updateAnimations() {
        if (this.method_5770().method_8608()) {
            if (this.spiderState == SpiderState.WALKING) {
                if (!this.isWalkingAnimationRunning) {
                    this.walkingAnimationState.method_41322(this.field_6012);
                    this.isWalkingAnimationRunning = true;
                    this.isIdleAnimationRunning = false;
                }
            } else if (this.spiderState == SpiderState.IDLE && !this.isIdleAnimationRunning) {
                --this.idleAnimationTimeout;
                if (this.idleAnimationTimeout <= 0) {
                    this.idleAnimationTimeout = this.field_5974.method_43048(40) + 80;
                    this.idleAnimationState.method_41322(this.field_6012);
                    this.isIdleAnimationRunning = true;
                    this.isWalkingAnimationRunning = false;
                }
            }
            if (this.spiderState != SpiderState.IDLE && this.isIdleAnimationRunning) {
                this.idleAnimationState.method_41325();
                this.isIdleAnimationRunning = false;
                this.idleAnimationTimeout = 0;
            }
            if (this.spiderState != SpiderState.WALKING && this.isWalkingAnimationRunning) {
                this.walkingAnimationState.method_41325();
                this.isWalkingAnimationRunning = false;
            }
        }
    }

    public SpiderState getSpiderState() {
        return this.spiderState;
    }

    public SpiderState getPreviousState() {
        return this.previousState;
    }

    public void setSpiderState(SpiderState newState) {
        if (this.spiderState != newState && !this.isChangingState) {
            this.isChangingState = true;
            this.previousState = this.spiderState;
            this.spiderState = newState;
            if (!this.method_5770().method_8608()) {
                this.field_6011.method_12778(DATA_ID_STATE, (Object)newState.ordinal());
            } else {
                this.startStateAnimation(newState);
            }
            this.isChangingState = false;
        }
    }

    private void startStateAnimation(SpiderState state) {
        if (!this.method_5770().method_8608() || this.animationStartedThisTick) {
            return;
        }
        this.animationStartedThisTick = true;
        switch (state.ordinal()) {
            case 0: {
                this.stopAllAnimations();
                this.idleAnimationTimeout = this.field_5974.method_43048(40) + 80;
                this.idleAnimationState.method_41322(this.field_6012);
                this.isIdleAnimationRunning = true;
                this.isWalkingAnimationRunning = false;
                break;
            }
            case 1: {
                this.stopAllAnimations();
                this.walkingAnimationState.method_41322(this.field_6012);
                this.isWalkingAnimationRunning = true;
                this.isIdleAnimationRunning = false;
            }
        }
    }

    private void stopAllAnimations() {
        if (this.method_5770().method_8608()) {
            this.idleAnimationState.method_41325();
            this.walkingAnimationState.method_41325();
        }
    }

    public void method_5674(class_2940<?> data) {
        SpiderState newState;
        if (DATA_ID_STATE.equals(data) && this.method_5770().method_8608() && this.spiderState != (newState = SpiderState.values()[(Integer)this.field_6011.method_12789(DATA_ID_STATE)]) && !this.isChangingState) {
            this.isChangingState = true;
            this.previousState = this.spiderState;
            this.spiderState = newState;
            this.startStateAnimation(newState);
            this.isChangingState = false;
        }
        super.method_5674(data);
    }

    public void method_5773() {
        if (this.method_31481() || this.method_5770() == null) {
            return;
        }
        this.animationStartedThisTick = false;
        super.method_5773();
        if (!this.method_5770().method_8608()) {
            this.setClimbingWall(this.field_5976);
            if (this.method_5942().method_6357() && this.field_6012 % 20 == 0) {
                this.method_5942().method_6340();
            }
            int currentAge = (Integer)this.field_6011.method_12789(AGE_TICKS);
            this.field_6011.method_12778(AGE_TICKS, (Object)(currentAge + 1));
            int matureTime = (Integer)this.field_6011.method_12789(MATURE_TIME);
            if (matureTime > 0 && currentAge >= matureTime) {
                this.matureIntoSpider();
            }
        }
        try {
            this.updateAnimations();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void method_6007() {
        boolean isMoving;
        super.method_6007();
        boolean bl = isMoving = this.method_18798().method_37267() > 0.01;
        if (isMoving) {
            if (this.spiderState != SpiderState.WALKING) {
                this.setSpiderState(SpiderState.WALKING);
            }
        } else if (this.spiderState != SpiderState.IDLE) {
            this.setSpiderState(SpiderState.IDLE);
        }
    }

    private void matureIntoSpider() {
        if (this.method_5770().method_8608()) {
            return;
        }
        try {
            class_1628 adultSpider = (class_1628)class_1299.field_6079.method_5883(this.method_5770(), class_3730.field_16468);
            if (adultSpider != null) {
                adultSpider.method_5808(this.method_23317(), this.method_23318(), this.method_23321(), this.method_36454(), this.method_36455());
                adultSpider.method_18799(this.method_18798());
                float healthPercentage = this.method_6032() / this.method_6063();
                adultSpider.method_6033(adultSpider.method_6063() * healthPercentage);
                for (class_1293 effect : this.method_6026()) {
                    adultSpider.method_6092(new class_1293(effect));
                }
                if (this.method_16914()) {
                    adultSpider.method_5665(this.method_5797());
                    adultSpider.method_5880(this.method_5807());
                }
                if (this.method_5782()) {
                    for (class_1297 passenger : this.method_5685()) {
                        passenger.method_5848();
                        passenger.method_5804((class_1297)adultSpider);
                    }
                }
                this.method_5770().method_8649((class_1297)adultSpider);
                this.method_31472();
            }
        }
        catch (Exception e) {
            System.err.println("Error during spider maturation: " + e.getMessage());
            e.printStackTrace();
        }
    }

    public void forceMature() {
        if (!this.method_5770().method_8608()) {
            this.matureIntoSpider();
        }
    }

    public static class_5132.class_5133 createSpiderAttributes() {
        return class_1588.method_26918().method_26868(class_5134.field_23716, 10.0).method_26868(class_5134.field_23719, 0.5).method_26868(class_5134.field_23728, 0.42);
    }

    protected class_3414 method_5994() {
        return class_3417.field_15170;
    }

    protected class_3414 method_6011(class_1282 source) {
        return class_3417.field_14657;
    }

    protected class_3414 method_6002() {
        return class_3417.field_14579;
    }

    protected void method_5712(class_2338 pos, class_2680 state) {
        this.method_5783(class_3417.field_14760, 0.15f, 1.0f);
    }

    public boolean method_6101() {
        return this.isClimbingWall();
    }

    public void method_5844(class_2680 state, class_243 multiplier) {
        if (!state.method_27852(class_2246.field_10343)) {
            super.method_5844(state, multiplier);
        }
    }

    public boolean method_6049(class_1293 effect) {
        return !effect.method_55654(class_1294.field_5899) && super.method_6049(effect);
    }

    public boolean isClimbingWall() {
        return ((Byte)this.field_6011.method_12789(SPIDER_FLAGS) & 1) != 0;
    }

    public void setClimbingWall(boolean climbing) {
        byte b = (Byte)this.field_6011.method_12789(SPIDER_FLAGS);
        b = climbing ? (byte)(b | 1) : (byte)(b & 0xFFFFFFFE);
        this.field_6011.method_12778(SPIDER_FLAGS, (Object)b);
    }

    @Nullable
    public class_1315 method_5943(class_5425 world, class_1266 difficulty, class_3730 spawnReason, @Nullable class_1315 entityData) {
        class_1613 skeletonEntity;
        class_1315 result = super.method_5943(world, difficulty, spawnReason, entityData);
        class_5819 random = world.method_8409();
        int matureTime = 18000 + random.method_43048(8401);
        this.field_6011.method_12778(MATURE_TIME, (Object)matureTime);
        class_5819 spawnRandom = world.method_8409();
        if (spawnRandom.method_43048(100) == 0 && (skeletonEntity = (class_1613)class_1299.field_6137.method_5883(this.method_5770(), class_3730.field_16460)) != null) {
            skeletonEntity.method_5808(this.method_23317(), this.method_23318(), this.method_23321(), this.method_36454(), 0.0f);
            skeletonEntity.method_5943(world, difficulty, spawnReason, null);
            skeletonEntity.method_5804((class_1297)this);
        }
        if (entityData == null) {
            entityData = new SpiderData();
            if (world.method_8407() == class_1267.field_5807 && spawnRandom.method_43057() < 0.05f * difficulty.method_5458()) {
                ((SpiderData)entityData).setEffect(spawnRandom);
            }
        }
        if (entityData instanceof SpiderData) {
            SpiderData spiderData = (SpiderData)entityData;
            class_6880<class_1291> registryEntry = spiderData.effect;
            if (registryEntry != null) {
                this.method_6092(new class_1293(registryEntry, -1));
            }
        }
        return result;
    }

    public class_243 method_55668(class_1297 vehicle) {
        return vehicle.method_17681() <= this.method_17681() ? new class_243(0.0, 0.9125 * (double)this.method_55693(), 0.0) : super.method_55668(vehicle);
    }

    public void method_5652(class_2487 nbt) {
        super.method_5652(nbt);
        nbt.method_10582("SpiderState", this.spiderState.name());
        nbt.method_10569("AgeTicks", ((Integer)this.field_6011.method_12789(AGE_TICKS)).intValue());
        nbt.method_10569("MatureTime", ((Integer)this.field_6011.method_12789(MATURE_TIME)).intValue());
    }

    public void method_5749(class_2487 nbt) {
        int matureTime;
        int ageTicks;
        super.method_5749(nbt);
        String stateString = nbt.method_10558("SpiderState").orElse("IDLE");
        if (!stateString.equals("IDLE")) {
            try {
                SpiderState loadedState;
                this.spiderState = loadedState = SpiderState.valueOf(stateString);
                if (!this.method_5770().method_8608()) {
                    this.field_6011.method_12778(DATA_ID_STATE, (Object)loadedState.ordinal());
                }
            }
            catch (IllegalArgumentException e) {
                this.spiderState = SpiderState.IDLE;
            }
        }
        if ((ageTicks = nbt.method_68083("AgeTicks", 0)) > 0) {
            this.field_6011.method_12778(AGE_TICKS, (Object)ageTicks);
        }
        if ((matureTime = nbt.method_68083("MatureTime", -1)) > 0) {
            this.field_6011.method_12778(MATURE_TIME, (Object)matureTime);
        }
    }

    public static enum SpiderState {
        IDLE,
        WALKING;

    }

    private static class AttackGoal
    extends class_1366 {
        public AttackGoal(BabySpiderEntity spider) {
            super((class_1314)spider, 1.0, true);
        }

        public boolean method_6264() {
            return super.method_6264() && !this.field_6503.method_5782();
        }

        public boolean method_6266() {
            int lightLevel = this.field_6503.method_5770().method_22339(this.field_6503.method_24515());
            float f = (float)lightLevel / 15.0f;
            if (f >= 0.5f && this.field_6503.method_59922().method_43048(100) == 0) {
                this.field_6503.method_5980(null);
                return false;
            }
            return super.method_6266();
        }
    }

    private static class TargetGoal<T extends class_1309>
    extends class_1400<T> {
        public TargetGoal(BabySpiderEntity spider, Class<T> targetEntityClass) {
            super((class_1308)spider, targetEntityClass, true);
        }

        public boolean method_6264() {
            int lightLevel = this.field_6660.method_5770().method_22339(this.field_6660.method_24515());
            float f = (float)lightLevel / 15.0f;
            return !(f >= 0.5f) && super.method_6264();
        }
    }

    public static class SpiderData
    implements class_1315 {
        @Nullable
        public class_6880<class_1291> effect;

        public void setEffect(class_5819 random) {
            int i = random.method_43048(5);
            if (i <= 1) {
                this.effect = class_1294.field_5904;
            } else if (i <= 2) {
                this.effect = class_1294.field_5910;
            } else if (i <= 3) {
                this.effect = class_1294.field_5924;
            } else if (i <= 4) {
                this.effect = class_1294.field_5905;
            }
        }
    }
}

