/*
 * Decompiled with CFR 0.152.
 */
package potatowolfie.web.mixin;

import net.minecraft.class_1299;
import net.minecraft.class_1309;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_243;
import net.minecraft.class_2680;
import net.minecraft.class_2960;
import net.minecraft.class_5321;
import net.minecraft.class_6862;
import net.minecraft.class_7924;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;
import potatowolfie.web.block.custom.SpiderWebBlock;
import potatowolfie.web.entity.custom.SpiderWebEntity;

@Mixin(value={class_1309.class})
public class LivingEntityMixin {
    @Unique
    private static final class_6862<class_1299<?>> WEB_IMMUNE_TAG = class_6862.method_40092((class_5321)class_7924.field_41266, (class_2960)class_2960.method_60655((String)"web", (String)"web_immune"));

    @Unique
    private static boolean isWebImmune(class_1309 entity) {
        return entity.method_5864().method_20210(WEB_IMMUNE_TAG);
    }

    @Inject(method={"travel"}, at={@At(value="HEAD")}, cancellable=true)
    private void preventWebMovement(class_243 movementInput, CallbackInfo ci) {
        class_1309 entity = (class_1309)this;
        if (LivingEntityMixin.isWebImmune(entity)) {
            return;
        }
        if (SpiderWebEntity.shouldPreventMovement(entity)) {
            ci.cancel();
            entity.method_18800(0.0, 0.0, 0.0);
        }
    }

    @Inject(method={"jump"}, at={@At(value="HEAD")}, cancellable=true)
    private void preventWebJumping(CallbackInfo ci) {
        class_1309 entity = (class_1309)this;
        if (LivingEntityMixin.isWebImmune(entity)) {
            return;
        }
        if (SpiderWebEntity.shouldPreventJumping(entity)) {
            ci.cancel();
        }
    }

    @Inject(method={"isClimbing"}, at={@At(value="HEAD")}, cancellable=true)
    private void checkSpiderWebClimbing(CallbackInfoReturnable<Boolean> cir) {
        class_1309 entity = (class_1309)this;
        class_2338 pos = entity.method_24515();
        class_2680 state = entity.method_37908().method_8320(pos);
        class_2248 class_22482 = state.method_26204();
        if (class_22482 instanceof SpiderWebBlock) {
            SpiderWebBlock spiderWebBlock = (SpiderWebBlock)class_22482;
            SpiderWebBlock.WebType webType = (SpiderWebBlock.WebType)((Object)state.method_11654(SpiderWebBlock.WEB_TYPE));
            if (webType != SpiderWebBlock.WebType.GROUND) {
                double centerX = (double)pos.method_10263() + 0.5;
                double centerZ = (double)pos.method_10260() + 0.5;
                double entityX = entity.method_23317();
                double entityZ = entity.method_23321();
                double distanceFromCenter = Math.sqrt(Math.pow(entityX - centerX, 2.0) + Math.pow(entityZ - centerZ, 2.0));
                if (distanceFromCenter <= 0.4) {
                    cir.setReturnValue((Object)true);
                }
            }
        }
    }
}

