/*
 * Decompiled with CFR 0.152.
 */
package potatowolfie.web.world.feature.custom;

import com.mojang.serialization.Codec;
import java.util.HashSet;
import java.util.Set;
import net.minecraft.class_1922;
import net.minecraft.class_2246;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2382;
import net.minecraft.class_2680;
import net.minecraft.class_2741;
import net.minecraft.class_2769;
import net.minecraft.class_3031;
import net.minecraft.class_5281;
import net.minecraft.class_5819;
import net.minecraft.class_5821;
import potatowolfie.web.block.WebBlocks;
import potatowolfie.web.block.custom.SpiderEggShellsBlock;
import potatowolfie.web.block.custom.SpiderWebBlock;
import potatowolfie.web.world.feature.custom.SpiderEggClusterFeatureConfig;

public class SpiderEggClusterFeature
extends class_3031<SpiderEggClusterFeatureConfig> {
    public SpiderEggClusterFeature(Codec<SpiderEggClusterFeatureConfig> codec) {
        super(codec);
    }

    public boolean method_13151(class_5821<SpiderEggClusterFeatureConfig> context) {
        class_2338 floorPos;
        int z;
        int x;
        int i;
        class_5281 world = context.method_33652();
        class_2338 origin = context.method_33655();
        class_5819 random = context.method_33654();
        SpiderEggClusterFeatureConfig config = (SpiderEggClusterFeatureConfig)context.method_33656();
        class_2338 actualOrigin = this.findValidOrigin(world, origin);
        if (actualOrigin == null) {
            return false;
        }
        if (!this.isValidCaveLocation(world, actualOrigin)) {
            return false;
        }
        HashSet<class_2338> mainEggPositions = new HashSet<class_2338>();
        boolean generatedMainNests = this.generateMainNestStructures(world, actualOrigin, random, mainEggPositions);
        if (!generatedMainNests) {
            return false;
        }
        int clusterSize = random.method_39332(22, 45);
        HashSet<class_2338> nestPositions = new HashSet<class_2338>();
        for (i = 0; i < clusterSize; ++i) {
            x = actualOrigin.method_10263() + random.method_39332(-config.nestSpreadRadius(), config.nestSpreadRadius());
            z = actualOrigin.method_10260() + random.method_39332(-config.nestSpreadRadius(), config.nestSpreadRadius());
            floorPos = this.findFloorPosition(world, new class_2338(x, actualOrigin.method_10264(), z));
            if (floorPos == null || !this.canPlaceNest(world, floorPos)) continue;
            world.method_8652(floorPos, WebBlocks.SPIDER_MOSS.method_9564(), 19);
            nestPositions.add(floorPos);
            if (!(random.method_43057() < 0.7f)) continue;
            for (class_2338 nearbyPos : class_2338.method_10097((class_2338)floorPos.method_10069(-3, 0, -3), (class_2338)floorPos.method_10069(3, 0, 3))) {
                if (!(random.method_43057() < 0.4f) || !this.canPlaceNest(world, nearbyPos)) continue;
                world.method_8652(nearbyPos, WebBlocks.SPIDER_MOSS.method_9564(), 19);
                nestPositions.add(nearbyPos.method_10062());
            }
        }
        for (i = 0; i < 18; ++i) {
            x = actualOrigin.method_10263() + random.method_39332(-4, 4);
            z = actualOrigin.method_10260() + random.method_39332(-4, 4);
            floorPos = this.findFloorPosition(world, new class_2338(x, actualOrigin.method_10264(), z));
            if (floorPos == null || !this.canPlaceNest(world, floorPos)) continue;
            world.method_8652(floorPos, WebBlocks.SPIDER_MOSS.method_9564(), 19);
            nestPositions.add(floorPos);
        }
        this.generateEggsOnNests(world, nestPositions, random, config, mainEggPositions);
        this.generateStandaloneEggs(world, actualOrigin, random, nestPositions, mainEggPositions);
        this.generateSpiderWebBlocks(world, actualOrigin, random, nestPositions);
        this.placeSpiderEggShells(world, actualOrigin, nestPositions, random, config);
        return !nestPositions.isEmpty();
    }

    private boolean generateMainNestStructures(class_5281 world, class_2338 origin, class_5819 random, Set<class_2338> mainEggPositions) {
        boolean placedAny = false;
        int attempts = 0;
        int structures = 0;
        while (structures < 2 && attempts < 20) {
            class_2350[] horizontalDirections;
            ++attempts;
            int x = origin.method_10263() + random.method_39332(-6, 6);
            int z = origin.method_10260() + random.method_39332(-6, 6);
            class_2338 floorPos = this.findFloorPosition(world, new class_2338(x, origin.method_10264(), z));
            if (floorPos == null || !this.canPlaceNest(world, floorPos)) continue;
            world.method_8652(floorPos, WebBlocks.SPIDER_MOSS.method_9564(), 19);
            class_2338 topNestPos = floorPos.method_10084();
            if (!world.method_8320(topNestPos).method_26215()) continue;
            world.method_8652(topNestPos, WebBlocks.SPIDER_MOSS.method_9564(), 19);
            class_2338 topEggPos = topNestPos.method_10084();
            if (world.method_8320(topEggPos).method_26215()) {
                world.method_8652(topEggPos, WebBlocks.SPIDER_EGG.method_9564(), 3);
                mainEggPositions.add(topEggPos);
            }
            for (class_2350 direction : horizontalDirections = new class_2350[]{class_2350.field_11043, class_2350.field_11035, class_2350.field_11034, class_2350.field_11039}) {
                class_2338 sidePos = floorPos.method_10093(direction);
                class_2338 sideEggPos = sidePos.method_10084();
                if (!world.method_8320(sideEggPos).method_26215() || !this.canReplaceForNest(world.method_8320(sidePos))) continue;
                world.method_8652(sideEggPos, WebBlocks.SPIDER_EGG.method_9564(), 3);
                mainEggPositions.add(sideEggPos);
            }
            ++structures;
            placedAny = true;
        }
        return placedAny;
    }

    private void generateEggsOnNests(class_5281 world, Set<class_2338> nestPositions, class_5819 random, SpiderEggClusterFeatureConfig config, Set<class_2338> mainEggPositions) {
        int maxEggs = Math.max(6, nestPositions.size() / 4);
        int eggsPlaced = 0;
        HashSet<class_2338> usedEggPositions = new HashSet<class_2338>(mainEggPositions);
        for (class_2338 nestPos : nestPositions) {
            if (eggsPlaced >= maxEggs) break;
            class_2338 eggPos = nestPos.method_10084();
            if (mainEggPositions.contains(eggPos) || !(random.method_43057() < config.eggChance() * 1.2f) || !world.method_8320(eggPos).method_26215()) continue;
            boolean canPlace = true;
            for (class_2338 usedPos : usedEggPositions) {
                double distance = Math.sqrt(eggPos.method_10262((class_2382)usedPos));
                if (!(distance < 2.5)) continue;
                canPlace = false;
                break;
            }
            if (!canPlace) continue;
            world.method_8652(eggPos, WebBlocks.SPIDER_EGG.method_9564(), 3);
            usedEggPositions.add(eggPos);
            ++eggsPlaced;
        }
    }

    private void generateStandaloneEggs(class_5281 world, class_2338 origin, class_5819 random, Set<class_2338> nestPositions, Set<class_2338> mainStructurePositions) {
        HashSet<class_2338> usedEggPositions = new HashSet<class_2338>(mainStructurePositions);
        for (class_2338 nestPos : nestPositions) {
            class_2338 eggPos = nestPos.method_10084();
            if (!world.method_8320(eggPos).method_27852(WebBlocks.SPIDER_EGG)) continue;
            usedEggPositions.add(eggPos);
        }
        for (int i = 0; i < 3; ++i) {
            int x = origin.method_10263() + random.method_39332(-5, 5);
            int z = origin.method_10260() + random.method_39332(-5, 5);
            class_2338 centerPos = new class_2338(x, origin.method_10264(), z);
            class_2338 eggPos = this.findFloorPosition(world, centerPos);
            if (eggPos == null || !world.method_8320(eggPos.method_10084()).method_26215() || mainStructurePositions.contains(eggPos.method_10084())) continue;
            boolean canPlace = true;
            for (class_2338 usedPos : usedEggPositions) {
                double distance = Math.sqrt(eggPos.method_10084().method_10262((class_2382)usedPos));
                if (!(distance < 2.5)) continue;
                canPlace = false;
                break;
            }
            if (!canPlace) continue;
            world.method_8652(eggPos.method_10084(), WebBlocks.SPIDER_EGG.method_9564(), 3);
            usedEggPositions.add(eggPos.method_10084());
        }
    }

    private boolean isNearMainStructure(class_2338 pos, Set<class_2338> mainStructurePositions) {
        for (class_2338 structurePos : mainStructurePositions) {
            if (!(pos.method_10262((class_2382)structurePos) <= 9.0)) continue;
            return true;
        }
        return false;
    }

    private void generateSpiderWebBlocks(class_5281 world, class_2338 origin, class_5819 random, Set<class_2338> nestPositions) {
        if (random.method_43057() < 0.3f) {
            this.generateHangingWebs(world, origin, random);
            int webCount = random.method_39332(2, 3);
            int webBlocksPlaced = 0;
            for (int attempts = 0; attempts < 15 && webBlocksPlaced < webCount; ++attempts) {
                int z;
                int y;
                int x = origin.method_10263() + random.method_39332(-8, 8);
                class_2338 webPos = new class_2338(x, y = origin.method_10264() + random.method_39332(-2, 4), z = origin.method_10260() + random.method_39332(-8, 8));
                if (!world.method_8320(webPos).method_26215() || !this.hasValidWebSupport(world, webPos)) continue;
                class_2680 groundWebState = (class_2680)((class_2680)WebBlocks.SPIDER_WEB_BLOCK.method_9564().method_11657((class_2769)class_2741.field_12525, (Comparable)class_2350.field_11036)).method_11657(SpiderWebBlock.WEB_TYPE, (Comparable)((Object)SpiderWebBlock.WebType.GROUND));
                world.method_8652(webPos, groundWebState, 3);
                ++webBlocksPlaced;
            }
        }
    }

    private void generateHangingWebs(class_5281 world, class_2338 origin, class_5819 random) {
        int hangingWebCount = random.method_39332(4, 7);
        int hangingWebsPlaced = 0;
        for (int attempts = 0; attempts < 20 && hangingWebsPlaced < hangingWebCount; ++attempts) {
            class_2338 webPos;
            int x = origin.method_10263() + random.method_39332(-10, 10);
            int z = origin.method_10260() + random.method_39332(-10, 10);
            class_2338 ceilingPos = this.findCeiling(world, new class_2338(x, origin.method_10264() + 8, z));
            if (ceilingPos == null) continue;
            int webChainLength = random.method_39332(2, 5);
            boolean placedAny = false;
            class_2350 facing = this.getRandomHorizontalDirection(random);
            for (int i = 0; i < webChainLength && world.method_8320(webPos = ceilingPos.method_10087(i + 1)).method_26215() && webPos.method_10264() > origin.method_10264() - 3 && !world.method_8320(webPos.method_10074()).method_27852(WebBlocks.SPIDER_EGG); ++i) {
                SpiderWebBlock.WebType webType = webChainLength == 1 ? SpiderWebBlock.WebType.HANGING_1 : (i == 0 ? SpiderWebBlock.WebType.HANGING_TOP : (i == webChainLength - 1 ? SpiderWebBlock.WebType.HANGING_TIP : SpiderWebBlock.WebType.HANGING_MIDDLE));
                class_2680 hangingWebState = (class_2680)((class_2680)WebBlocks.SPIDER_WEB_BLOCK.method_9564().method_11657((class_2769)class_2741.field_12525, (Comparable)facing)).method_11657(SpiderWebBlock.WEB_TYPE, (Comparable)((Object)webType));
                world.method_8652(webPos, hangingWebState, 3);
                placedAny = true;
            }
            if (!placedAny) continue;
            ++hangingWebsPlaced;
        }
    }

    private class_2350 getRandomHorizontalDirection(class_5819 random) {
        class_2350[] horizontalDirections = new class_2350[]{class_2350.field_11043, class_2350.field_11035, class_2350.field_11034, class_2350.field_11039};
        return horizontalDirections[random.method_43048(horizontalDirections.length)];
    }

    private class_2338 findCeiling(class_5281 world, class_2338 startPos) {
        for (int y = startPos.method_10264(); y <= startPos.method_10264() + 15; ++y) {
            class_2338 belowPos;
            class_2338 checkPos = new class_2338(startPos.method_10263(), y, startPos.method_10260());
            class_2680 state = world.method_8320(checkPos);
            if (!state.method_26212((class_1922)world, checkPos) || !world.method_8320(belowPos = checkPos.method_10074()).method_26215() || !world.method_8320(belowPos.method_10074()).method_26215()) continue;
            return checkPos;
        }
        return null;
    }

    private boolean hasNearbySupport(class_5281 world, class_2338 pos) {
        class_2350[] directions;
        for (class_2350 direction : directions = new class_2350[]{class_2350.field_11036, class_2350.field_11033, class_2350.field_11043, class_2350.field_11035, class_2350.field_11034, class_2350.field_11039}) {
            class_2338 checkPos = pos.method_10093(direction);
            class_2680 state = world.method_8320(checkPos);
            if (!state.method_26212((class_1922)world, checkPos) && !state.method_27852(WebBlocks.SPIDER_MOSS)) continue;
            return true;
        }
        return false;
    }

    private boolean hasValidWebSupport(class_5281 world, class_2338 pos) {
        class_2350[] directions;
        for (class_2350 direction : directions = new class_2350[]{class_2350.field_11036, class_2350.field_11033, class_2350.field_11043, class_2350.field_11035, class_2350.field_11034, class_2350.field_11039}) {
            class_2338 checkPos = pos.method_10093(direction);
            class_2680 state = world.method_8320(checkPos);
            if (!state.method_27852(class_2246.field_28888) && !state.method_27852(class_2246.field_10474) && !state.method_27852(class_2246.field_10508) && !state.method_27852(class_2246.field_10115) && !state.method_27852(class_2246.field_27165) && !state.method_27852(class_2246.field_10445) && !state.method_27852(class_2246.field_29031) && !state.method_27852(class_2246.field_10255) && !state.method_27852(class_2246.field_10566) && !state.method_27852(class_2246.field_10253) && !state.method_27852(class_2246.field_28681) && !state.method_27852(class_2246.field_10460) && !state.method_27852(WebBlocks.SPIDER_MOSS)) continue;
            return true;
        }
        return false;
    }

    private class_2338 findValidOrigin(class_5281 world, class_2338 startPos) {
        if (!world.method_8320(startPos).method_26215() || this.isValidCaveLocation(world, startPos)) {
            return startPos;
        }
        for (int y = startPos.method_10264(); y >= -64; --y) {
            class_2338 checkPos = new class_2338(startPos.method_10263(), y, startPos.method_10260());
            if (this.isValidCaveLocation(world, checkPos)) {
                return checkPos;
            }
            if (world.method_8320(checkPos).method_26215()) continue;
            for (int offset = 1; offset <= 5; ++offset) {
                class_2338 cavePos = checkPos.method_10086(offset);
                if (!this.isValidCaveLocation(world, cavePos)) continue;
                return cavePos;
            }
        }
        return null;
    }

    private boolean isValidCaveLocation(class_5281 world, class_2338 pos) {
        if (pos.method_10264() > 55) {
            return false;
        }
        if (!world.method_8320(pos).method_26215()) {
            return false;
        }
        int solidBlocks = 0;
        int airBlocks = 0;
        for (class_2338 checkPos : class_2338.method_10097((class_2338)pos.method_10069(-2, -1, -2), (class_2338)pos.method_10069(2, 1, 2))) {
            class_2680 state = world.method_8320(checkPos);
            if (state.method_26215()) {
                ++airBlocks;
                continue;
            }
            if (!state.method_26212((class_1922)world, checkPos)) continue;
            ++solidBlocks;
        }
        return airBlocks >= 5 && solidBlocks >= 8;
    }

    private class_2338 findFloorPosition(class_5281 world, class_2338 startPos) {
        for (int y = startPos.method_10264() + 5; y >= startPos.method_10264() - 15; --y) {
            class_2338 checkPos = new class_2338(startPos.method_10263(), y, startPos.method_10260());
            class_2680 floorState = world.method_8320(checkPos);
            class_2680 aboveState = world.method_8320(checkPos.method_10084());
            if (!this.canReplaceForNest(floorState) || !aboveState.method_26215()) continue;
            return checkPos;
        }
        return null;
    }

    private boolean canPlaceNest(class_5281 world, class_2338 pos) {
        class_2680 floorState = world.method_8320(pos);
        class_2680 aboveState = world.method_8320(pos.method_10084());
        return this.canReplaceForNest(floorState) && aboveState.method_26215();
    }

    private boolean canReplaceForNest(class_2680 state) {
        return state.method_27852(class_2246.field_10340) || state.method_27852(class_2246.field_28888) || state.method_27852(class_2246.field_10474) || state.method_27852(class_2246.field_10508) || state.method_27852(class_2246.field_10115) || state.method_27852(class_2246.field_27165) || state.method_27852(class_2246.field_10445) || state.method_27852(class_2246.field_29031) || state.method_27852(class_2246.field_10255) || state.method_27852(class_2246.field_10566) || state.method_27852(class_2246.field_28681) || state.method_27852(class_2246.field_10460) || state.method_27852(class_2246.field_10253) || state.method_27852(class_2246.field_27114) || state.method_27852(class_2246.field_29032) || state.method_27852(class_2246.field_27159);
    }

    private void placeSpiderEggShells(class_5281 world, class_2338 origin, Set<class_2338> nestPositions, class_5819 random, SpiderEggClusterFeatureConfig config) {
        int shellRadius = config.nestSpreadRadius() + 4;
        int guaranteedShells = Math.max(10, nestPositions.size() / 3);
        int shellsPlaced = 0;
        for (int attempts = 0; attempts < 80 && shellsPlaced < guaranteedShells + 20; ++attempts) {
            float chance;
            int x = origin.method_10263() + random.method_39332(-shellRadius, shellRadius);
            int y = origin.method_10264() + random.method_39332(-4, 5);
            int z = origin.method_10260() + random.method_39332(-shellRadius, shellRadius);
            class_2338 shellPos = new class_2338(x, y, z);
            float f = chance = shellsPlaced < guaranteedShells ? 0.85f : 0.6f;
            if (!(random.method_43057() < chance) || !this.tryPlaceShellOnSurface(world, shellPos, random)) continue;
            ++shellsPlaced;
        }
        int nestsWithShells = 0;
        int targetNestsWithShells = Math.max(5, nestPositions.size() / 3);
        for (class_2338 nestPos : nestPositions) {
            if (nestsWithShells >= targetNestsWithShells) break;
            boolean shouldPlaceShells = nestsWithShells < targetNestsWithShells / 2 || random.method_43057() < 0.6f;
            if (!shouldPlaceShells) continue;
            int shellCount = random.method_39332(1, 4);
            for (int i = 0; i < shellCount; ++i) {
                int x = nestPos.method_10263() + random.method_39332(-5, 5);
                int y = nestPos.method_10264() + random.method_39332(-3, 4);
                int z = nestPos.method_10260() + random.method_39332(-5, 5);
                class_2338 shellPos = new class_2338(x, y, z);
                this.tryPlaceShellOnSurface(world, shellPos, random);
            }
            ++nestsWithShells;
        }
    }

    private boolean tryPlaceShellOnSurface(class_5281 world, class_2338 pos, class_5819 random) {
        class_2350[] directions;
        if (!world.method_8320(pos).method_26215()) {
            return false;
        }
        for (class_2350 direction : directions = new class_2350[]{class_2350.field_11033, class_2350.field_11043, class_2350.field_11035, class_2350.field_11034, class_2350.field_11039, class_2350.field_11036}) {
            class_2338 attachPos = pos.method_10093(direction);
            class_2680 attachState = world.method_8320(attachPos);
            if (!this.canAttachShellTo(attachState)) continue;
            SpiderEggShellsBlock shellBlock = (SpiderEggShellsBlock)WebBlocks.SPIDER_EGG_SHELLS;
            class_2680 shellState = shellBlock.method_9564();
            switch (direction) {
                case field_11033: {
                    shellState = (class_2680)shellState.method_11657((class_2769)class_2741.field_12546, (Comparable)Boolean.valueOf(true));
                    break;
                }
                case field_11036: {
                    shellState = (class_2680)shellState.method_11657((class_2769)class_2741.field_12519, (Comparable)Boolean.valueOf(true));
                    break;
                }
                case field_11043: {
                    shellState = (class_2680)shellState.method_11657((class_2769)class_2741.field_12489, (Comparable)Boolean.valueOf(true));
                    break;
                }
                case field_11035: {
                    shellState = (class_2680)shellState.method_11657((class_2769)class_2741.field_12540, (Comparable)Boolean.valueOf(true));
                    break;
                }
                case field_11034: {
                    shellState = (class_2680)shellState.method_11657((class_2769)class_2741.field_12487, (Comparable)Boolean.valueOf(true));
                    break;
                }
                case field_11039: {
                    shellState = (class_2680)shellState.method_11657((class_2769)class_2741.field_12527, (Comparable)Boolean.valueOf(true));
                }
            }
            shellState = shellBlock.getInitializedState(shellState, random);
            world.method_8652(pos, shellState, 3);
            return true;
        }
        return false;
    }

    private boolean canAttachShellTo(class_2680 state) {
        return state.method_27852(class_2246.field_10340) || state.method_27852(class_2246.field_28888) || state.method_27852(class_2246.field_10474) || state.method_27852(class_2246.field_10508) || state.method_27852(class_2246.field_10115) || state.method_27852(class_2246.field_27165) || state.method_27852(class_2246.field_10445) || state.method_27852(class_2246.field_29031) || state.method_27852(class_2246.field_10255) || state.method_27852(class_2246.field_10566) || state.method_27852(class_2246.field_10253) || state.method_27852(class_2246.field_28681) || state.method_27852(class_2246.field_10460) || state.method_27852(WebBlocks.SPIDER_MOSS);
    }
}

