/*
 * Decompiled with CFR 0.152.
 */
package potatowolfie.web.block.custom;

import com.mojang.serialization.MapCodec;
import net.minecraft.class_10;
import net.minecraft.class_10225;
import net.minecraft.class_1294;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1750;
import net.minecraft.class_1799;
import net.minecraft.class_1922;
import net.minecraft.class_1935;
import net.minecraft.class_1936;
import net.minecraft.class_1937;
import net.minecraft.class_2237;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_243;
import net.minecraft.class_2464;
import net.minecraft.class_2586;
import net.minecraft.class_265;
import net.minecraft.class_2680;
import net.minecraft.class_2689;
import net.minecraft.class_2741;
import net.minecraft.class_2754;
import net.minecraft.class_2769;
import net.minecraft.class_3218;
import net.minecraft.class_3542;
import net.minecraft.class_3726;
import net.minecraft.class_4538;
import net.minecraft.class_4970;
import net.minecraft.class_5819;
import org.jetbrains.annotations.Nullable;
import potatowolfie.web.entity.custom.SpiderWebBlockEntity;
import potatowolfie.web.item.WebItems;

public class SpiderWebBlock
extends class_2237 {
    public static final MapCodec<SpiderWebBlock> CODEC = SpiderWebBlock.method_54094(SpiderWebBlock::new);
    public static final class_2754<WebType> WEB_TYPE = class_2754.method_11850((String)"web_type", WebType.class);
    private static final class_265 GROUND_SHAPE = class_2248.method_9541((double)-10.0, (double)0.0, (double)-10.0, (double)26.0, (double)8.0, (double)26.0);
    private static final class_265 HANGING_SHAPE_NS = class_2248.method_9541((double)0.0, (double)0.0, (double)6.0, (double)16.0, (double)16.0, (double)10.0);
    private static final class_265 HANGING_SHAPE_EW = class_2248.method_9541((double)6.0, (double)0.0, (double)0.0, (double)10.0, (double)16.0, (double)16.0);
    private static final class_265 HANGING_1_SHAPE_NS = class_2248.method_9541((double)0.0, (double)2.0, (double)6.0, (double)16.0, (double)16.0, (double)10.0);
    private static final class_265 HANGING_1_SHAPE_EW = class_2248.method_9541((double)6.0, (double)2.0, (double)0.0, (double)10.0, (double)16.0, (double)16.0);
    private static final class_265 HANGING_TIP_SHAPE_NS = class_2248.method_9541((double)0.0, (double)10.0, (double)6.0, (double)16.0, (double)16.0, (double)10.0);
    private static final class_265 HANGING_TIP_SHAPE_EW = class_2248.method_9541((double)6.0, (double)10.0, (double)0.0, (double)10.0, (double)16.0, (double)16.0);

    public MapCodec<SpiderWebBlock> method_53969() {
        return CODEC;
    }

    public SpiderWebBlock(class_4970.class_2251 settings) {
        super(settings);
        this.method_9590((class_2680)((class_2680)((class_2680)this.field_10647.method_11664()).method_11657((class_2769)class_2741.field_12525, (Comparable)class_2350.field_11036)).method_11657(WEB_TYPE, (Comparable)((Object)WebType.GROUND)));
    }

    protected void method_9515(class_2689.class_2690<class_2248, class_2680> builder) {
        builder.method_11667(new class_2769[]{class_2741.field_12525, WEB_TYPE});
    }

    @Nullable
    public class_2586 method_10123(class_2338 pos, class_2680 state) {
        if (state.method_11654(WEB_TYPE) == WebType.GROUND) {
            return new SpiderWebBlockEntity(pos, state);
        }
        return null;
    }

    public class_2464 method_9604(class_2680 state) {
        if (state.method_11654(WEB_TYPE) == WebType.GROUND) {
            return class_2464.field_11455;
        }
        return class_2464.field_11458;
    }

    public class_265 method_9530(class_2680 state, class_1922 world, class_2338 pos, class_3726 context) {
        WebType webType = (WebType)((Object)state.method_11654(WEB_TYPE));
        class_2350 facing = (class_2350)state.method_11654((class_2769)class_2741.field_12525);
        if (webType == WebType.GROUND) {
            return GROUND_SHAPE;
        }
        return switch (webType.ordinal()) {
            case 1 -> {
                switch (facing) {
                    case field_11043: 
                    case field_11035: {
                        yield HANGING_1_SHAPE_NS;
                    }
                    case field_11034: 
                    case field_11039: {
                        yield HANGING_1_SHAPE_EW;
                    }
                }
                yield HANGING_1_SHAPE_NS;
            }
            case 2 -> {
                switch (facing) {
                    case field_11043: 
                    case field_11035: {
                        yield HANGING_SHAPE_NS;
                    }
                    case field_11034: 
                    case field_11039: {
                        yield HANGING_SHAPE_EW;
                    }
                }
                yield HANGING_SHAPE_NS;
            }
            case 3 -> {
                switch (facing) {
                    case field_11043: 
                    case field_11035: {
                        yield HANGING_SHAPE_NS;
                    }
                    case field_11034: 
                    case field_11039: {
                        yield HANGING_SHAPE_EW;
                    }
                }
                yield HANGING_SHAPE_NS;
            }
            case 4 -> {
                switch (facing) {
                    case field_11043: 
                    case field_11035: {
                        yield HANGING_TIP_SHAPE_NS;
                    }
                    case field_11034: 
                    case field_11039: {
                        yield HANGING_TIP_SHAPE_EW;
                    }
                }
                yield HANGING_TIP_SHAPE_NS;
            }
            default -> GROUND_SHAPE;
        };
    }

    public class_2680 method_9605(class_1750 ctx) {
        class_2350 clickedSide = ctx.method_8038();
        class_2338 pos = ctx.method_8037();
        class_1937 world = ctx.method_8045();
        if (clickedSide == class_2350.field_11036) {
            return (class_2680)((class_2680)this.method_9564().method_11657((class_2769)class_2741.field_12525, (Comparable)class_2350.field_11036)).method_11657(WEB_TYPE, (Comparable)((Object)WebType.GROUND));
        }
        if (clickedSide == class_2350.field_11033) {
            class_2350 facingDirection = this.getHangingWebFacing(world, pos, ctx);
            WebType webType = this.determineHangingType(world, pos);
            return (class_2680)((class_2680)this.method_9564().method_11657((class_2769)class_2741.field_12525, (Comparable)facingDirection)).method_11657(WEB_TYPE, (Comparable)((Object)webType));
        }
        if (clickedSide.method_10166().method_10179()) {
            class_2338 belowPos = pos.method_10074();
            class_2680 belowState = world.method_8320(belowPos);
            if (belowState.method_26212((class_1922)world, belowPos) && belowState.method_26204() != this) {
                return (class_2680)((class_2680)this.method_9564().method_11657((class_2769)class_2741.field_12525, (Comparable)class_2350.field_11036)).method_11657(WEB_TYPE, (Comparable)((Object)WebType.GROUND));
            }
            return null;
        }
        return null;
    }

    private class_2350 getHangingWebFacing(class_1937 world, class_2338 pos, class_1750 ctx) {
        class_2338 abovePos = pos.method_10084();
        class_2680 aboveState = world.method_8320(abovePos);
        if (aboveState.method_26204() == this && aboveState.method_11654(WEB_TYPE) != WebType.GROUND) {
            return (class_2350)aboveState.method_11654((class_2769)class_2741.field_12525);
        }
        class_2338 checkPos = abovePos.method_10084();
        for (int i = 0; i < 10 && checkPos.method_10264() < world.method_31605(); ++i) {
            class_2680 checkState = world.method_8320(checkPos);
            if (checkState.method_26204() == this && checkState.method_11654(WEB_TYPE) != WebType.GROUND) {
                return (class_2350)checkState.method_11654((class_2769)class_2741.field_12525);
            }
            if (!checkState.method_26215() && checkState.method_26204() != this) break;
            checkPos = checkPos.method_10084();
        }
        return ctx.method_8042().method_10153();
    }

    private WebType determineHangingType(class_1937 world, class_2338 pos) {
        class_2338 belowPos = pos.method_10074();
        class_2680 belowState = world.method_8320(belowPos);
        if (belowState.method_26204() == this && belowState.method_11654(WEB_TYPE) != WebType.GROUND) {
            WebType belowType = (WebType)((Object)belowState.method_11654(WEB_TYPE));
            if (belowType == WebType.HANGING_1) {
                return WebType.HANGING_TOP;
            }
            return WebType.HANGING_TOP;
        }
        return WebType.HANGING_1;
    }

    protected class_2680 method_9559(class_2680 state, class_4538 world, class_10225 scheduledTickView, class_2338 pos, class_2350 direction, class_2338 neighborPos, class_2680 neighborState, class_5819 random) {
        WebType currentType = (WebType)((Object)state.method_11654(WEB_TYPE));
        if (currentType != WebType.GROUND) {
            if (direction == class_2350.field_11036 && !this.canSupportHangingWeb(world, neighborPos, neighborState)) {
                class_1936 worldAccess;
                if (world instanceof class_1936 && (worldAccess = (class_1936)world) instanceof class_3218) {
                    class_3218 serverWorld = (class_3218)worldAccess;
                    serverWorld.method_64310(pos, (class_2248)this, 1);
                }
                return class_2246.field_10124.method_9564();
            }
            if (world instanceof class_1936) {
                class_1936 worldAccess = (class_1936)world;
                this.updateHangingWebChain(worldAccess, pos);
            }
        }
        return super.method_9559(state, world, scheduledTickView, pos, direction, neighborPos, neighborState, random);
    }

    protected void method_9588(class_2680 state, class_3218 world, class_2338 pos, class_5819 random) {
        if (state.method_11654(WEB_TYPE) != WebType.GROUND) {
            this.breakHangingChain(world, pos);
        }
    }

    private boolean canSupportHangingWeb(class_4538 world, class_2338 pos, class_2680 state) {
        if (state.method_26204() == this) {
            return state.method_11654(WEB_TYPE) != WebType.GROUND;
        }
        return state.method_26212((class_1922)world, pos);
    }

    private void breakHangingChain(class_3218 world, class_2338 startPos) {
        class_2338 currentPos = startPos;
        while (world.method_8320(currentPos).method_26204() == this && world.method_8320(currentPos).method_11654(WEB_TYPE) != WebType.GROUND) {
            world.method_22352(currentPos, true);
            currentPos = currentPos.method_10074();
        }
    }

    private void updateHangingWebChain(class_1936 world, class_2338 startPos) {
        class_2338 topPos;
        class_2338 currentPos = topPos = this.findTopOfChain(world, startPos);
        int chainIndex = 0;
        while (world.method_8320(currentPos).method_26204() == this && world.method_8320(currentPos).method_11654(WEB_TYPE) != WebType.GROUND) {
            boolean hasBelow;
            class_2338 belowPos = currentPos.method_10074();
            boolean bl = hasBelow = world.method_8320(belowPos).method_26204() == this && world.method_8320(belowPos).method_11654(WEB_TYPE) != WebType.GROUND;
            WebType newType = chainIndex == 0 && hasBelow ? WebType.HANGING_TOP : (chainIndex == 0 && !hasBelow ? WebType.HANGING_1 : (!hasBelow ? WebType.HANGING_TIP : WebType.HANGING_MIDDLE));
            class_2680 currentState = world.method_8320(currentPos);
            class_2680 newState = (class_2680)currentState.method_11657(WEB_TYPE, (Comparable)((Object)newType));
            world.method_8652(currentPos, newState, 3);
            currentPos = currentPos.method_10074();
            ++chainIndex;
        }
    }

    private class_2338 findTopOfChain(class_1936 world, class_2338 pos) {
        class_2338 above;
        class_2680 aboveState;
        class_2338 current = pos;
        while ((aboveState = world.method_8320(above = current.method_10084())).method_26204() == this && aboveState.method_11654(WEB_TYPE) != WebType.GROUND) {
            current = above;
        }
        return current;
    }

    protected void method_9548(class_2680 state, class_1937 world, class_2338 pos, class_1297 entity) {
        WebType webType = (WebType)((Object)state.method_11654(WEB_TYPE));
        if (webType == WebType.GROUND) {
            class_1309 livingEntity;
            class_243 vec3d = new class_243(0.25, (double)0.05f, 0.25);
            if (entity instanceof class_1309 && (livingEntity = (class_1309)entity).method_6059(class_1294.field_50119)) {
                vec3d = new class_243(0.5, 0.25, 0.5);
            }
            entity.method_5844(state, vec3d);
        }
    }

    protected boolean method_9516(class_2680 state, class_10 type) {
        return false;
    }

    public boolean isInClimbableTag(class_2680 state) {
        return state.method_11654(WEB_TYPE) != WebType.GROUND;
    }

    public class_1799 method_9574(class_4538 world, class_2338 pos, class_2680 state) {
        return new class_1799((class_1935)this);
    }

    public class_1799 getSpiderWebItem() {
        return new class_1799((class_1935)WebItems.SPIDER_WEB);
    }

    public static enum WebType implements class_3542
    {
        GROUND("ground"),
        HANGING_1("hanging_1"),
        HANGING_TOP("hanging_top"),
        HANGING_MIDDLE("hanging_middle"),
        HANGING_TIP("hanging_tip");

        private final String name;

        private WebType(String name) {
            this.name = name;
        }

        public String method_15434() {
            return this.name;
        }
    }
}

