/*
 * Decompiled with CFR 0.152.
 */
package potatowolfie.web.mixin;

import net.minecraft.class_1549;
import net.minecraft.class_1628;
import net.minecraft.class_1937;
import net.minecraft.class_2487;
import net.minecraft.class_2940;
import net.minecraft.class_2941;
import net.minecraft.class_2943;
import net.minecraft.class_2945;
import net.minecraft.class_7094;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import potatowolfie.web.enums.CaveSpiderState;
import potatowolfie.web.interfaces.CaveSpiderAnimationInterface;

@Mixin(value={class_1628.class})
public class CaveSpiderAnimationMixin
implements CaveSpiderAnimationInterface {
    @Unique
    public final class_7094 caveSpiderIdleAnimationState = new class_7094();
    @Unique
    public final class_7094 caveSpiderWalkingAnimationState = new class_7094();
    @Unique
    private int caveSpiderIdleAnimationTimeout = 0;
    @Unique
    private boolean isCaveSpiderIdleAnimationRunning = false;
    @Unique
    private boolean isCaveSpiderWalkingAnimationRunning = false;
    @Unique
    private boolean isCaveSpiderChangingState = false;
    @Unique
    private boolean caveSpiderAnimationStartedThisTick = false;
    @Unique
    private static final class_2940<Integer> CAVE_SPIDER_DATA_ID_STATE = class_2945.method_12791(class_1549.class, (class_2941)class_2943.field_13327);
    @Unique
    private CaveSpiderState caveSpiderState = CaveSpiderState.IDLE;
    @Unique
    private CaveSpiderState previousCaveSpiderState = CaveSpiderState.IDLE;

    @Inject(method={"initDataTracker"}, at={@At(value="TAIL")})
    private void addCaveSpiderAnimationDataTracker(class_2945.class_9222 builder, CallbackInfo ci) {
        class_1628 spider = (class_1628)this;
        if (spider instanceof class_1549) {
            builder.method_56912(CAVE_SPIDER_DATA_ID_STATE, (Object)CaveSpiderState.IDLE.ordinal());
        }
    }

    @Inject(method={"tick"}, at={@At(value="HEAD")})
    private void onCaveSpiderTick(CallbackInfo ci) {
        boolean isMoving;
        class_1628 spider = (class_1628)this;
        if (!(spider instanceof class_1549)) {
            return;
        }
        class_1549 caveSpider = (class_1549)spider;
        class_1937 world = caveSpider.method_5770();
        if (caveSpider.method_31481() || world == null) {
            return;
        }
        this.caveSpiderAnimationStartedThisTick = false;
        boolean bl = isMoving = caveSpider.method_18798().method_37267() > 0.01;
        if (isMoving) {
            if (this.caveSpiderState != CaveSpiderState.WALKING) {
                this.setCaveSpiderState(CaveSpiderState.WALKING, caveSpider);
            }
        } else if (this.caveSpiderState != CaveSpiderState.IDLE) {
            this.setCaveSpiderState(CaveSpiderState.IDLE, caveSpider);
        }
        if (world.method_8608()) {
            this.updateCaveSpiderAnimations(caveSpider);
        }
    }

    @Unique
    private void updateCaveSpiderAnimations(class_1549 caveSpider) {
        if (this.caveSpiderState == CaveSpiderState.WALKING) {
            if (!this.isCaveSpiderWalkingAnimationRunning) {
                this.caveSpiderIdleAnimationState.method_41325();
                this.isCaveSpiderIdleAnimationRunning = false;
                this.caveSpiderIdleAnimationTimeout = 0;
                this.caveSpiderWalkingAnimationState.method_41322(caveSpider.field_6012);
                this.isCaveSpiderWalkingAnimationRunning = true;
            }
        } else if (this.caveSpiderState == CaveSpiderState.IDLE && !this.isCaveSpiderIdleAnimationRunning) {
            --this.caveSpiderIdleAnimationTimeout;
            if (this.caveSpiderIdleAnimationTimeout <= 0) {
                this.caveSpiderWalkingAnimationState.method_41325();
                this.isCaveSpiderWalkingAnimationRunning = false;
                this.caveSpiderIdleAnimationTimeout = caveSpider.method_59922().method_43048(40) + 80;
                this.caveSpiderIdleAnimationState.method_41322(caveSpider.field_6012);
                this.isCaveSpiderIdleAnimationRunning = true;
            }
        }
    }

    @Unique
    private void setCaveSpiderState(CaveSpiderState newState, class_1549 caveSpider) {
        class_1937 world = caveSpider.method_5770();
        if (world == null || this.caveSpiderState == newState || this.isCaveSpiderChangingState) {
            return;
        }
        this.isCaveSpiderChangingState = true;
        this.previousCaveSpiderState = this.caveSpiderState;
        this.caveSpiderState = newState;
        if (!world.method_8608()) {
            caveSpider.method_5841().method_12778(CAVE_SPIDER_DATA_ID_STATE, (Object)newState.ordinal());
        }
        this.isCaveSpiderChangingState = false;
    }

    @Override
    @Unique
    public void web_1_21_6_7$onCaveSpiderDataTrackerSync(class_2940<?> data, CallbackInfo ci) {
        class_1628 spider = (class_1628)this;
        if (!(spider instanceof class_1549)) {
            return;
        }
        class_1549 caveSpider = (class_1549)spider;
        class_1937 world = caveSpider.method_5770();
        if (CAVE_SPIDER_DATA_ID_STATE.equals(data) && world != null && world.method_8608()) {
            try {
                CaveSpiderState newState = CaveSpiderState.values()[(Integer)caveSpider.method_5841().method_12789(CAVE_SPIDER_DATA_ID_STATE)];
                if (this.caveSpiderState != newState && !this.isCaveSpiderChangingState) {
                    this.isCaveSpiderChangingState = true;
                    this.previousCaveSpiderState = this.caveSpiderState;
                    this.caveSpiderState = newState;
                    this.updateCaveSpiderAnimations(caveSpider);
                    this.isCaveSpiderChangingState = false;
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    @Override
    @Unique
    public void web_1_21_6_7$writeCaveSpiderCustomData(class_2487 nbt) {
        class_1628 spider = (class_1628)this;
        if (spider instanceof class_1549) {
            nbt.method_10582("CaveSpiderState", this.caveSpiderState.name());
        }
    }

    @Override
    @Unique
    public void web_1_21_6_7$readCaveSpiderCustomData(class_2487 nbt) {
        class_1628 spider = (class_1628)this;
        if (!(spider instanceof class_1549)) {
            return;
        }
        String stateString = nbt.method_10558("CaveSpiderState");
        if (stateString.isEmpty()) {
            stateString = "IDLE";
        }
        try {
            CaveSpiderState loadedState;
            this.caveSpiderState = loadedState = CaveSpiderState.valueOf(stateString);
            class_1549 caveSpider = (class_1549)spider;
            class_1937 world = caveSpider.method_5770();
            if (world != null && !world.method_8608()) {
                caveSpider.method_5841().method_12778(CAVE_SPIDER_DATA_ID_STATE, (Object)loadedState.ordinal());
            }
        }
        catch (IllegalArgumentException e) {
            this.caveSpiderState = CaveSpiderState.IDLE;
        }
    }

    @Override
    @Unique
    public class_7094 web_1_21_6_7$getCaveSpiderIdleAnimationState() {
        return this.caveSpiderIdleAnimationState;
    }

    @Override
    @Unique
    public class_7094 web_1_21_6_7$getCaveSpiderWalkingAnimationState() {
        return this.caveSpiderWalkingAnimationState;
    }

    @Override
    @Unique
    public CaveSpiderState web_1_21_6_7$getCaveSpiderState() {
        return this.caveSpiderState;
    }

    @Override
    @Unique
    public CaveSpiderState web_1_21_6_7$getPreviousState() {
        return this.previousCaveSpiderState;
    }
}

