/*
 * Decompiled with CFR 0.152.
 */
package potatowolfie.web.block.custom;

import net.minecraft.class_1268;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1309;
import net.minecraft.class_1317;
import net.minecraft.class_1628;
import net.minecraft.class_1657;
import net.minecraft.class_1786;
import net.minecraft.class_1799;
import net.minecraft.class_1922;
import net.minecraft.class_1934;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_238;
import net.minecraft.class_243;
import net.minecraft.class_2680;
import net.minecraft.class_2689;
import net.minecraft.class_2746;
import net.minecraft.class_2758;
import net.minecraft.class_2769;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3417;
import net.minecraft.class_3419;
import net.minecraft.class_3730;
import net.minecraft.class_3965;
import net.minecraft.class_4970;
import net.minecraft.class_5425;
import net.minecraft.class_5819;
import net.minecraft.class_9062;
import potatowolfie.web.advancement.BurnTheNestHandler;
import potatowolfie.web.entity.WebEntities;
import potatowolfie.web.entity.custom.BabySpiderEntity;

public class SpiderEggBlock
extends class_2248 {
    public static final class_2746 PREVENTED = class_2746.method_11825((String)"prevented");
    public static final class_2746 SPAWNED_PROTECTORS = class_2746.method_11825((String)"spawned_protectors");
    public static final class_2758 REMAINING_TIME = class_2758.method_11867((String)"remaining_time", (int)0, (int)288);
    private static final int HATCH_TIME = 24000;
    private static final int MIN_SCALED_HATCH_TIME = 216;
    private static final int MAX_SCALED_HATCH_TIME = 288;
    private static final double PLAYER_RANGE = 50.0;
    private static final int PLAYER_CHECK_INTERVAL = 100;
    private static final int MAX_PROTECTOR_SPIDERS = 2;
    private static final double PROTECTOR_SPAWN_RANGE = 8.0;
    private static final double PROTECTOR_CHECK_RANGE = 16.0;
    private static final float SPIDER_WIDTH = 1.4f;
    private static final float SPIDER_HEIGHT = 0.5f;

    public SpiderEggBlock(class_4970.class_2251 settings) {
        super(settings);
        this.method_9590((class_2680)((class_2680)((class_2680)((class_2680)this.field_10647.method_11664()).method_11657((class_2769)PREVENTED, (Comparable)Boolean.valueOf(false))).method_11657((class_2769)SPAWNED_PROTECTORS, (Comparable)Boolean.valueOf(false))).method_11657((class_2769)REMAINING_TIME, (Comparable)Integer.valueOf(288)));
    }

    protected void method_9515(class_2689.class_2690<class_2248, class_2680> builder) {
        builder.method_11667(new class_2769[]{PREVENTED, REMAINING_TIME, SPAWNED_PROTECTORS});
    }

    public void method_9615(class_2680 state, class_1937 world, class_2338 pos, class_2680 oldState, boolean notify) {
        if (!world.method_8608() && (oldState.method_26215() || oldState.method_26204() != this)) {
            boolean shouldPrevent = this.shouldStartPrevented(world, pos);
            if (shouldPrevent && !((Boolean)state.method_11654((class_2769)PREVENTED)).booleanValue()) {
                world.method_8652(pos, (class_2680)state.method_11657((class_2769)PREVENTED, (Comparable)Boolean.valueOf(true)), 3);
                state = world.method_8320(pos);
            }
            if (!((Boolean)state.method_11654((class_2769)PREVENTED)).booleanValue()) {
                world.method_39279(pos, (class_2248)this, 100);
            }
        }
    }

    private boolean shouldStartPrevented(class_1937 world, class_2338 pos) {
        if (world.method_8608()) {
            return false;
        }
        return world.method_18456().stream().filter(player -> player.method_5649((double)pos.method_10263() + 0.5, (double)pos.method_10264() + 0.5, (double)pos.method_10260() + 0.5) <= 2500.0).anyMatch(player -> {
            if (!(player instanceof class_3222)) return false;
            class_3222 serverPlayer = (class_3222)player;
            if (serverPlayer.field_13974.method_14257() != class_1934.field_9215) return false;
            return true;
        });
    }

    public void method_9588(class_2680 state, class_3218 world, class_2338 pos, class_5819 random) {
        boolean playerNearby;
        if (((Boolean)state.method_11654((class_2769)PREVENTED)).booleanValue()) {
            return;
        }
        int remainingTime = (Integer)state.method_11654((class_2769)REMAINING_TIME);
        boolean spawnedProtectors = (Boolean)state.method_11654((class_2769)SPAWNED_PROTECTORS);
        if (remainingTime == 288) {
            int randomHatchTime = 216 + random.method_43048(73);
            world.method_8652(pos, (class_2680)state.method_11657((class_2769)REMAINING_TIME, (Comparable)Integer.valueOf(randomHatchTime)), 3);
            state = world.method_8320(pos);
            remainingTime = randomHatchTime;
        }
        if ((playerNearby = world.method_18456().stream().anyMatch(player -> player.method_5649((double)pos.method_10263() + 0.5, (double)pos.method_10264() + 0.5, (double)pos.method_10260() + 0.5) <= 2500.0)) && !spawnedProtectors && random.method_43057() < 0.65f && this.spawnProtectorSpiders(world, pos, random)) {
            world.method_8652(pos, (class_2680)state.method_11657((class_2769)SPAWNED_PROTECTORS, (Comparable)Boolean.valueOf(true)), 3);
            state = world.method_8320(pos);
        }
        if (playerNearby) {
            int newRemainingTime = remainingTime - 1;
            if (newRemainingTime <= 0) {
                this.hatchEgg(world, pos);
                return;
            }
            world.method_8652(pos, (class_2680)state.method_11657((class_2769)REMAINING_TIME, (Comparable)Integer.valueOf(newRemainingTime)), 3);
            world.method_39279(pos, (class_2248)this, 100);
        } else {
            world.method_39279(pos, (class_2248)this, 100);
        }
    }

    private boolean spawnProtectorSpiders(class_3218 world, class_2338 eggPos, class_5819 random) {
        class_238 searchBox = class_238.method_30048((class_243)eggPos.method_46558(), (double)32.0, (double)32.0, (double)32.0);
        long nearbySpiders = world.method_8390(class_1628.class, searchBox, spider -> true).size();
        if (nearbySpiders >= 2L) {
            return false;
        }
        int spidersToSpawn = Math.min(2 - (int)nearbySpiders, 2);
        int spawnedCount = 0;
        for (int i = 0; i < spidersToSpawn; ++i) {
            class_2338 spawnPos = this.findValidSpawnPos(world, eggPos, random);
            if (spawnPos == null) continue;
            class_1628 protectorSpider = new class_1628(class_1299.field_6079, (class_1937)world);
            protectorSpider.method_5808((double)spawnPos.method_10263() + 0.5, (double)spawnPos.method_10264(), (double)spawnPos.method_10260() + 0.5, random.method_43057() * 360.0f, 0.0f);
            protectorSpider.method_5943((class_5425)world, world.method_8404(spawnPos), class_3730.field_16459, null);
            if (!world.method_8649((class_1297)protectorSpider)) continue;
            ++spawnedCount;
            world.method_8396(null, spawnPos, class_3417.field_15170, class_3419.field_15251, 0.5f, 0.8f);
        }
        return spawnedCount > 0;
    }

    private class_2338 findValidSpawnPos(class_3218 world, class_2338 center, class_5819 random) {
        for (int attempts = 0; attempts < 10; ++attempts) {
            double angle = random.method_43058() * 2.0 * Math.PI;
            double distance = 3.0 + random.method_43058() * 5.0;
            int x = center.method_10263() + (int)(Math.cos(angle) * distance);
            int z = center.method_10260() + (int)(Math.sin(angle) * distance);
            for (int y = center.method_10264() + 3; y >= center.method_10264() - 3; --y) {
                class_2338 candidatePos = new class_2338(x, y, z);
                if (!this.hasEnoughSpaceForSpider(world, candidatePos) || !class_1317.method_20638((class_1299)class_1299.field_6079, (class_5425)world, (class_3730)class_3730.field_16459, (class_2338)candidatePos, (class_5819)random)) continue;
                return candidatePos;
            }
        }
        return null;
    }

    private boolean hasEnoughSpaceForSpider(class_3218 world, class_2338 pos) {
        class_2338 groundPos = pos.method_10074();
        if (!world.method_8320(groundPos).method_26212((class_1922)world, groundPos)) {
            return false;
        }
        if (!world.method_8320(pos).method_26215() || !world.method_8320(pos.method_10084()).method_26215()) {
            return false;
        }
        for (int dx = -1; dx <= 1; ++dx) {
            for (int dz = -1; dz <= 1; ++dz) {
                class_2338 adjacentPos;
                class_2680 adjacentState;
                if (dx == 0 && dz == 0 || (adjacentState = world.method_8320(adjacentPos = pos.method_10069(dx, 0, dz))).method_26215() || !adjacentState.method_26212((class_1922)world, adjacentPos)) continue;
                return false;
            }
        }
        return true;
    }

    public void method_9514(class_2680 state, class_3218 world, class_2338 pos, class_5819 random) {
        if (!(world.method_8608() || ((Boolean)state.method_11654((class_2769)PREVENTED)).booleanValue() || world.method_14196().method_8674(pos, (Object)this))) {
            world.method_39279(pos, (class_2248)this, 100);
        }
    }

    public boolean method_9542(class_2680 state) {
        return (Boolean)state.method_11654((class_2769)PREVENTED) == false;
    }

    private void hatchEgg(class_3218 world, class_2338 pos) {
        BabySpiderEntity babySpider = new BabySpiderEntity(WebEntities.BABY_SPIDER, (class_1937)world);
        babySpider.method_5808((double)pos.method_10263() + 0.5, pos.method_10264() + 1, (double)pos.method_10260() + 0.5, 0.0f, 0.0f);
        world.method_8649((class_1297)babySpider);
        world.method_8396(null, pos, class_3417.field_43166, class_3419.field_15245, 1.0f, 1.0f);
        world.method_8650(pos, false);
    }

    protected class_9062 method_55765(class_1799 stack, class_2680 state, class_1937 world, class_2338 pos, class_1657 player, class_1268 hand, class_3965 hit) {
        if (stack.method_7909() instanceof class_1786 && !((Boolean)state.method_11654((class_2769)PREVENTED)).booleanValue()) {
            if (!world.method_8608()) {
                world.method_8652(pos, (class_2680)state.method_11657((class_2769)PREVENTED, (Comparable)Boolean.valueOf(true)), 3);
                world.method_8396(null, pos, class_3417.field_14579, class_3419.field_15245, 1.0f, 1.0f);
                if (player instanceof class_3222) {
                    class_3222 serverPlayer = (class_3222)player;
                    BurnTheNestHandler.grantBurnTheNestAdvancement(serverPlayer);
                }
                if (!player.method_7337()) {
                    stack.method_7970(1, (class_1309)player, class_1657.method_32326((class_1799)stack));
                }
            }
            return class_9062.method_55644((boolean)world.method_8608());
        }
        return class_9062.field_47731;
    }
}

