/*
 * Decompiled with CFR 0.152.
 */
package potatowolfie.web.mixin;

import java.lang.reflect.Field;
import java.util.Iterator;
import net.minecraft.class_1266;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1308;
import net.minecraft.class_1309;
import net.minecraft.class_1314;
import net.minecraft.class_1315;
import net.minecraft.class_1338;
import net.minecraft.class_1352;
import net.minecraft.class_1355;
import net.minecraft.class_1359;
import net.minecraft.class_1366;
import net.minecraft.class_1549;
import net.minecraft.class_1628;
import net.minecraft.class_1657;
import net.minecraft.class_1937;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_2940;
import net.minecraft.class_2941;
import net.minecraft.class_2943;
import net.minecraft.class_2945;
import net.minecraft.class_2960;
import net.minecraft.class_3417;
import net.minecraft.class_3730;
import net.minecraft.class_4135;
import net.minecraft.class_5321;
import net.minecraft.class_5425;
import net.minecraft.class_5819;
import net.minecraft.class_6862;
import net.minecraft.class_7094;
import net.minecraft.class_7924;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;
import potatowolfie.web.Web;
import potatowolfie.web.entity.WebEntities;
import potatowolfie.web.entity.custom.BabySpiderEntity;
import potatowolfie.web.entity.custom.SpiderWebProjectileEntity;
import potatowolfie.web.enums.SpiderState;
import potatowolfie.web.goals.WebShootingSpiderAttackGoal;
import potatowolfie.web.interfaces.SpiderAnimationInterface;
import potatowolfie.web.interfaces.WebSpiderInterface;

@Mixin(value={class_1628.class})
public class SpiderEntityMixin
implements WebSpiderInterface,
SpiderAnimationInterface {
    @Unique
    private int webCooldown = 0;
    @Unique
    private int combatTimer = 0;
    @Unique
    private boolean hasShootWeb = false;
    @Unique
    private boolean inCombat = false;
    @Unique
    private boolean goalsInitialized = false;
    @Unique
    private int stateTimer = 0;
    @Unique
    private class_1309 shootTarget = null;
    @Unique
    public final class_7094 spiderIdleAnimationState = new class_7094();
    @Unique
    public final class_7094 spiderWalkingAnimationState = new class_7094();
    @Unique
    public final class_7094 spiderShootingAnimationState = new class_7094();
    @Unique
    private int spiderIdleAnimationTimeout = 0;
    @Unique
    private boolean isSpiderIdleAnimationRunning = false;
    @Unique
    private boolean isSpiderWalkingAnimationRunning = false;
    @Unique
    private boolean isSpiderShootingAnimationRunning = false;
    @Unique
    private boolean isSpiderChangingState = false;
    @Unique
    private boolean spiderAnimationStartedThisTick = false;
    @Unique
    private static final class_2940<Integer> SPIDER_DATA_ID_STATE = class_2945.method_12791(class_1628.class, (class_2941)class_2943.field_13327);
    @Unique
    private SpiderState spiderState = SpiderState.IDLE;
    @Unique
    private SpiderState previousSpiderState = SpiderState.IDLE;
    @Unique
    private static final class_6862<class_1299<?>> WEB_IMMUNE_TAG = class_6862.method_40092((class_5321)class_7924.field_41266, (class_2960)class_2960.method_43902((String)"web", (String)"web_immune"));

    @Unique
    private static boolean isWebImmune(class_1309 entity) {
        return entity.method_5864().method_20210(WEB_IMMUNE_TAG);
    }

    @Unique
    private boolean isCaveSpider() {
        return this instanceof class_1549;
    }

    @Unique
    private static Field getGoalSelectorField() throws NoSuchFieldException {
        CharSequence[] possibleNames;
        NoSuchFieldException lastException = null;
        for (String string : possibleNames = new String[]{"goalSelector", "field_6201", "bO"}) {
            try {
                return class_1308.class.getDeclaredField(string);
            }
            catch (NoSuchFieldException e) {
                lastException = e;
            }
        }
        throw new NoSuchFieldException("Could not find goalSelector field with any of the tried names: " + String.join((CharSequence)", ", possibleNames));
    }

    @Inject(method={"method_5693(Lnet/minecraft/class_2945$class_9222;)V"}, at={@At(value="TAIL")})
    private void addSpiderAnimationDataTracker(class_2945.class_9222 builder, CallbackInfo ci) {
        class_1628 spider = (class_1628)this;
        if (!(spider instanceof class_1549)) {
            builder.method_56912(SPIDER_DATA_ID_STATE, (Object)SpiderState.IDLE.ordinal());
        }
    }

    @Inject(method={"method_5959()V"}, at={@At(value="TAIL")})
    private void addWebShootingGoal(CallbackInfo ci) {
        if (this.goalsInitialized) {
            return;
        }
        this.goalsInitialized = true;
        if (this.isCaveSpider()) {
            return;
        }
        class_1628 spider = (class_1628)this;
        try {
            Field goalSelectorField = SpiderEntityMixin.getGoalSelectorField();
            goalSelectorField.setAccessible(true);
            class_1355 goalSelector = (class_1355)goalSelectorField.get(spider);
            Iterator goalIterator = goalSelector.method_35115().iterator();
            while (goalIterator.hasNext()) {
                class_1352 goal = ((class_4135)goalIterator.next()).method_19058();
                if (!(goal instanceof class_1366) && !(goal instanceof class_1359)) continue;
                goalIterator.remove();
            }
            goalSelector.method_6277(2, (class_1352)new class_1338((class_1314)spider, class_1657.class, 3.5f, 1.0, 1.2));
            goalSelector.method_6277(2, (class_1352)new WebShootingSpiderAttackGoal(spider, this));
        }
        catch (Exception e) {
            Web.LOGGER.error("Failed to initialize spider goals: " + e.getMessage());
            e.printStackTrace();
        }
    }

    @Inject(method={"method_5943(Lnet/minecraft/class_5425;Lnet/minecraft/class_1266;Lnet/minecraft/class_3730;Lnet/minecraft/class_1315;)Lnet/minecraft/class_1315;"}, at={@At(value="RETURN")})
    private void spawnWithBabyRider(class_5425 world, class_1266 difficulty, class_3730 spawnReason, class_1315 entityData, CallbackInfoReturnable<class_1315> cir) {
        BabySpiderEntity babySpider;
        if (this.isCaveSpider()) {
            return;
        }
        class_1628 spider = (class_1628)this;
        class_5819 random = world.method_8409();
        if (random.method_43048(100) < 3 && (babySpider = (BabySpiderEntity)WebEntities.BABY_SPIDER.method_5883(spider.method_5770())) != null) {
            babySpider.method_5808(spider.method_23317(), spider.method_23318(), spider.method_23321(), spider.method_36454(), 0.0f);
            babySpider.method_5943(world, difficulty, spawnReason, null);
            babySpider.method_5804((class_1297)spider);
            spider.method_5770().method_8649((class_1297)babySpider);
        }
    }

    @Inject(method={"method_5773()V"}, at={@At(value="HEAD")})
    private void onTick(CallbackInfo ci) {
        if (this.isCaveSpider()) {
            return;
        }
        class_1628 spider = (class_1628)this;
        class_1937 world = spider.method_5770();
        if (spider.method_31481() || world == null) {
            return;
        }
        if (this.webCooldown > 0) {
            --this.webCooldown;
        }
        if (this.inCombat && this.combatTimer > 0) {
            --this.combatTimer;
            if (this.combatTimer <= 0) {
                this.inCombat = false;
                this.hasShootWeb = false;
            }
        }
        this.handleStateTransitions();
        class_1309 currentTarget = spider.method_5968();
        if (currentTarget != null && SpiderEntityMixin.isWebImmune(currentTarget)) {
            spider.method_5980(null);
        }
        this.spiderAnimationStartedThisTick = false;
        this.stateTimer = this.spiderState != SpiderState.IDLE ? ++this.stateTimer : 0;
        if (this.spiderState != SpiderState.SHOOTING && this.stateTimer == 0) {
            boolean isMoving;
            boolean bl = isMoving = spider.method_18798().method_37267() > 0.01;
            if (isMoving) {
                if (this.spiderState != SpiderState.WALKING) {
                    this.setSpiderState(SpiderState.WALKING);
                }
            } else if (this.spiderState != SpiderState.IDLE) {
                this.setSpiderState(SpiderState.IDLE);
            }
        }
        if (world.method_8608()) {
            this.updateSpiderAnimations(spider);
        }
    }

    @Inject(method={"method_5773()V"}, at={@At(value="HEAD")})
    private void syncStateFromDataTracker(CallbackInfo ci) {
        class_1628 spider = (class_1628)this;
        class_1937 world = spider.method_5770();
        if (world != null && world.method_8608()) {
            try {
                int stateValue = (Integer)spider.method_5841().method_12789(SPIDER_DATA_ID_STATE);
                SpiderState newState = SpiderState.values()[stateValue];
                if (this.spiderState != newState) {
                    this.spiderState = newState;
                    this.stateTimer = 0;
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    @Unique
    private void handleStateTransitions() {
        class_1628 spider = (class_1628)this;
        switch (this.spiderState) {
            case SHOOTING: {
                if (this.stateTimer == 17 && this.shootTarget != null && !spider.method_5770().method_8608()) {
                    this.performWebShot(this.shootTarget);
                }
                if (this.stateTimer < 20) break;
                this.shootTarget = null;
                boolean isMoving = spider.method_18798().method_37267() > 0.01;
                this.setSpiderState(isMoving ? SpiderState.WALKING : SpiderState.IDLE);
                break;
            }
            case WALKING: 
            case IDLE: {
                boolean isMoving;
                boolean bl = isMoving = spider.method_18798().method_37267() > 0.01;
                if (isMoving && this.spiderState != SpiderState.WALKING) {
                    this.setSpiderState(SpiderState.WALKING);
                    break;
                }
                if (isMoving || this.spiderState == SpiderState.IDLE) break;
                this.setSpiderState(SpiderState.IDLE);
            }
        }
    }

    @Unique
    private void updateSpiderAnimations(class_1628 spider) {
        if (this.spiderState == SpiderState.SHOOTING) {
            if (!this.isSpiderShootingAnimationRunning) {
                this.spiderIdleAnimationState.method_41325();
                this.spiderWalkingAnimationState.method_41325();
                this.isSpiderIdleAnimationRunning = false;
                this.isSpiderWalkingAnimationRunning = false;
                this.spiderIdleAnimationTimeout = 0;
                this.spiderShootingAnimationState.method_41322(spider.field_6012);
                this.isSpiderShootingAnimationRunning = true;
            }
        } else if (this.spiderState == SpiderState.WALKING) {
            if (!this.isSpiderWalkingAnimationRunning) {
                this.spiderIdleAnimationState.method_41325();
                this.spiderShootingAnimationState.method_41325();
                this.isSpiderIdleAnimationRunning = false;
                this.isSpiderShootingAnimationRunning = false;
                this.spiderIdleAnimationTimeout = 0;
                this.spiderWalkingAnimationState.method_41322(spider.field_6012);
                this.isSpiderWalkingAnimationRunning = true;
            }
        } else if (this.spiderState == SpiderState.IDLE && !this.isSpiderIdleAnimationRunning) {
            --this.spiderIdleAnimationTimeout;
            if (this.spiderIdleAnimationTimeout <= 0) {
                this.spiderWalkingAnimationState.method_41325();
                this.spiderShootingAnimationState.method_41325();
                this.isSpiderWalkingAnimationRunning = false;
                this.isSpiderShootingAnimationRunning = false;
                this.spiderIdleAnimationTimeout = spider.method_6051().method_43048(40) + 80;
                this.spiderIdleAnimationState.method_41322(spider.field_6012);
                this.isSpiderIdleAnimationRunning = true;
            }
        }
        if (this.isSpiderShootingAnimationRunning && this.spiderState != SpiderState.SHOOTING) {
            this.spiderShootingAnimationState.method_41325();
            this.isSpiderShootingAnimationRunning = false;
        }
    }

    @Unique
    private void setSpiderState(SpiderState newState) {
        class_1628 spider = (class_1628)this;
        class_1937 world = spider.method_5770();
        if (world == null || this.spiderState == newState || this.isSpiderChangingState) {
            return;
        }
        this.isSpiderChangingState = true;
        this.previousSpiderState = this.spiderState;
        this.spiderState = newState;
        this.stateTimer = 0;
        if (!world.method_8608()) {
            spider.method_5841().method_12778(SPIDER_DATA_ID_STATE, (Object)newState.ordinal());
        }
        this.isSpiderChangingState = false;
    }

    @Override
    @Unique
    public void shootWeb(class_1309 target) {
        if (this.isCaveSpider()) {
            return;
        }
        if (SpiderEntityMixin.isWebImmune(target)) {
            return;
        }
        class_1628 spider = (class_1628)this;
        class_1937 world = spider.method_5770();
        this.shootTarget = target;
        this.setSpiderState(SpiderState.SHOOTING);
        if (world != null && world.method_8608()) {
            this.spiderShootingAnimationState.method_41322(spider.field_6012);
            this.isSpiderShootingAnimationRunning = true;
            this.spiderIdleAnimationState.method_41325();
            this.spiderWalkingAnimationState.method_41325();
            this.isSpiderIdleAnimationRunning = false;
            this.isSpiderWalkingAnimationRunning = false;
        }
    }

    @Override
    @Unique
    public void onTrackedDataSet(class_2940<?> data, CallbackInfo ci) {
        this.web_1_21_6_7$onDataTrackerSync(data, ci);
    }

    @Unique
    private void performWebShot(class_1309 target) {
        double optimalSpeed;
        class_1628 spider = (class_1628)this;
        class_1937 world = spider.method_5770();
        SpiderWebProjectileEntity webProjectile = new SpiderWebProjectileEntity(world, (class_1309)spider);
        webProjectile.method_5814(spider.method_23317(), spider.method_23320() - 0.1, spider.method_23321());
        class_243 spiderPos = new class_243(spider.method_23317(), spider.method_23320(), spider.method_23321());
        class_243 targetVelocity = target.method_18798();
        double distance = spider.method_5739((class_1297)target);
        double timeToHit = distance / 1.5;
        class_243 predictedTargetPos = new class_243(target.method_23317() + targetVelocity.field_1352 * timeToHit, (double)target.method_31478() + 0.9, target.method_23321() + targetVelocity.field_1350 * timeToHit);
        double deltaX = predictedTargetPos.field_1352 - spiderPos.field_1352;
        double deltaY = predictedTargetPos.field_1351 - spiderPos.field_1351;
        double deltaZ = predictedTargetPos.field_1350 - spiderPos.field_1350;
        double horizontalDistance = Math.sqrt(deltaX * deltaX + deltaZ * deltaZ);
        double projectileSpeed = 2.0;
        double launchAngle = distance <= 6.0 ? Math.toRadians(10.0 + distance / 6.0 * 10.0) : (distance <= 10.0 ? Math.toRadians(20.0 + (distance - 6.0) / 4.0 * 15.0) : Math.toRadians(35.0 + Math.min((distance - 10.0) / 6.0, 1.0) * 10.0));
        double gravity = 0.05;
        double sinAngle = Math.sin(launchAngle);
        double cosAngle = Math.cos(launchAngle);
        double discriminant = sinAngle * sinAngle - 2.0 * gravity * deltaY / (projectileSpeed * projectileSpeed);
        if (discriminant >= 0.0 && (optimalSpeed = Math.sqrt(gravity * horizontalDistance * horizontalDistance / (horizontalDistance * Math.sin(2.0 * launchAngle) + 2.0 * deltaY * cosAngle * cosAngle))) > 0.5 && optimalSpeed < 3.0) {
            projectileSpeed = optimalSpeed;
        }
        double horizontalSpeed = projectileSpeed * cosAngle;
        double verticalSpeed = projectileSpeed * sinAngle;
        double horizontalNormalizer = horizontalDistance == 0.0 ? 0.0 : 1.0 / horizontalDistance;
        double normalizedX = deltaX * horizontalNormalizer;
        double normalizedZ = deltaZ * horizontalNormalizer;
        double spread = 0.01;
        double randomX = (spider.method_6051().method_43058() - 0.5) * spread;
        double randomY = (spider.method_6051().method_43058() - 0.5) * spread * 0.5;
        double randomZ = (spider.method_6051().method_43058() - 0.5) * spread;
        webProjectile.method_18800(normalizedX * horizontalSpeed + randomX, verticalSpeed + randomY, normalizedZ * horizontalSpeed + randomZ);
        spider.method_5783(class_3417.field_15170, 1.0f, 0.6f + spider.method_6051().method_43057() * 0.4f);
        world.method_8649((class_1297)webProjectile);
    }

    @Override
    @Unique
    public int getWebCooldown() {
        return this.webCooldown;
    }

    @Override
    @Unique
    public void setWebCooldown(int cooldown) {
        this.webCooldown = cooldown;
    }

    @Override
    @Unique
    public boolean hasShootWeb() {
        return this.hasShootWeb;
    }

    @Override
    @Unique
    public void setHasShootWeb(boolean hasShot) {
        this.hasShootWeb = hasShot;
    }

    @Override
    @Unique
    public boolean isInCombat() {
        return this.inCombat;
    }

    @Override
    @Unique
    public void setInCombat(boolean combat) {
        this.inCombat = combat;
    }

    @Override
    @Unique
    public int getCombatTimer() {
        return this.combatTimer;
    }

    @Override
    @Unique
    public void setCombatTimer(int timer) {
        this.combatTimer = timer;
    }

    @Override
    @Unique
    public boolean isShootingWeb() {
        return this.spiderState == SpiderState.SHOOTING;
    }

    @Override
    @Unique
    public int getShootAnimationTicks() {
        return this.stateTimer;
    }

    @Override
    @Unique
    public class_7094 web_1_21_6_7$getIdleAnimationState() {
        return this.spiderIdleAnimationState;
    }

    @Override
    @Unique
    public class_7094 web_1_21_6_7$getWalkingAnimationState() {
        return this.spiderWalkingAnimationState;
    }

    @Override
    @Unique
    public class_7094 web_1_21_6_7$getShootingAnimationState() {
        return this.spiderShootingAnimationState;
    }

    @Override
    @Unique
    public SpiderState web_1_21_6_7$getSpiderState() {
        return this.spiderState;
    }

    @Override
    @Unique
    public SpiderState web_1_21_6_7$getPreviousState() {
        return this.previousSpiderState;
    }

    @Override
    @Unique
    public void web_1_21_6_7$setSpiderState(SpiderState state) {
        this.setSpiderState(state);
    }

    @Override
    @Unique
    public void web_1_21_6_7$onDataTrackerSync(class_2940<?> data, CallbackInfo ci) {
        class_1628 spider = (class_1628)this;
        if (spider instanceof class_1549) {
            return;
        }
        class_1937 world = spider.method_5770();
        if (SPIDER_DATA_ID_STATE.equals(data) && world != null && world.method_8608()) {
            try {
                SpiderState newState = SpiderState.values()[(Integer)spider.method_5841().method_12789(SPIDER_DATA_ID_STATE)];
                if (this.spiderState != newState && !this.isSpiderChangingState) {
                    this.isSpiderChangingState = true;
                    this.previousSpiderState = this.spiderState;
                    this.spiderState = newState;
                    this.updateSpiderAnimations(spider);
                    this.isSpiderChangingState = false;
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    @Override
    @Unique
    public void web_1_21_6_7$writeCustomData(class_2487 nbt) {
        class_1628 spider = (class_1628)this;
        if (!(spider instanceof class_1549)) {
            nbt.method_10582("SpiderState", this.spiderState.name());
        }
    }

    @Override
    @Unique
    public void web_1_21_6_7$readCustomData(class_2487 nbt) {
        class_1628 spider = (class_1628)this;
        if (spider instanceof class_1549) {
            return;
        }
        String stateString = nbt.method_10558("SpiderState");
        if (stateString.isEmpty()) {
            stateString = "IDLE";
        }
        try {
            SpiderState loadedState;
            this.spiderState = loadedState = SpiderState.valueOf(stateString);
            class_1937 world = spider.method_5770();
            if (world != null && !world.method_8608()) {
                spider.method_5841().method_12778(SPIDER_DATA_ID_STATE, (Object)loadedState.ordinal());
            }
        }
        catch (IllegalArgumentException e) {
            this.spiderState = SpiderState.IDLE;
        }
    }
}

