/*
 * Decompiled with CFR 0.152.
 */
package potatowolfie.web.entity.custom;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.minecraft.class_11368;
import net.minecraft.class_11372;
import net.minecraft.class_1282;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1309;
import net.minecraft.class_1628;
import net.minecraft.class_1937;
import net.minecraft.class_238;
import net.minecraft.class_243;
import net.minecraft.class_2940;
import net.minecraft.class_2941;
import net.minecraft.class_2943;
import net.minecraft.class_2945;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.class_5321;
import net.minecraft.class_6862;
import net.minecraft.class_7094;
import net.minecraft.class_7924;
import potatowolfie.web.entity.WebEntities;

public class SpiderWebEntity
extends class_1297 {
    public int age = 0;
    private static final int MAX_AGE = 60;
    private static final int TRAP_DURATION = 40;
    private static final class_6862<class_1299<?>> WEB_IMMUNE_TAG = class_6862.method_40092((class_5321)class_7924.field_41266, (class_2960)class_2960.method_60655((String)"web", (String)"web_immune"));
    public final class_7094 webDieAnimationState = new class_7094();
    private boolean isDieAnimationRunning = false;
    private boolean animationStartedThisTick = false;
    private static final class_2940<Integer> DATA_ID_STATE = class_2945.method_12791(SpiderWebEntity.class, (class_2941)class_2943.field_13327);
    private WebState webState = WebState.DYING;
    private WebState previousState = WebState.DYING;
    private boolean isChangingState = false;
    private static final Map<class_1309, SpiderWebEntity> GLOBALLY_TRAPPED_ENTITIES = new HashMap<class_1309, SpiderWebEntity>();
    private final Set<class_1309> trappedEntities = new HashSet<class_1309>();
    private final Map<class_1309, Float> originalMovementSpeeds = new HashMap<class_1309, Float>();
    private final Map<class_1309, Float> originalJumpStrengths = new HashMap<class_1309, Float>();
    private final Set<class_1628> alertedSpiders = new HashSet<class_1628>();
    private class_1309 webTarget = null;

    public int getWebAge() {
        return this.age;
    }

    private static boolean isWebImmune(class_1309 entity) {
        return entity.method_5864().method_20210(WEB_IMMUNE_TAG);
    }

    public int getTickCount() {
        return this.age;
    }

    public SpiderWebEntity(class_1299<?> type, class_1937 world) {
        super(type, world);
        this.field_5960 = false;
        this.method_5684(false);
    }

    public SpiderWebEntity(class_1937 world, double x, double y, double z) {
        this(WebEntities.SPIDER_WEB, world);
        this.method_5814(x, y, z);
        this.method_5857(new class_238(x - 1.0, y - 0.5, z - 1.0, x + 1.0, y + 1.5, z + 1.0));
    }

    protected void method_5693(class_2945.class_9222 builder) {
        builder.method_56912(DATA_ID_STATE, (Object)WebState.DYING.ordinal());
    }

    public void method_5773() {
        if (this.method_31481() || this.method_37908() == null) {
            return;
        }
        this.animationStartedThisTick = false;
        super.method_5773();
        ++this.age;
        if (!this.method_37908().method_8608()) {
            if (this.age == 1) {
                this.trapEntitiesInRange();
            }
            if (this.age <= 40) {
                this.maintainTrappedEntities();
                if (!this.trappedEntities.isEmpty()) {
                    this.alertAllSpiders();
                } else {
                    this.clearSpiderTargets();
                }
            } else if (this.age == 41) {
                this.releaseAllEntities();
                this.clearSpiderTargets();
            }
        }
        if (this.age >= 60 && !this.method_37908().method_8608()) {
            this.releaseAllEntities();
            this.clearSpiderTargets();
            this.method_31472();
        }
        try {
            this.updateAnimations();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public boolean method_64397(class_3218 world, class_1282 source, float amount) {
        return false;
    }

    private void updateAnimations() {
        if (this.method_37908().method_8608() && !this.isDieAnimationRunning) {
            this.webDieAnimationState.method_41322(this.age);
            this.isDieAnimationRunning = true;
        }
    }

    private void setupAnimationStates() {
        if (!this.isDieAnimationRunning) {
            this.webDieAnimationState.method_41322(this.age);
            this.isDieAnimationRunning = true;
        }
    }

    private void alertAllSpiders() {
        class_1309 target = null;
        for (class_1309 trapped : this.trappedEntities) {
            if (!trapped.method_5805() || trapped instanceof class_1628 || SpiderWebEntity.isWebImmune(trapped)) continue;
            target = trapped;
            break;
        }
        if (target == null) {
            this.clearSpiderTargets();
            return;
        }
        class_238 searchBox = class_238.method_30048((class_243)this.method_19538(), (double)128.0, (double)64.0, (double)128.0);
        List nearbySpiders = this.method_37908().method_8390(class_1628.class, searchBox, spider -> spider.method_5805());
        for (class_1628 spider2 : nearbySpiders) {
            double distance = spider2.method_5739((class_1297)target);
            if (!(distance <= 64.0)) continue;
            spider2.method_5980(target);
            this.alertedSpiders.add(spider2);
        }
    }

    private void clearSpiderTargets() {
        Iterator<class_1628> iterator = this.alertedSpiders.iterator();
        while (iterator.hasNext()) {
            class_1309 currentTarget;
            class_1628 spider = iterator.next();
            if (spider.method_5805() && (currentTarget = spider.method_5968()) != null && (this.webTarget == currentTarget || this.originalMovementSpeeds.containsKey(currentTarget))) {
                spider.method_5980(null);
            }
            iterator.remove();
        }
        this.alertedSpiders.clear();
    }

    public WebState getWebState() {
        return this.webState;
    }

    public WebState getPreviousState() {
        return this.previousState;
    }

    public void setWebState(WebState newState) {
        if (this.webState != newState && !this.isChangingState) {
            this.isChangingState = true;
            this.previousState = this.webState;
            this.webState = newState;
            if (!this.method_37908().method_8608()) {
                this.field_6011.method_12778(DATA_ID_STATE, (Object)newState.ordinal());
            } else {
                this.startStateAnimation(newState);
            }
            this.isChangingState = false;
        }
    }

    private void startStateAnimation(WebState state) {
        if (!this.method_37908().method_8608() || this.animationStartedThisTick) {
            return;
        }
        this.animationStartedThisTick = true;
        this.webDieAnimationState.method_41322(this.age);
        this.isDieAnimationRunning = true;
    }

    private void stopAllAnimations() {
        if (this.method_37908().method_8608()) {
            this.webDieAnimationState.method_41325();
        }
    }

    public void method_5674(class_2940<?> data) {
        WebState newState;
        if (DATA_ID_STATE.equals(data) && this.method_37908().method_8608() && this.webState != (newState = WebState.values()[(Integer)this.field_6011.method_12789(DATA_ID_STATE)]) && !this.isChangingState) {
            this.isChangingState = true;
            this.previousState = this.webState;
            this.webState = newState;
            this.startStateAnimation(newState);
            this.isChangingState = false;
        }
        super.method_5674(data);
    }

    private void trapEntitiesInRange() {
        class_238 webBox = this.method_5829().method_1014(0.1);
        List nearbyEntities = this.method_37908().method_8390(class_1309.class, webBox, entity -> entity.method_5805() && !SpiderWebEntity.isWebImmune(entity));
        for (class_1309 entity2 : nearbyEntities) {
            this.trapEntity(entity2);
            if (this.webTarget != null) continue;
            this.webTarget = entity2;
        }
    }

    private void maintainTrappedEntities() {
        Iterator<class_1309> iterator = this.trappedEntities.iterator();
        while (iterator.hasNext()) {
            class_1309 entity = iterator.next();
            if (entity.method_5805() && !SpiderWebEntity.isWebImmune(entity)) continue;
            this.releaseEntity(entity);
            iterator.remove();
        }
        if (this.trappedEntities.isEmpty()) {
            this.clearSpiderTargets();
        }
    }

    private void trapEntity(class_1309 entity) {
        if (SpiderWebEntity.isWebImmune(entity)) {
            return;
        }
        this.trappedEntities.add(entity);
        GLOBALLY_TRAPPED_ENTITIES.put(entity, this);
        float originalSpeed = entity.method_6029();
        this.originalMovementSpeeds.put(entity, Float.valueOf(originalSpeed));
        if (entity.method_5740()) {
            this.originalJumpStrengths.put(entity, Float.valueOf(1.0f));
        } else {
            this.originalJumpStrengths.put(entity, Float.valueOf(0.42f));
        }
        entity.method_18800(0.0, 0.0, 0.0);
    }

    private void releaseEntity(class_1309 entity) {
        GLOBALLY_TRAPPED_ENTITIES.remove(entity);
        Float originalSpeed = this.originalMovementSpeeds.remove(entity);
        if (originalSpeed != null) {
            entity.method_6125(originalSpeed.floatValue());
        }
        this.originalJumpStrengths.remove(entity);
    }

    private void releaseAllEntities() {
        for (class_1309 entity : new HashSet<class_1309>(this.trappedEntities)) {
            this.releaseEntity(entity);
        }
        this.trappedEntities.clear();
    }

    public void method_5650(class_1297.class_5529 reason) {
        if (!this.method_37908().method_8608()) {
            this.releaseAllEntities();
            this.clearSpiderTargets();
        }
        super.method_5650(reason);
    }

    public boolean shouldPreventJump(class_1309 entity) {
        return this.trappedEntities.contains(entity) && this.age <= 40 && !SpiderWebEntity.isWebImmune(entity);
    }

    public boolean method_5863() {
        return false;
    }

    public boolean method_5810() {
        return false;
    }

    protected void method_5749(class_11368 view) {
        String stateString = view.method_71428("WebState", "DYING");
        this.webState = WebState.DYING;
        if (!this.method_37908().method_8608()) {
            this.field_6011.method_12778(DATA_ID_STATE, (Object)WebState.DYING.ordinal());
        }
    }

    protected void method_5652(class_11372 view) {
        view.method_71469("WebState", this.webState.name());
    }

    protected boolean method_5818(class_1297 passenger) {
        return false;
    }

    public boolean method_49108() {
        return false;
    }

    public float getAgeProgress() {
        return (float)this.age / 60.0f;
    }

    public int getAge() {
        return this.age;
    }

    public boolean isAnimationActive() {
        return this.webDieAnimationState.method_41327();
    }

    public float getAnimationProgress() {
        return (float)this.age / 60.0f;
    }

    public Set<class_1309> getTrappedEntities() {
        return new HashSet<class_1309>(this.trappedEntities);
    }

    public boolean isTrapping() {
        return this.age <= 40;
    }

    public static boolean isEntityTrapped(class_1309 entity) {
        if (SpiderWebEntity.isWebImmune(entity)) {
            return false;
        }
        SpiderWebEntity web = GLOBALLY_TRAPPED_ENTITIES.get(entity);
        return web != null && web.isTrapping();
    }

    public static boolean shouldPreventMovement(class_1309 entity) {
        return SpiderWebEntity.isEntityTrapped(entity) && !SpiderWebEntity.isWebImmune(entity);
    }

    public static boolean shouldPreventJumping(class_1309 entity) {
        return SpiderWebEntity.isEntityTrapped(entity) && !SpiderWebEntity.isWebImmune(entity);
    }

    public static boolean isEntityTouchingWeb(class_1309 entity) {
        return false;
    }

    public class_1309 getWebTarget() {
        return this.webTarget;
    }

    public static enum WebState {
        DYING;

    }
}

