param (
    [string]$speedsterName = "default_runner"
)

$rootPath = Split-Path -Parent $MyInvocation.MyCommand.Definition

$filePaths = @(
    # "addon/arrzenhanced/suit_sets/tachyon_$($speedsterName).json",
    "addon/arrzenhanced/suit_sets/speedster_$($speedsterName).json",
    # "assets/arrzenhanced/models/item/tachyon_$($speedsterName)_helmet.json",
    # "assets/arrzenhanced/models/item/tachyon_$($speedsterName)_chestplate.json",
    # "assets/arrzenhanced/models/item/tachyon_$($speedsterName)_leggings.json",
    # "assets/arrzenhanced/models/item/tachyon_$($speedsterName)_boots.json",
    "assets/arrzenhanced/models/item/speedster_$($speedsterName)_helmet.json",
    "assets/arrzenhanced/models/item/speedster_$($speedsterName)_chestplate.json",
    "assets/arrzenhanced/models/item/speedster_$($speedsterName)_leggings.json",
    "assets/arrzenhanced/models/item/speedster_$($speedsterName)_boots.json",
    # "assets/arrzenhanced/palladium/armor_renderers/speedsters/$($speedsterName)/helmet_tachyon.json",
    # "assets/arrzenhanced/palladium/armor_renderers/speedsters/$($speedsterName)/chest_tachyon.json",
    # "assets/arrzenhanced/palladium/armor_renderers/speedsters/$($speedsterName)/legs_tachyon.json",
    # "assets/arrzenhanced/palladium/armor_renderers/speedsters/$($speedsterName)/boots_tachyon.json",
    "assets/arrzenhanced/palladium/armor_renderers/speedsters/$($speedsterName)/helmet.json",
    "assets/arrzenhanced/palladium/armor_renderers/speedsters/$($speedsterName)/chest.json",
    "assets/arrzenhanced/palladium/armor_renderers/speedsters/$($speedsterName)/legs.json",
    "assets/arrzenhanced/palladium/armor_renderers/speedsters/$($speedsterName)/boots.json"
)

$contentTemplates = @{
    "suit_sets" = @"
{
    "armor_material": "arrzenhanced:speedster_suit",
    "chest": {
        "item_name": "tachyon_$($speedsterName)_chestplate",
        "max_stack_size": 1,
        "is_fire_resistant": false,
        "armor_renderer": "arrzenhanced:speedsters/$($speedsterName)/chest_tachyon"
    },
    "legs": {
        "item_name": "tachyon_$($speedsterName)_leggings",
        "max_stack_size": 1,
        "is_fire_resistant": false,
        "armor_renderer": "arrzenhanced:speedsters/$($speedsterName)/legs_tachyon"
    },
    "feet": {
        "item_name": "tachyon_$($speedsterName)_boots",
        "max_stack_size": 1,
        "is_fire_resistant": false,
        "armor_renderer": "arrzenhanced:speedsters/$($speedsterName)/boots_tachyon"
    },
    "head": {
        "item_name": "tachyon_$($speedsterName)_helmet",
        "max_stack_size": 1,
        "is_fire_resistant": false,
        "armor_renderer": "arrzenhanced:speedsters/$($speedsterName)/helmet_tachyon"
    }
}
"@

    "models_item" = @"
{
  "parent": "minecraft:item/generated",
  "textures": {
    "layer0": "arrzenhanced:item/todo"
  }
}
"@
}

foreach ($relPath in $filePaths) {
    $fullPath = Join-Path $rootPath $relPath
    $folderPath = Split-Path $fullPath -Parent

    if (!(Test-Path $folderPath)) {
        New-Item -ItemType Directory -Path $folderPath -Force | Out-Null
    }

    $fileName = Split-Path $relPath -Leaf
    $content = ""

    if ($relPath -like "*suit_sets*") {
        $content = $contentTemplates["suit_sets"]
    }
    elseif ($relPath -like "*models/item*") {
        $content = $contentTemplates["models_item"]

        # Replace textures if it's a speedster_ file
        if ($relPath -like "*speedster_*") {
            $content = $content -replace "_tachyon", ""
            $content = $content -replace "tachyon_$($speedsterName)", "speedster_$($speedsterName)"
        }
    }
    elseif ($relPath -like "*armor_renderers*") {
    # Extract the part and optional _tachyon suffix from the filename
    if ($fileName -match "^(helmet|chest|legs|boots)(_tachyon)?\.json$") {
        $basePart = $matches[1]
        $suffix = $matches[2]  # will be "_tachyon" or $null
        $texturePart = "$basePart$suffix"
    } else {
        $texturePart = "unknown"
    }

    $content = @"
{
    "textures": "arrzenhanced:textures/models/armor/speedsters/$($speedsterName)/$texturePart.png",
    "model_layers": "palladium:humanoid#tight_suit",
    "hide_second_layer": true
}
"@
    }
    else {
        $content = "Generic file for $speedsterName"
    }

    # Final cleanup replacements
    if ($relPath -like "*speedster_*") {
        $content = $content -replace "_tachyon", ""
        $content = $content -replace "tachyon_$speedsterName", "speedster_$speedsterName"
    }

    Set-Content -Path $fullPath -Value $content -Force
    Write-Host "Created: $relPath"
}
