/*
    @author Hertz
    @version 1.0
*/

StartupEvents.registry('palladium:abilities', (event) => {
    
    event.create('hertz:bifrost_setpoint')
    .icon(palladium.createItemIcon('minecraft:red_bed'))
    .firstTick((entity, entry, holder, enabled) => {
        if (enabled) {
            // var eyeColor = entry.getPropertyByName('eyeColor');
            // var currentEyeColor = palladium.getProperty(entity, 'eyeColor')
            var level = entity.getLevel()
            var px = entity.getX();
            var py = entity.getY();
            var pz = entity.getZ();
            var dim = level.getDimension().toString();

            palladium.setProperty(entity, 'bifrost_x', px);
            palladium.setProperty(entity, 'bifrost_y', py);
            palladium.setProperty(entity, 'bifrost_z', pz);
            palladium.setProperty(entity, 'bifrost_dim', dim);

            entity.tell(`Set Bifrost Point to ${Math.floor(px)}, ${Math.floor(py)}, ${Math.floor(pz)} in ${dim}`)
            // level.playSound(null, px, py, pz, "arrzenhanced:bifrostmark", "master", 0.25, 1)
            KJSUtils.staticServer.runCommandSilent(`playsound arrzenhanced:bifrostmark master ${entity.name.getString()} ${px} ${py} ${pz}`)
        };
    })
    .tick((entity, entry, holder, enabled) => {
        return;
    });
});