var $IntegerProperty = Java.loadClass("net.minecraft.world.level.block.state.properties.IntegerProperty")
let $ClipContext = Java.loadClass('net.minecraft.world.level.ClipContext')
let $ProjectileUtil = Java.loadClass('net.minecraft.world.entity.projectile.ProjectileUtil')

/**
 * Performs a raycast from a given position towards an entity.
 * 
 * @param {Vec3} startPos - The starting position of the ray.
 * @param {Internal.LivingEntity} targetEntity - The target entity.
 * @param {Internal.ServerLevel} level - The server level.
 * @returns {Object}
 * Returns the first block and/or entity hit by the ray.
 * Ignores non-solid blocks and spectators.
 */
let raycastToEntity = (startPos, targetEntity, level) => {
    let targetPos = targetEntity.eyePosition;
    let direction = targetPos.subtract(startPos).normalize();
    let distance = startPos.distanceTo(targetPos);

    // Offset start position slightly to avoid hitting the originating block
    let adjustedStart = startPos.add(direction.scale(1)); // Move half a block forward

    let endPos = adjustedStart.add(direction.scale(distance - 1)); // Adjust distance
    let aabb = AABB.of(adjustedStart.x(), adjustedStart.y(), adjustedStart.z(), endPos.x(), endPos.y(), endPos.z());

    let ray = $ProjectileUtil.getEntityHitResult(level, targetEntity, adjustedStart, endPos, aabb, (e) => {
        return !e.isSpectator();
    }, 0);

    let clip = new $ClipContext(
        adjustedStart,
        endPos,
        'collider', 'none',
        targetEntity
    );

    let hit = level.clip(clip);

    let hitBlock = hit.getBlockPos() ? level.getBlock(hit.getBlockPos()) : null;

    // Ensure the block hit isn't the block we're raycasting from
    if (hitBlock && hitBlock.getPos().getCenter().equals(startPos)) {
        hitBlock = null;
    }

    return {
        block: hitBlock,
        entity: ray ? ray.entity : null
    };
};

StartupEvents.registry('block', (e) => {
    e.create('arrzenhanced:gamma_block')
    .displayName('Gamma Block')
    .mapColor('color_green')
    .soundType('amethyst')
    .hardness(5)
    .resistance(12.0)
    .requiresTool(true)
    .tagBlock('minecraft:mineable/pickaxe')
    .tagBlock('minecraft:needs_iron_tool')
    .textureAll('arrzenhanced:block/gamma_block')
    .blockEntity((c) => {
        c.serverTick(80, 0, (blockEntity) => {
            // runs every 80 ticks
            if (global.gammaBlockTick) {
                global.gammaBlockTick(blockEntity)
            }
        })
    })
})

global.gammaBlockTick = (blockEntity) => {
    let level = blockEntity.level
    let {x, y, z} = blockEntity
    level.getEntitiesWithin(AABB.of(
        x + 4,
        y + 4,
        z + 4,
        x - 4,
        y - 4,
        z - 4
    )).forEach(target => {
        if (!target?.potionEffects) return
        if (palladium.abilities.hasPower(target, "arrzenhanced:hazmat_suit")) {return}
        let result = raycastToEntity(level.getBlock(x, y, z).getPos().getCenter(), target, level)
        if (result.block) {
            if (result.block.hasTag('forge:storage_blocks/lead') || result.block.hasTag('forge:storage_blocks/gamma_crystal')) {
                return
            }
        }
        let gammaFx = target.potionEffects.getActive("arrzenhanced:gamma_radiation"),
        amp = 0
        if (gammaFx) {
            // target.tell(target.potionEffects.getActive("arrzenhanced:gamma_radiation").getAmplifier())
            amp = Number(target.potionEffects.getActive("arrzenhanced:gamma_radiation").getAmplifier())
            if (amp < 9) amp += 1
        }
        target.potionEffects.add("arrzenhanced:gamma_radiation", 30 * 20, amp, false, false)
    });
}