/*
    @author Hertz
    @version 1.0
*/

let ClientboundSetEntityMotionPacket = Java.loadClass('net.minecraft.network.protocol.game.ClientboundSetEntityMotionPacket');

let $ClipContext = Java.loadClass('net.minecraft.world.level.ClipContext')
let $ProjectileUtil = Java.loadClass('net.minecraft.world.entity.projectile.ProjectileUtil')

var $SuperpowerUtil = Java.loadClass('net.threetag.palladium.power.SuperpowerUtil')
var $ResourceLocation = Java.loadClass('net.minecraft.resources.ResourceLocation');

/**
 * 
 * @param {Internal.LivingEntity} entity 
 * @param {Internal.ServerLevel} level 
 * @param {number} distance
 * @returns {Object}
 * Returns the block and/or entity that the entity is looking at.
 * Ignores non-solid blocks and spectators.
 */
let advancedRayTrace = (entity, level, distance) => {
    let eyePos = entity.eyePosition;
    let viewVec = entity.getViewVector(1)
    let endPos = eyePos.add(viewVec.x() * distance, viewVec.y() * distance, viewVec.z() * distance)
    let aabb = AABB.of(eyePos.x(), eyePos.y(), eyePos.z(), endPos.x(), endPos.y(), endPos.z())

    let ray = $ProjectileUtil.getEntityHitResult(level, entity, eyePos, endPos, aabb, (e) => {
        return !e.isSpectator()
    }, 0)

    let clip = new $ClipContext(
        entity.getEyePosition(1), 
        entity.getEyePosition(1).add(entity.getLookAngle().scale(distance)), 
        'collider', 'none', 
        entity
    )
    let hit = level.clip(clip)
    if (ray == null) {
        return {
            block: hit.getBlockPos() ? level.getBlock(hit.getBlockPos()) : null,
            entity: null
        }
    }
    return {
        block: level.getBlock(hit.getBlockPos()),
        entity: ray.entity
    }
}

function resolveAllegedBooleanFromObject(thing) {
    if (thing.toString() == 'true') { return true; }
    if (thing.toString() == 'false') { return false; }
    return null
}

StartupEvents.registry('palladium:abilities', (event) => {

    event.create('arrzenhanced:transform_read_power')
    .icon(palladium.createItemIcon('minecraft:piston'))
    .addProperty('distance', 'integer', 10, 'Raycast distance')
    .tick((entity, entry, holder, enabled) => global.xformReadPower(entity, entry, holder, enabled))

    event.create('arrzenhanced:transform_open_menu')
    .icon(palladium.createItemIcon('minecraft:piston'))
    .tick((entity, entry, holder, enabled) => global.xformMenu(entity, entry, holder, enabled))

    event.create('arrzenhanced:apply_selected_power')
    .icon(palladium.createItemIcon('minecraft:piston'))
    .tick((entity, entry, holder, enabled) => global.xformApplyPower(entity, entry, holder, enabled))

    event.create('arrzenhanced:wipe_transformations')
    .icon(palladium.createItemIcon('minecraft:piston'))
    .tick((entity, entry, holder, enabled) => global.xformResetPower(entity, entry, holder, enabled))
});

global.xformReadPower = (entity, entry, holder, enabled) => {
    if (enabled) {
        var distance = entry.getPropertyByName('distance');

        let target = advancedRayTrace(entity, entity.getLevel(), distance).entity
        if (!target) {return}
        if (target != entity) {
            // let target = entity
            
            let targetPowers = palladium.powers.getPowerIds(target).toArray()
            let targetSuperpowers = []
            // entity.tell(targetPowers)
            targetPowers.forEach((power) => {
                let hasPower = palladium.superpowers.hasSuperpower(target, power)
                // entity.tell(hasPower)
                if (hasPower) {targetSuperpowers.push(power.toString())}
            })
            // entity.tell(targetSuperpowers)
            if (!entity.persistentData.code_transform) {
                entity.persistentData.code_transform = {}
                entity.persistentData.code_transform.active = 1
                entity.persistentData.code_transform.scannedPowers = []
                entity.persistentData.code_transform.power1 = []
                entity.persistentData.code_transform.power2 = []
                entity.persistentData.code_transform.power3 = []
            }
            entity.persistentData.code_transform.scannedPowers = JSON.stringify(targetSuperpowers)
            // entity.tell(entity.persistentData.code_transform.scannedPowers)
        }
    }
}

global.xformApplyPower = (entity, entry, holder, enabled) => {
    if (enabled) {
        let basePowers = palladium.powers.getPowerIds(entity).toArray()
        let baseSuperpowers = []
        let baseSuperpowersLocations = []
        // entity.tell(basePowers)
        basePowers.forEach((power) => {
            let hasPower = palladium.superpowers.hasSuperpower(entity, power)
            if (hasPower) {baseSuperpowers.push(power.toString()); baseSuperpowersLocations.push(new $ResourceLocation(power.toString()))}
        })
        // entity.tell(baseSuperpowers)
        if (!entity.persistentData.code_transform) {
            entity.persistentData.code_transform = {}
            entity.persistentData.code_transform.active = 1
            entity.persistentData.code_transform.scannedPowers = []
            entity.persistentData.code_transform.power1 = []
            entity.persistentData.code_transform.power2 = []
            entity.persistentData.code_transform.power3 = []
        }
        // delete entity.persistentData.code_transform.baseSuperpowers;
        if (!entity.persistentData.code_transform.baseSuperpowers) {
            entity.persistentData.code_transform.baseSuperpowers = JSON.stringify(baseSuperpowers)
        }
        try {
            let scannedPowers = JSON.parse(entity.persistentData.code_transform.scannedPowers)
            let scanLoc = []
            // entity.tell(scannedPowers)
            scannedPowers.forEach((power) => {
                scanLoc.push(new $ResourceLocation(power))
            })
            $SuperpowerUtil['setSuperpowerIds(net.minecraft.world.entity.LivingEntity,java.util.List)'](entity, scanLoc);
            // palladium.superpowers.setSuperpowerIds(entity, entity.persistentData.code_transform.baseSuperpowers)
            // entity.tell(entity.persistentData.code_transform.scannedPowers)
        } catch (err) {
            entity.tell(err)
            console.log(err)
        }
    }
}

global.xformResetPower = (entity, entry, holder, enabled) => {
    if (enabled) {
        if (!entity.persistentData.code_transform) {
            entity.persistentData.code_transform = {}
            entity.persistentData.code_transform.active = 1
            entity.persistentData.code_transform.scannedPowers = []
            entity.persistentData.code_transform.power1 = []
            entity.persistentData.code_transform.power2 = []
            entity.persistentData.code_transform.power3 = []
        }
        if (entity.persistentData.code_transform.baseSuperpowers) {
            let base = JSON.parse(entity.persistentData.code_transform.baseSuperpowers)
            palladium.superpowers.removeAllSuperpowers(entity)
            let baseLoc = []
            base.forEach((power) => {
                baseLoc.push(new $ResourceLocation(power))
            })
            $SuperpowerUtil['setSuperpowerIds(net.minecraft.world.entity.LivingEntity,java.util.List)'](entity, baseLoc);
            delete entity.persistentData.code_transform.baseSuperpowers
        }
    }
}


global.xformMenu = (entity, entry, holder, enabled) => {
    if (enabled) {
        // delete entity.persistentData.code_transform
        // return
        if (!entity.persistentData.code_transform) {
            entity.persistentData.code_transform = {}
            entity.persistentData.code_transform.active = 1
            entity.persistentData.code_transform.scannedPowers = []
            entity.persistentData.code_transform.power1 = []
            entity.persistentData.code_transform.power2 = []
            entity.persistentData.code_transform.power3 = []
        }
        try {
            createTransformGUI(entity)
        } catch (err) {
            entity.tell(err)
        }
    }
}


let createTransformGUI = (player) => {
    // Slots go (X, Y) && Zero-indexed
    player.openChestGUI(Text.of(Text.gold('Transform').bold()), 4, gui => {
        gui.playerSlots = false

        // Map Overhead
        gui.slot(4, 1, slot => {
            let selectedPowers = JSON.parse(player.persistentData.code_transform.scannedPowers)
            let lores = [{ text: ``, color: "white", bold: false, italic: false }]
            if (selectedPowers.length == 0) {lores.push({ text: `Empty`, color: "white", bold: false, italic: false })}
            selectedPowers.forEach((power) => {
                lores.push({ text: `${power}`, color: "white", bold: false, italic: false })
            })

            slot.item = Item.of(
                'minecraft:map',
                1,
                createItemNBT(
                    { text: "Scanned Powers", color: "gold", bold: false, italic: false },
                    lores
                )
            )
            slot.leftClicked = (e) => {
                // player.sendSystemMessage('§ayummers')
                createTransformGUI(player)
            }
        })
        // Save Button
        gui.slot(8, 0, slot => {
            slot.item = Item.of(
                'minecraft:red_bed',
                1,
                createItemNBT(
                    { text: "Save Scanned Powers", color: "red", bold: true, italic: false },
                    []
                )
            )
            slot.leftClicked = (e) => {
                player.persistentData.code_transform[`power${player.persistentData.code_transform.active}`] = player.persistentData.code_transform.scannedPowers
                player.sendSystemMessage('§aSaved!')
                createTransformGUI(player)
            }
        })


        // Scanned Slots
        gui.slot(3, 3, slot => {
            let selectedPowers = JSON.parse(player.persistentData.code_transform.power1)
            let lores = [{ text: ``, color: "white", bold: false, italic: false }]
            if (selectedPowers.length == 0) {lores.push({ text: `Empty`, color: "white", bold: false, italic: false })}
            selectedPowers.forEach((power) => {
                lores.push({ text: `${power}`, color: "white", bold: false, italic: false })
            })

            let regItem = 'minecraft:quartz_block'
            if (player.persistentData.code_transform.active == 1) {regItem = 'minecraft:emerald_block'}
            slot.item = Item.of(
                regItem,
                1,
                createItemNBT(
                    { text: "Stored Powerset 1", color: "aqua", bold: false, italic: false },
                    lores
                )
            )
            slot.leftClicked = (e) => {
                player.persistentData.code_transform.active = 1
                player.persistentData.code_transform.scannedPowers = player.persistentData.code_transform.power1
                createTransformGUI(player)
            }
            slot.rightClicked = (e) => {
                player.persistentData.code_transform.active = 1
                createTransformGUI(player)
            }
        })
        gui.slot(4, 3, slot => {
            let selectedPowers = JSON.parse(player.persistentData.code_transform.power2)
            let lores = [{ text: ``, color: "white", bold: false, italic: false }]
            if (selectedPowers.length == 0) {lores.push({ text: `Empty`, color: "white", bold: false, italic: false })}
            selectedPowers.forEach((power) => {
                lores.push({ text: `${power}`, color: "white", bold: false, italic: false })
            })

            
            let regItem = 'minecraft:quartz_block'
            if (player.persistentData.code_transform.active == 2) {regItem = 'minecraft:emerald_block'}
            slot.item = Item.of(
                regItem,
                1,
                createItemNBT(
                    { text: "Stored Powerset 2", color: "aqua", bold: false, italic: false },
                    lores
                )
            )
            slot.leftClicked = (e) => {
                player.persistentData.code_transform.active = 2
                player.persistentData.code_transform.scannedPowers = player.persistentData.code_transform.power2
                createTransformGUI(player)
            }
            slot.rightClicked = (e) => {
                player.persistentData.code_transform.active = 2
                createTransformGUI(player)
            }
        })
        gui.slot(5, 3, slot => {
            let selectedPowers = JSON.parse(player.persistentData.code_transform.power1)
            let lores = [{ text: ``, color: "white", bold: false, italic: false }]
            if (selectedPowers.length == 0) {lores.push({ text: `Empty`, color: "white", bold: false, italic: false })}
            selectedPowers.forEach((power) => {
                lores.push({ text: `${power}`, color: "white", bold: false, italic: false })
            })

            
            let regItem = 'minecraft:quartz_block'
            if (player.persistentData.code_transform.active == 3) {regItem = 'minecraft:emerald_block'}
            slot.item = Item.of(
                regItem,
                1,
                createItemNBT(
                    { text: "Stored Powerset 3", color: "aqua", bold: false, italic: false },
                    lores
                )
            )
            slot.leftClicked = (e) => {
                player.persistentData.code_transform.active = 3
                player.persistentData.code_transform.scannedPowers = player.persistentData.code_transform.power3
                createTransformGUI(player)
            }
            slot.rightClicked = (e) => {
                player.persistentData.code_transform.active = 3
                createTransformGUI(player)
            }
        })
    })
}