StartupEvents.registry('palladium:abilities', (event) => {
    event.create('arrzenhanced:convert_item')
    .icon(palladium.createItemIcon('palladium:vibranium_circuit'))
    .addProperty('to_item', 'string', 'minecraft:dirt', 'item to switch to')
    .addProperty('nbt', 'compound_tag', null, 'NBT Data')
    .addProperty('hand', 'string', 'mainhand', 'mainhand / offhand')
    .firstTick((entity, entry, holder, enabled) => {
        if (enabled) {
            return
        }
    })
    .tick((entity, entry, holder, enabled) => global.itemSwap(entity, entry, holder, enabled))
    .lastTick((entity, entry, holder, enabled) => {
        if (enabled) {
            return
        }
    });
});

global.itemSwap = (entity, entry, holder, enabled) => {
    var to_item = entry.getPropertyByName('to_item');
    var nbt = entry.getPropertyByName('nbt');
    var hand = entry.getPropertyByName('hand');
    if (enabled) {
        if (entity.type != 'minecraft:player') {return}
        if (hand == 'mainhand') {
            entity.mainHandItem = Item.of(to_item, 1, nbt)
        } else if (hand == 'offhand') {
            entity.offHandItem = Item.of(to_item, 1, nbt)
        }
    }
}