var $ResourceLocation = Java.loadClass('net.minecraft.resources.ResourceLocation');
var $ResourceKey = Java.loadClass("net.minecraft.resources.ResourceKey")
var DAMAGE_TYPE = $ResourceKey.createRegistryKey("damage_type")

function getDamageSource(
    /** @type {Internal.Level}*/ level,
    /** @type {Internal.DamageType_}*/ damageType
    ) {
    const resourceKey = $ResourceKey.create(DAMAGE_TYPE, Utils.id(damageType))
    const holder = level.registryAccess().registryOrThrow(DAMAGE_TYPE).getHolderOrThrow(resourceKey)
    var damagesource = holder.get()
    return new DamageSource(damagesource)
}

var PlayerUtil = Java.loadClass('net.threetag.palladium.util.PlayerUtil');
global.playSoundToAll = function(entity, range, sound, category, volume, pitch) {
    PlayerUtil['playSoundToAll(net.minecraft.world.level.Level,double,double,double,double,net.minecraft.resources.ResourceLocation,net.minecraft.sounds.SoundSource,float,float)'](entity.getLevel(), entity.x, entity.y, entity.z, range, sound, category, volume, pitch);
}

var deadzoneTracker = 0
var damageTracker = 0

StartupEvents.registry('palladium:abilities', (event) => {
    
    event.create('hertz:apply_effect_in_radius')
    .icon(palladium.createItemIcon('minecraft:note_block'))
    .addProperty('effect', 'string', 'minecraft:regeneration', 'effect to apply')
    .addProperty('effect_2', 'string', 'none', 'effect to apply')
    .addProperty('effect_3', 'string', 'none', 'effect to apply')
    .addProperty('effect_4', 'string', 'none', 'effect to apply')
    .addProperty('radius', 'integer', 20, 'radius of effect')
    .firstTick((entity, entry, holder, enabled) => {
        if (enabled) {
            var inven = entity.getAllSlots()
            inven.forEach((item) => {
                if (item.isEmpty()) return
                if (item.id == "arrzenhanced:deadzone_dagger") {
                    item.setNbt({CustomModelData:1, Unbreakable:true})
                }
            })
            var radius = entry.getPropertyByName('radius');
            Utils.server.runCommandSilent('tag @e remove Dampened.DeadzoneFirstDampen')
            //arrzenhanced:power_negation.activate
            global.playSoundToAll(entity, 20, "arrzenhanced:power_negation.activate", "players", 1, 1)
            deadzoneTracker = 0
            damageTracker = 0
            entity.modifyAttribute("minecraft:generic.max_health", "8168985f-3201-43c3-9860-81d8bb417b6b", deadzoneTracker, "ADDITION")
            entity.modifyAttribute("minecraft:generic.armor", "c6dbe2c2-abc9-4c03-9040-c94329990665", deadzoneTracker, "ADDITION")
            entity.modifyAttribute("palladium:punch_damage", "779278d5-8d8a-4cfd-af42-ef69b1d85708", damageTracker, "ADDITION")
            // circle notif
            let player = entity
            let level = player.getLevel()
            // let radius = 10.5
            let particle = Utils.particleOptions('dust 0.722 0.894 0.941 2')
            let particleCount = 200

            for (let i = 0; i < particleCount; i++) {
                let theta = Math.acos(2 * Math.random() - 1); // Polar angle
                let phi = 2 * JavaMath.PI * Math.random(); // Azimuthal angle
        
                // Spherical to Cartesian conversion
                let xOffset = radius * Math.sin(theta) * Math.cos(phi);
                let yOffset = radius * Math.sin(theta) * Math.sin(phi);
                let zOffset = radius * Math.cos(theta);
        
                // Spawn the particle at the calculated offset
                level.spawnParticles(
                    particle,
                    true,
                    player.x + xOffset,
                    player.y + yOffset + 1, // Adjust for player's height
                    player.z + zOffset,
                    0, 0, 0, // No velocity for static particles
                    1, // Count
                    0 // ?
                );
            }
        }
    })
    .tick((entity, entry, holder, enabled) => {
        if (enabled) {
            var effect = entry.getPropertyByName('effect');
            var effect2 = entry.getPropertyByName('effect_2');
            var effect3 = entry.getPropertyByName('effect_3');
            var effect4 = entry.getPropertyByName('effect_4');
            let e2 = effect2 == 'none' ? false : true,
            e3 = effect3 == 'none' ? false : true,
            e4 = effect4 == 'none' ? false : true
            var radius = entry.getPropertyByName('radius');
            //
            var px = entity.getX();
            var py = entity.getY();
            var pz = entity.getZ();

            var level = entity.getLevel();

            level.getEntitiesWithin(AABB.of(
                px - radius,
                py - radius,
                pz - radius,
                px + radius,
                py + radius,
                pz + radius,
            )).forEach(target => {
                if (
                    target == entity ||
                    target.type == "minecraft:item" ||
                    target.type == "minecraft:armor_stand"
                ) {
                    return;
                }

                if (!target?.potionEffects) return
                let tx = target.getX()
                let ty = target.getY()
                let tz = target.getZ()
                if (!target.tags.contains('Dampened.DeadzoneFirstDampen') && target.type == "minecraft:player") {
                    for (var z = 0; z < 20; z++) {
                        Utils.server.runCommandSilent(`execute positioned ${tx} ${ty} ${tz} facing entity ${entity.name.getString()} feet run particle dampened:dark_matter ~0.${Math.floor(Math.random() * (50 + 1))} ~1.${Math.floor(Math.random() * (50 + 1))} ~0.${Math.floor(Math.random() * (50 + 1))} ^ ^ ^1000000 0.0000005 0 force`)
                    }
                    target.tags.add('Dampened.DeadzoneFirstDampen')
                    deadzoneTracker = deadzoneTracker <= 19 ? deadzoneTracker + 2 : 20
                    damageTracker = damageTracker <= 4 ? damageTracker + 1 : 4
                    entity.modifyAttribute("minecraft:generic.max_health", "8168985f-3201-43c3-9860-81d8bb417b6b", deadzoneTracker, "ADDITION")
                    entity.modifyAttribute("minecraft:generic.armor", "c6dbe2c2-abc9-4c03-9040-c94329990665", deadzoneTracker, "ADDITION")
                    entity.modifyAttribute("palladium:punch_damage", "779278d5-8d8a-4cfd-af42-ef69b1d85708", damageTracker, "ADDITION")
                }
                target.potionEffects.add(effect, 20 * 20, 0, false, false)
                if (e2) {target.potionEffects.add(effect2, 20 * 20, 0, false, false)}
                if (e3) {target.potionEffects.add(effect3, 20 * 20, 0, false, false)}
                if (e4) {target.potionEffects.add(effect4, 20 * 20, 0, false, false)}
            });
        }
    })
    .lastTick((entity, entry, holder, enabled) => {
        if (enabled) {
            var inven = entity.getAllSlots()
            inven.forEach((item) => {
                if (item.isEmpty()) return
                if (item.id == "arrzenhanced:deadzone_dagger") {
                    item.setNbt({CustomModelData:0, Unbreakable:true})
                }
            })

            Utils.server.runCommandSilent('tag @e remove Dampened.DeadzoneFirstDampen')
            deadzoneTracker = 0
            damageTracker = 0
            entity.modifyAttribute("minecraft:generic.max_health", "8168985f-3201-43c3-9860-81d8bb417b6b", deadzoneTracker, "ADDITION")
            entity.modifyAttribute("minecraft:generic.armor", "c6dbe2c2-abc9-4c03-9040-c94329990665", deadzoneTracker, "ADDITION")
            entity.modifyAttribute("palladium:punch_damage", "779278d5-8d8a-4cfd-af42-ef69b1d85708", damageTracker, "ADDITION")
        }
    });
});

StartupEvents.registry('sound_event', event => {
    event.create('arrzenhanced:power_negation.activate')
})