/*
    @author Hertz
    @version 1.0
*/

let EnergyBarReference = Java.loadClass('net.threetag.palladium.power.energybar.EnergyBarReference');
let HYPERIOR_RAGE_REF = new EnergyBarReference('arrzenhanced:hyperior', 'rage');

StartupEvents.registry('palladium:abilities', (event) => {
    
    event.create('arrzenhanced:rage_bar')
    .icon(palladium.createItemIcon('minecraft:note_block'))
    .tick((entity, entry, holder, enabled) => {
        if (enabled) {
            var player = entity
            var playerPowerBar = HYPERIOR_RAGE_REF.getEntry(player)
            if (playerPowerBar.get() <= 0) {return}

            if (!player.persistentData.contains('rageCooldown')) {
                player.persistentData["rageCooldown"] = 0;
            }
            if (!player.persistentData.contains('rageDamageCooldown')) {
                player.persistentData["rageDamageCooldown"] = 0;
            } else {
                player.persistentData["rageDamageCooldown"]--;
            }
            
            if (player.persistentData["rageCooldown"] <= 0) {
                // playerPowerBar.set(playerPowerBar.get() - 1000)
                playerPowerBar.add(-1000)
                // player.tell("cooldown tick")
                player.persistentData["rageCooldown"] = 500; // Reset cooldown
            } else {
                // Decrease the cooldown if it's greater than 0
                player.persistentData["rageCooldown"]--;
            }
        }
    })
});

StartupEvents.registry('sound_event', event => {
    // event.create('arrzenhanced:soul_fire_magic.empowered')
})