// arrzenhanced:ground_slam
// @author Hertz
// @version 1.0

var ClientboundSetEntityMotionPacket = Java.loadClass('net.minecraft.network.protocol.game.ClientboundSetEntityMotionPacket');
var $ResourceKey_ = Java.loadClass("net.minecraft.resources.ResourceKey");
var DAMAGE_TYPE_KEY = $ResourceKey_.createRegistryKey("damage_type");

var EnergyBarReference = Java.loadClass('net.threetag.palladium.power.energybar.EnergyBarReference');
var HYPERIOR_RAGE_REF = new EnergyBarReference('arrzenhanced:hyperior', 'rage');

function getDamageSourceBothSides(
    /** @type {Internal.Level}*/ level,
    /** @type {Internal.DamageType_}*/ damageType,
    /** @type {Internal.LivingEntity}*/ destEntity,
    /** @type {Internal.LivingEntity}*/ sourceEntity
    ) {
    var resourceKey = $ResourceKey_.create(DAMAGE_TYPE_KEY, Utils.id(damageType));
    var holder = level.registryAccess().registryOrThrow(DAMAGE_TYPE_KEY).getHolderOrThrow(resourceKey);
    var damagesourceholder = holder;
    return new DamageSource(damagesourceholder, sourceEntity, destEntity);
}

StartupEvents.registry('palladium:abilities', (event) => {
    event.create('arrzenhanced:sonic_scream')
    .icon(palladium.createItemIcon('minecraft:netherite_ingot'))
    .addProperty('damage', 'integer', 10, 'Damage to deal')
    .addProperty('radius', 'integer', 4, 'Radius to deal damage')
    .firstTick((entity, entry, holder, enabled) => global.sonicScreamFT(entity, entry, holder, enabled))
    .tick((entity, entry, holder, enabled) => global.sonicScream(entity, entry, holder, enabled))
});

global.sonicScreamFT = (entity, entry, holder, enabled) => {
    if (enabled) {
        entity.getLevel().playSound(null, entity.getX(), entity.getY(), entity.getZ(), 'arrzenhanced:hyperior.get_out', 'master', 0.5, 1);
    }
}


global.sonicScream = (entity, entry, holder, enabled) => {
    if (enabled) {
        if (entity.type != 'minecraft:player') return;

        let damage = Number(entry.getPropertyByName("damage")),
        radius = Number(entry.getPropertyByName("radius")) * 1.0,
        coords = entity.position();

        let level = entity.getLevel();
        let aabb = AABB.of(
            coords.x() - radius, coords.y() - radius, coords.z() - radius,
            coords.x() + radius, coords.y() + radius, coords.z() + radius
        );
        
        // if (entity.age % 10 == 0) {
        //     level.spawnParticles('minecraft:cloud', true, coords.x(), coords.y(), coords.z(), radius, 0, radius, 50, 0);
        // }
        if (entity.age % 5 == 0) {
            let lookAngle = entity.getLookAngle().scale(1)
            let playerLocation = Vec3d(
                entity.getX(),
                (entity.getY() + 1.5),
                entity.getZ()
            )
            let targetLocation = Vec3d(
                (playerLocation.x() + lookAngle.x()),
                (playerLocation.y() + lookAngle.y()),
                (playerLocation.z() + lookAngle.z())
            )
            level.spawnParticles('minecraft:sonic_boom', true, targetLocation.x(), targetLocation.y(), targetLocation.z(), 0, 0, 0, 1, 0);
        }

        let playerPowerBar = false;        
        if (palladium.superpowers.hasSuperpower(entity, 'arrzenhanced:hyperior')) {
            playerPowerBar = HYPERIOR_RAGE_REF.getEntry(entity)
        }
        let ratio = damage / playerPowerBar.getMax()
        let currentDamage = Math.round(ratio * playerPowerBar.get())

        level.getEntitiesWithin(aabb).forEach(target => {
            if (
                target !== entity &&
                target.type !== "minecraft:item" &&
                target.type !== "minecraft:item_frame" &&
                target.type !== "minecraft:experience_orb" &&
                target.type !== "minecraft:glow_item_frame" &&
                target.type !== "minecraft:armor_stand" &&
                target.type !== "palladium:suit_stand"
            ) {
                let damageSource = getDamageSourceBothSides(level, "minecraft:player_attack", entity, target);
                target.attack(damageSource, currentDamage);

                if (!target.potionEffects) {return}
                target.potionEffects.add('arrzenhanced:concussed', 1 * 20, 0, false, false)
            }
        });
    }
} 
