/*
    @author Hertz
    @version 1.0
*/

var $ResourceKey_ = Java.loadClass("net.minecraft.resources.ResourceKey");
var DAMAGE_TYPE_KEY = $ResourceKey_.createRegistryKey("damage_type");
let ClientboundSetEntityMotionPacket = Java.loadClass('net.minecraft.network.protocol.game.ClientboundSetEntityMotionPacket');

function getDamageSourceBothSides(
    /** @type {Internal.Level}*/ level,
    /** @type {Internal.DamageType_}*/ damageType,
    /** @type {Internal.LivingEntity}*/ destEntity,
    /** @type {Internal.LivingEntity}*/ sourceEntity
    ) {
    var resourceKey = $ResourceKey_.create(DAMAGE_TYPE_KEY, Utils.id(damageType));
    var holder = level.registryAccess().registryOrThrow(DAMAGE_TYPE_KEY).getHolderOrThrow(resourceKey);
    var damagesourceholder = holder;
    return new DamageSource(damagesourceholder, sourceEntity, destEntity);
}

function resolveAllegedBooleanFromObject(thing) {
    if (thing.toString() == 'true') { return true; }
    if (thing.toString() == 'false') { return false; }
    return null
}

StartupEvents.registry('palladium:abilities', (event) => {
	event.create('arrzenhanced:collision_damage')
	.icon(palladium.createItemIcon('minecraft:netherite_boots'))
	.addProperty('damage', 'float', 20, 'Damage dealt to entities colliding with power-haver')
	.tick((entity, entry, holder, enabled) => {
		if (enabled) {
			var damage = entry.getPropertyByName('damage');
			let bb = entity.boundingBox

            entity.getLevel().getEntitiesWithin(bb).forEach(target => {
                if (target == entity) return
                let dx = target.getX() - entity.getX();
                let dy = target.getY() - entity.getY();
                let dz = target.getZ() - entity.getZ();
                let dist = Math.sqrt((dx * dx) + (dy * dy) + (dz * dz));
    
                if (dist === 0) return;
                
                let knockbackStrength = 4.5
                let vx = (dx / dist) * knockbackStrength;
                let vy = ((dy / dist) * knockbackStrength) + 1.2;
                let vz = (dz / dist) * knockbackStrength;
                target.setMotion(vx, vy, vz);
                if (target.isPlayer()) {
                    target.connection.send(new ClientboundSetEntityMotionPacket(target));
                }

                let damageSource = getDamageSourceBothSides(entity.getLevel(), "minecraft:player_attack", entity, target);
                target.attack(damageSource, damage)
            })
		}
	});
});