// arrzenhanced:ground_shake
// @author Hertz
// @version 1.0

var ClientboundSetEntityMotionPacket = Java.loadClass('net.minecraft.network.protocol.game.ClientboundSetEntityMotionPacket');
var $ResourceKey_ = Java.loadClass("net.minecraft.resources.ResourceKey");
var DAMAGE_TYPE_KEY = $ResourceKey_.createRegistryKey("damage_type");

function getDamageSourceBothSides(
    /** @type {Internal.Level}*/ level,
    /** @type {Internal.DamageType_}*/ damageType,
    /** @type {Internal.LivingEntity}*/ destEntity,
    /** @type {Internal.LivingEntity}*/ sourceEntity
    ) {
    var resourceKey = $ResourceKey_.create(DAMAGE_TYPE_KEY, Utils.id(damageType));
    var holder = level.registryAccess().registryOrThrow(DAMAGE_TYPE_KEY).getHolderOrThrow(resourceKey);
    var damagesourceholder = holder;
    return new DamageSource(damagesourceholder, sourceEntity, destEntity);
}

StartupEvents.registry('palladium:abilities', (event) => {
    event.create('arrzenhanced:ground_shake')
    .icon(palladium.createItemIcon('minecraft:netherite_ingot'))
    .addProperty('damage', 'integer', 7, 'Damage to deal')
    .addProperty('radius', 'integer', 4, 'Radius to deal damage')
    .tick((entity, entry, holder, enabled) => global.groundShake(entity, entry, holder, enabled))
});

global.groundShake = (entity, entry, holder, enabled) => {
    if (enabled) {
        if (entity.type != 'minecraft:player') return;

        let damage = Number(entry.getPropertyByName("damage")),
        radius = Number(entry.getPropertyByName("radius")) * 1.0,
        coords = entity.position();

        let level = entity.getLevel();
        let aabb = AABB.of(
            coords.x() - radius, coords.y() - 1, coords.z() - radius,
            coords.x() + radius, coords.y() + 1, coords.z() + radius
        );

        if (entity.age % 10 == 0) {
            level.spawnParticles('minecraft:cloud', true, coords.x(), coords.y(), coords.z(), radius, 0, radius, 50, 0);
        }
        if (entity.age % 5 == 0) {
            level.spawnParticles('minecraft:explosion', true, coords.x(), coords.y(), coords.z(), 1, 0, 1, 2, 0);
        }

        level.getEntitiesWithin(aabb).forEach(target => {
            if (
                target !== entity &&
                target.type !== "minecraft:item" &&
                target.type !== "minecraft:item_frame" &&
                target.type !== "minecraft:experience_orb" &&
                target.type !== "minecraft:glow_item_frame" &&
                target.type !== "minecraft:armor_stand" &&
                target.type !== "palladium:suit_stand"
            ) {
                let damageSource = getDamageSourceBothSides(level, "minecraft:player_attack", entity, target);
                target.attack(damageSource, damage);
            }
        });
    }
} 
