/*
    @author Hertz
    @version 1.0
*/

var EnergyBarReference = Java.loadClass('net.threetag.palladium.power.energybar.EnergyBarReference');
var IMPASSE_KINETIC_REF = new EnergyBarReference('arrzenhanced:impasse', 'kinetic');
var HYPERIOR_RAGE_REF = new EnergyBarReference('arrzenhanced:hyperior', 'rage');

StartupEvents.registry('palladium:abilities', (event) => {
    event.create('arrzenhanced:scaling_health')
    .icon(palladium.createItemIcon('palladium:vibranium_circuit'))
    .tick((entity, entry, holder, enabled) => {
        if (enabled) {
            if (entity.type != 'minecraft:player') return;

            var playerPowerBar = false
            let ratio = 0
            let toughRatio = 0
            if (palladium.superpowers.hasSuperpower(entity, 'arrzenhanced:hyperior')) {
                playerPowerBar = HYPERIOR_RAGE_REF.getEntry(entity)
                ratio = 20 / playerPowerBar.getMax()
                toughRatio = 6 / playerPowerBar.getMax()
            } else if (palladium.superpowers.hasSuperpower(entity, 'arrzenhanced:impasse')) {
                playerPowerBar = IMPASSE_KINETIC_REF.getEntry(entity)
                ratio = 10 / playerPowerBar.getMax()
                toughRatio = 5 / playerPowerBar.getMax()
            } else {
                return;
            }
            if (playerPowerBar.get() == 0) return;

            let currentStrength = Math.round(ratio * playerPowerBar.get())

            let currentTough = Math.round(toughRatio * playerPowerBar.get())

            if (palladium.superpowers.hasSuperpower(entity, 'arrzenhanced:impasse')) {
                let speedRatio = 0.2 / playerPowerBar.getMax()
                let currentSpeed = speedRatio * playerPowerBar.get()
                entity.modifyAttribute("minecraft:generic.movement_speed", "7367c99d-7129-49a7-8d40-649a9b880000", currentSpeed, "ADDITION")
            }

            entity.modifyAttribute("minecraft:generic.armor", "ced4cabd-be36-4d27-9bc3-488f64a04c7c", currentStrength, "ADDITION")
            entity.modifyAttribute("minecraft:generic.armor_toughness", "75905c2d-4122-453f-a018-986c0a8d3cae", currentTough, "ADDITION")
            entity.modifyAttribute("minecraft:generic.max_health", "b2d46446-07ad-45f9-83d0-f3a65a97b19a", currentStrength, "ADDITION")
        }
    })
    .lastTick((entity, entry, holder, enabled) => {
        if (enabled) {
            if (entity.type != 'minecraft:player') return;

            entity.removeAttribute("minecraft:generic.armor", "ced4cabd-be36-4d27-9bc3-488f64a04c7c")
            entity.removeAttribute("minecraft:generic.armor_toughness", "75905c2d-4122-453f-a018-986c0a8d3cae")
            entity.removeAttribute("minecraft:generic.max_health", "b2d46446-07ad-45f9-83d0-f3a65a97b19a")
            entity.removeAttribute("minecraft:generic.movement_speed", "7367c99d-7129-49a7-8d40-649a9b880000")
        }
    });
});

