/*
    @author Hertz
    @version 1.0
*/

function resolveAllegedBooleanFromObject(thing) {
    if (thing.toString() == 'true') { return true; }
    if (thing.toString() == 'false') { return false; }
    return null
}
var KJSUtils = Java.loadClass('dev.latvian.mods.kubejs.util.UtilsJS');

StartupEvents.registry('palladium:abilities', (event) => {
    event.create('arrzenhanced:toggle_prism_blade')
    .icon(palladium.createItemIcon('palladium:vibranium_circuit'))
    .tick((entity, entry, holder, enabled) => global.togglePrismBlade(entity, entry, holder, enabled))
});

global.togglePrismBlade = (entity, entry, holder, enabled) => {
    try {
    if (enabled) {
        var inventory = entity.getInventory()
        var chestplate = inventory.getArmor(2)
        if (chestplate.isEmpty() || chestplate.id != 'arrzenhanced:iron_prism_chestplate') {return}
        let storage = chestplate.nbt.getString('StoredPrismBlade')
        
        if (storage == '') { // init
            entity.give(Item.of('arrzenhanced:prism_blade_disabled', 1))
            chestplate.nbt.putString('StoredPrismBlade', 'empty')
        } else if (storage == 'empty') { // put it back
            if (entity.mainHandItem.id == 'arrzenhanced:prism_blade_disabled') {
                // entity.tell(NBT.toTag(entity.mainHandItem.nbt))
                chestplate.nbt.putString('StoredPrismBlade', entity.mainHandItem.nbt == null ? '' : NBT.toTagCompound(entity.mainHandItem.nbt))
                entity.setMainHandItem(Item.of('minecraft:air'))
            }
            else if (entity.offHandItem.id == 'arrzenhanced:prism_blade_disabled') {
                chestplate.nbt.putString('StoredPrismBlade', entity.offHandItem.nbt == null ? '' : NBT.toTagCompound(entity.offHandItem.nbt))
                entity.setOffHandItem(Item.of('minecraft:air'))
            }
            return
        } else { // existing
            entity.give(Item.of('arrzenhanced:prism_blade_disabled', 1, NBT.toTagCompound(storage)))
            chestplate.nbt.putString('StoredPrismBlade', 'empty')
        }
    }
    } catch (err) {
        entity.tell(err)
    }
}