/*
    @author Hertz
    @version 1.0
*/

let ClientboundSetEntityMotionPacket = Java.loadClass('net.minecraft.network.protocol.game.ClientboundSetEntityMotionPacket');
var inAir = false
var activatedThis = false
var lightningDist = 0
var landingYaw = 0
var landingCoords = {x:0, y:0, z:0}

StartupEvents.registry('palladium:abilities', (event) => {
    event.create('hertz:lightning_slam')
    .icon(palladium.createItemIcon('palladium:vibranium_circuit'))
    .addProperty('radius', 'integer', 8, 'Radius to summon lightning in')
    .firstTick((entity, entry, holder, enabled) => {
        if (enabled) {
            activatedThis = true
            let move = entity.getLookAngle().scale(2);
            entity.setDeltaMovement(move);

            if (entity.isPlayer()) {
                entity.connection.send(new ClientboundSetEntityMotionPacket(entity));
            }
            if (!entity.onGround()) {
                inAir = true
            }
            entity.tags.add('Arrz.ThorSlamInProgress')
        }
    })
    .tick((entity, entry, holder, enabled) => {
        const radius = entry.getPropertyByName('radius');
        if (enabled) {
            return
        }
        if (!entity.onGround() && !inAir && activatedThis) {
            inAir = true
        } else if (entity.onGround() && inAir && activatedThis) { // hit the ground
            entity.tags.remove('Arrz.ThorSlamInProgress')
            activatedThis = false
            var px = entity.getX();
            var py = entity.getY();
            var pz = entity.getZ();
            landingCoords['x'] = px;
            landingCoords['y'] = py;
            landingCoords['z'] = pz;
            var level = entity.getLevel()

            // level.playSound(null, px, py, pz, "arrzenhanced:slamthudstrong", "master", 1, 1)
            KJSUtils.staticServer.runCommandSilent(`playsound arrzenhanced:slamthudstrong master @a ${px} ${py} ${pz}`)

            inAir = false
            level.spawnParticles("minecraft:cloud", true, px, py, pz, 5, 0, 5, 40, 0);
            
            for (let angle = 0; angle < 360; angle += 35) {
                let radians = angle * (JavaMath.PI / 180)
                let xOffset = Math.cos(radians) * radius;
                let zOffset = Math.sin(radians) * radius;

                let mob = level.createEntity("minecraft:lightning_bolt");
                mob.setPosition(px + xOffset, py, pz + zOffset);
                mob.spawn();
            }

            KJSUtils.staticServer.runCommandSilent(`stopsound @a * minecraft:entity.lightning_bolt.impact`)
            KJSUtils.staticServer.runCommandSilent(`stopsound @a * minecraft:entity.lightning_bolt.thunder`)
            
            /*
            // lightning crawl WIP commented out
            landingYaw = entity.yaw
            let radYaw = (landingYaw + 90) * (JavaMath.PI / 180)

            let frontX = px + 3 * Math.cos(radYaw)
            let frontZ = pz + 3 * Math.sin(radYaw)
            let leftX = frontX - Math.sin(radYaw)
            let leftZ = frontZ - Math.cos(radYaw)

            let rightX = frontX + Math.sin(radYaw)
            let rightZ = frontZ + Math.cos(radYaw)
            
            var rightbolt = level.createEntity("minecraft:lightning_bolt");
            var leftbolt = level.createEntity("minecraft:lightning_bolt");
            leftbolt.setPosition(leftX, py, leftZ);
            rightbolt.setPosition(rightX, py, rightZ);
            leftbolt.spawn();
            rightbolt.spawn();
            */
        }
        return
    })
});