/*
    @author Hertz
    @version 1.0
*/

let EnergyBarReference = Java.loadClass('net.threetag.palladium.power.energybar.EnergyBarReference');
let NUCLEAR_FUSION_REF = new EnergyBarReference('arrzenhanced:nuclear_fusion', 'energy');

StartupEvents.registry('palladium:abilities', (event) => {
    
    event.create('arrzenhanced:nuclear_fusion_bar')
    .icon(palladium.createItemIcon('minecraft:note_block'))
    .tick((entity, entry, holder, enabled) => {
        if (enabled) {
            var player = entity
            var playerPowerBar = NUCLEAR_FUSION_REF.getEntry(player)
            if (playerPowerBar.get() <= 0) {return}

            if (!player.persistentData.contains('fusionCooldown')) {
                player.persistentData["fusionCooldown"] = 0;
            }
            if (!player.persistentData.contains('fusionDamageCooldown')) {
                player.persistentData["fusionDamageCooldown"] = 0;
            } else {
                player.persistentData["fusionDamageCooldown"]--;
            }
            
            if (player.persistentData["fusionCooldown"] <= 0) {
                // playerPowerBar.set(playerPowerBar.get() - 1000)
                playerPowerBar.add(-1000)
                // player.tell("cooldown tick")
                player.persistentData["fusionCooldown"] = 500; // Reset cooldown
            } else {
                // Decrease the cooldown if it's greater than 0
                player.persistentData["fusionCooldown"]--;
            }
        }
    })
});

StartupEvents.registry('sound_event', event => {
    // event.create('arrzenhanced:soul_fire_magic.empowered')
})