/*
    @author PhantomPig 
    @source https://discord.com/channels/116908382878695430/1062032236297338900/1285412610715553832
    @version 1.0
*/

StartupEvents.registry('palladium:abilities', (event) => {
    event.create('phantompig:offset_projectile')
    .icon(palladium.createItemIcon('minecraft:arrow'))
    .addProperty('entity_type', 'string', 'palladium:custom_projectile', 'Entity type')
    .addProperty('entity_data', 'compound_tag', null, 'NBT Data')
    .addProperty('yawOverride', 'integer', -999, 'Yaw Override')
    .addProperty('pitchOverride', 'integer', -999, 'Pitch Override')
    .addProperty('yawOffset', 'integer', -999, 'Yaw Offset')
    .addProperty('pitchOffset', 'integer', -999, 'Pitch Offset')
    .addProperty('speed', 'integer', 5, 'Speed')
    .tick((entity, entry, holder, enabled) => {
        if (enabled) {
            var p_type = entry.getPropertyByName('entity_type')
            var p_nbt = entry.getPropertyByName('entity_data')
            var p_yawOverride = entry.getPropertyByName('yawOverride')
            var p_pitchOverride = entry.getPropertyByName('pitchOverride')
            var p_yawOffset = entry.getPropertyByName('yawOffset')
            var p_pitchOffset = entry.getPropertyByName('pitchOffset')
            var p_speed = entry.getPropertyByName('speed')
    
            global.fireProjectileAtOffset_conflictAvoidingSuffix(
                entity,
                p_type,
                p_nbt,
                p_yawOverride,
                p_pitchOverride,
                p_yawOffset,
                p_pitchOffset,
                p_speed
            )
        }
    })
})

global.toRadians = (deg) => {return deg * (JavaMath.PI / 180)}

global.fireProjectileAtOffset_conflictAvoidingSuffix = function(entity, type, nbt, yawOverride, pitchOverride, yawOffset, pitchOffset, speed) {
    var projectile = entity.block.createEntity(type);
    projectile.mergeNbt(nbt);

    var pitch = -global.toRadians(entity.getPitch() + pitchOffset);
    var yaw = -global.toRadians(entity.getYaw() + yawOffset);

    if (pitchOverride != -999) pitch = global.toRadians(pitchOverride);
    if (yawOverride != -999) yaw = global.toRadians(yawOverride);

    var x = entity.getX() + Math.cos(pitch) * Math.sin(yaw),
    y = entity.getY() + entity.getEyeHeight() + Math.sin(pitch),
    z = entity.getZ() + Math.cos(pitch) * Math.cos(yaw);
    
    projectile.setPos(x, y, z)
    projectile.setDeltaMovement(entity.getLookAngle().scale(speed))
    projectile.setRotation(-entity.getYaw(), -entity.getPitch())

    projectile.setOwner(entity)
    projectile.spawn()
}