/*
    @author Hertz
    @version 1.0
*/

let $ResourceLocation = Java.loadClass('net.minecraft.resources.ResourceLocation');
let $ResourceKey = Java.loadClass("net.minecraft.resources.ResourceKey")
let DAMAGE_TYPE = $ResourceKey.createRegistryKey("damage_type")
var BlockPos = Java.loadClass('net.minecraft.core.BlockPos');

function getDamageSource(
    /** @type {Internal.Level}*/ level,
    /** @type {Internal.DamageType_}*/ damageType
    ) {
    let resourceKey = $ResourceKey.create(DAMAGE_TYPE, Utils.id(damageType))
    let holder = level.registryAccess().registryOrThrow(DAMAGE_TYPE).getHolderOrThrow(resourceKey)
    var damagesource = holder.get()
    return new DamageSource(damagesource)
}

StartupEvents.registry('palladium:abilities', (event) => {
    
    event.create('hertz:raycast_damage_with_sound')
    .icon(palladium.createItemIcon('minecraft:note_block'))
    .addProperty('sound', 'string', 'minecraft:entity.player.attack.strong', 'Sound to play')
    .addProperty('distance', 'integer', 5, 'Max distance to raycast')
    .tick((entity, entry, holder, enabled) => {
        if (enabled) {
            var soundToPlay = new $ResourceLocation(entry.getPropertyByName('sound'));
            var dist = entry.getPropertyByName('distance');
            var level = entity.getLevel()
            var victim = advancedRayTrace(entity, level, dist).entity
            if (!victim && entity.age % 10) {
                let blockPos = new BlockPos(entity.getX(), entity.getY(), entity.getZ())
                // level.playSound(entity, blockPos, "minecraft:entity.player.attack.nodamage", "players", 1, 1)
                KJSUtils.staticServer.runCommandSilent(`playsound minecraft:entity.player.attack.nodamage players @a ${blockPos.getX()} ${blockPos.getY()} ${blockPos.getZ()}`)
            }
            if (!victim) return

            let damageSource = getDamageSource(level, "hertz_heroes:speed_punch")
            victim.attack(damageSource, 3.5)
            
            if (entity.age % 5) {
                let blockPos = new BlockPos(victim.getX(), victim.getY(), victim.getZ())
                // level.playSound(victim, blockPos, soundToPlay, "players", 1, 1)
                KJSUtils.staticServer.runCommandSilent(`playsound ${soundToPlay} players @a ${victim.getX()} ${victim.getY()} ${victim.getZ()}`)
            }
        }
    });
});