/*
    @author Hertz
    @version 1.0
*/

let EnergyBarReference = Java.loadClass('net.threetag.palladium.power.energybar.EnergyBarReference');
const DAMAGE_BAR_REF = new EnergyBarReference('arrzenhanced:soul_fire_magic', 'damage_boost');

StartupEvents.registry('palladium:abilities', (event) => {
    
    event.create('arrzenhanced:damage_boost_bar')
    .icon(palladium.createItemIcon('minecraft:note_block'))
    .tick((entity, entry, holder, enabled) => {
        if (enabled) {
            var player = entity
            var playerPowerBar = DAMAGE_BAR_REF.getEntry(player)
            if (playerPowerBar.get() <= 0) {return}

            if (!player.persistentData.contains('soulFireCooldown')) {
                player.persistentData["soulFireCooldown"] = 0;
            }
            if (!player.persistentData.contains('soulFireDamageCooldown')) {
                player.persistentData["soulFireDamageCooldown"] = 0;
            } else {
                player.persistentData["soulFireDamageCooldown"]--;
            }
            
            if (player.persistentData["soulFireCooldown"] <= 0) {
                // playerPowerBar.set(playerPowerBar.get() - 1000)
                playerPowerBar.add(-1000)
                // player.tell("cooldown tick")
                player.persistentData["soulFireCooldown"] = 80; // Reset cooldown
            } else {
                // Decrease the cooldown if it's greater than 0
                player.persistentData["soulFireCooldown"]--;
            }
        }
    })
});

StartupEvents.registry('sound_event', event => {
    event.create('arrzenhanced:soul_fire_magic.empowered')
})