// @author Hertz
// @version 1.0

var $ResourceKey_ = Java.loadClass("net.minecraft.resources.ResourceKey");
var DAMAGE_TYPE_KEY = $ResourceKey_.createRegistryKey("damage_type");

function getDamageSourceBothSides(
    /** @type {Internal.Level}*/ level,
    /** @type {Internal.DamageType_}*/ damageType,
    /** @type {Internal.LivingEntity}*/ destEntity,
    /** @type {Internal.LivingEntity}*/ sourceEntity
    ) {
    var resourceKey = $ResourceKey_.create(DAMAGE_TYPE_KEY, Utils.id(damageType))
    var holder = level.registryAccess().registryOrThrow(DAMAGE_TYPE_KEY).getHolderOrThrow(resourceKey)
    var damagesourceholder = holder
    return new DamageSource(damagesourceholder, sourceEntity, destEntity)
}

StartupEvents.registry('palladium:abilities', (event) => {
    event.create('arrzenhanced:warden_boom')
    .icon(palladium.createItemIcon('palladium:vibranium_circuit'))
    .tick((entity, entry, holder, enabled) => {
        if (enabled) {
            if (entity.type != 'minecraft:player') return;
            
            let level = entity.getLevel(),
            player = entity

            for (var i = 0; i <= 24; i+=1.2) {
                let lookAngle = player.getLookAngle().scale(1 + i);
                let playerLocation = Vec3d(player.getX(), player.getY(), player.getZ());
                let particleTarget = Vec3d(
                    playerLocation.x() + lookAngle.x(),
                    playerLocation.y() + lookAngle.y(),
                    playerLocation.z() + lookAngle.z()
                );
    
                player.getLevel().spawnParticles('minecraft:sonic_boom', true, particleTarget.x(), particleTarget.y() + 1.15, particleTarget.z(), 0, 0, 0, 1, 0);
            }

            var pos = player.getEyePosition(); // Player's current position
            var look = player.getLookAngle(); // Player's look vector (direction they are looking)
            var start = pos.add(look.scale(0)); // Offset for the start of the AABB (0 blocks in front of the player)
            var end = pos.add(look.scale(24)); // Offset for the end of the AABB (7 blocks away from the player)

            var aabb = AABB.of(start.x(), start.y(), start.z(), end.x(), end.y(), end.z());
            player.getLevel().getEntitiesWithin(aabb).forEach(target => {
                if (target !== player) {
                    let dx = target.getX() - player.getX()
                    let dy = target.getY() - player.getY()
                    let dz = target.getZ() - player.getZ()
                    // let dist = Math.sqrt((dx * dx) + (dy * dy) + (dz * dz))
                    let dist = 2

                    let knockbackStrength = 2.5
                    let vx = (dx / dist) * knockbackStrength
                    let vy = (dy / dist) * knockbackStrength
                    let vz = (dz / dist) * knockbackStrength
                    target.setMotion(vx, vy, vz)
                    if (target.isPlayer()) {
                        target.connection.send(new ClientboundSetEntityMotionPacket(target));
                    }
                    let damageSource = getDamageSourceBothSides(level, "minecraft:sonic_boom", player, target)
                    target.attack(damageSource, 12)
                    if (!target?.potionEffects) {return}
                    target.potionEffects.add('dampened:code', 10 * 20, 0, false, false)
                }
            })
            // entity.swing("MAIN_HAND", true)
        }
    })
    .lastTick((entity, entry, holder, enabled) => {
        if (enabled) {
            // var playerPowerBar = IMPASSE_KINETIC_REF.getEntry(entity)
            // playerPowerBar.set(0);
        }
    });
});
