/*
    @author Hertz
    @version 1.0
*/

let EnergyBarReference = Java.loadClass('net.threetag.palladium.power.energybar.EnergyBarReference');
const LIGHTNING_REF = new EnergyBarReference('arrzenhanced', 'lightning_charge');
// const speedLevels = [0.0, 0.25, 0.50, 0.85, 1.15, 1.55, 1.75, 2.0, 2.15, 2.3, 2.7, 2.8, 3.0]
// const speedLevels = [0, 0.075, 0.1,0.125, 0.15,0.175,0.2,0.225,0.25,0.275,0.3,0.325,0.35,0.375,0.4,0.425,0.45,0.475,0.5,0.525,0.55,0.575,0.6,0.625]
// var speedLevels = [0, 0.075, 0.1, 0.125, 0.15, 0.175, 0.3, 0.7, 1.0, 2, 3, 4, 0, 2.888888888888889,3.111111111111111,3.3333333333333335,3.5555555555555554,3.7777777777777777,4,4.222222222222222,4.444444444444445,4.666666666666667,4.888888888888889,5.111111111111111,5.333333333333333,5.555555555555555,5.777777777777778,6,6.222222222222222,6.444444444444445,6.666666666666667]
// var speedLevels = [0, 0.075, 0.1, 0.125, 0.5,0.625,0.75,0.875,1,1.125,1.25,1.375,1.5,1.625,1.75,1.875,2,2.125,2.25,2.375,2.5,2.625,2.75,2.875,3,3.125,3.25,3.375,3.5,3.625,3.75]
var speedLevels = [
    0,
    0.125,
    0.25,
    0.375,
    0.5,
    0.625,
    0.75,
    0.875,
    1,
    1.125,
    1.25,
    1.375,
    1.5,
    1.625,
    1.75,
    1.875,
    2,
    2.125,
    2.25,
    2.375,
    2.5,
    2.625,
    2.75,
    2.875,
    3,
    3.125,
    3.25,
    3.375,
    3.5,
    3.625,
    3.75
]
// 1/6 (reversion)
// 1/8

/*
arrzenhanced.speed
arrzenhanced.maxSpeed
arrzenhanced.speedColor
arrzenhanced.tachyonBoost
*/

function resolveAllegedBooleanFromObject(thing) {
    if (thing.toString() == 'true') { return true; }
    if (thing.toString() == 'false') { return false; }
    return null
}

StartupEvents.registry('palladium:abilities', (event) => {
    
    event.create('arrzenhanced:activate_speed')
    .icon(palladium.createItemIcon('minecraft:feather'))
    .tick((entity, entry, holder, enabled) => {
        if (enabled) {
            var currentSpeed = palladium.getProperty(entity, 'arrzenhanced.speed')

            entity.modifyAttribute("minecraft:generic.movement_speed", "45d66472-0057-4ecf-9785-aa1c36bc54de", speedLevels[currentSpeed], "ADDITION")
            entity.modifyAttribute("palladium:destroy_speed", "3529782e-8ce4-4d2b-9d74-0efd983c4034", speedLevels[currentSpeed], "ADDITION")

            palladium.setProperty(entity, 'arrzenhanced.speedActive', true);
        };
    });
    
    event.create('arrzenhanced:reset_speed')
    .icon(palladium.createItemIcon('minecraft:anvil'))
    .tick((entity, entry, holder, enabled) => {
        if (enabled) {
            entity.removeAttribute("minecraft:generic.movement_speed", "45d66472-0057-4ecf-9785-aa1c36bc54de")
            entity.removeAttribute("palladium:destroy_speed", "3529782e-8ce4-4d2b-9d74-0efd983c4034")

            entity.tags.remove('arrz.speedburst.active');

            // palladium.setProperty(entity, 'arrzenhanced.speed', 0);
            palladium.setProperty(entity, 'arrzenhanced.speedActive', false);
            
            // palladium.setProperty(entity, 'arrzenhanced.maxSpeed', 18);
            // palladium.setProperty(entity, 'arrzenhanced.speedColor', 2);
            // palladium.setProperty(entity, 'arrzenhanced.speedColor', 0);
        };
    });
    
    event.create('arrzenhanced:add_speed')
    .icon(palladium.createItemIcon('minecraft:feather'))
    .tick((entity, entry, holder, enabled) => {
        if (enabled) {
            const currentSpeed = palladium.getProperty(entity, 'arrzenhanced.speed')
            const maxSpeed = palladium.getProperty(entity, 'arrzenhanced.maxSpeed')
            const extraSpeed = palladium.getProperty(entity, 'arrzenhanced.tachyonBoost')
            var velocityBoost = palladium.getProperty(entity, 'arrzenhanced.velocityBoost')

            if (currentSpeed >= speedLevels.length) { return } // if out of bounds, bail
            if (currentSpeed+1 > maxSpeed) { return } // if curspeed+1 out of bounds, bail
            var nextSpeed = speedLevels[currentSpeed+1] == undefined ? speedLevels[maxSpeed] : speedLevels[currentSpeed+1]

            entity.modifyAttribute("minecraft:generic.movement_speed", "45d66472-0057-4ecf-9785-aa1c36bc54de", nextSpeed, "ADDITION")
            entity.modifyAttribute("palladium:destroy_speed", "3529782e-8ce4-4d2b-9d74-0efd983c4034", currentSpeed+1, "ADDITION")

            palladium.setProperty(entity, 'arrzenhanced.speed', currentSpeed+1);
        };
    });
    
    event.create('arrzenhanced:remove_speed')
    .icon(palladium.createItemIcon('minecraft:anvil'))
    .tick((entity, entry, holder, enabled) => {
        if (enabled) {
            const currentSpeed = palladium.getProperty(entity, 'arrzenhanced.speed')
            const maxSpeed = palladium.getProperty(entity, 'arrzenhanced.maxSpeed')
            if (currentSpeed - 1 < 0) { return } // if out of bounds, bail
            var nextSpeed = speedLevels[currentSpeed-1]
            if (currentSpeed - 1 > maxSpeed) {
                nextSpeed = speedLevels[maxSpeed]
                entity.modifyAttribute("minecraft:generic.movement_speed", "45d66472-0057-4ecf-9785-aa1c36bc54de", nextSpeed, "ADDITION")
                entity.modifyAttribute("palladium:destroy_speed", "3529782e-8ce4-4d2b-9d74-0efd983c4034", maxSpeed, "ADDITION")
                palladium.setProperty(entity, 'arrzenhanced.speed', maxSpeed)
            } else {
                entity.modifyAttribute("minecraft:generic.movement_speed", "45d66472-0057-4ecf-9785-aa1c36bc54de", nextSpeed, "ADDITION")
                entity.modifyAttribute("palladium:destroy_speed", "3529782e-8ce4-4d2b-9d74-0efd983c4034", currentSpeed-1, "ADDITION")
                palladium.setProperty(entity, 'arrzenhanced.speed', currentSpeed-1)
            }
        };
    });
    
    event.create('arrzenhanced:add_temp_max_speed')
    .icon(palladium.createItemIcon('minecraft:anvil'))
    .addProperty('levels', 'integer', 1, 'How many speed levels to add')
    .addProperty('new_color', 'integer', -1, 'New color (optional)')
    .firstTick((entity, entry, holder, enabled) => {
        if (enabled) {
            var levels = entry.getPropertyByName('levels')
            var new_color = entry.getPropertyByName('new_color')
            var speedColor = palladium.getProperty(entity, 'arrzenhanced.speedColor')
            var oldSpeedColor = palladium.getProperty(entity, 'arrzenhanced.oldSpeedColor')
            
            var tachyonBoost = palladium.getProperty(entity, 'arrzenhanced.tachyonBoost')
            var velocityBoost = palladium.getProperty(entity, 'arrzenhanced.velocityBoost')

            if (new_color != -1 && (oldSpeedColor == speedColor)) { // if we want to change it, and it hasn't been changed
                palladium.setProperty(entity, 'arrzenhanced.oldSpeedColor', speedColor); // store
                palladium.setProperty(entity, 'arrzenhanced.speedColor', new_color); // change
            }
            
            var speedMax = palladium.getProperty(entity, 'arrzenhanced.maxSpeed')
            var realSpeed = (speedMax - tachyonBoost) - velocityBoost
            
            var newTach = tachyonBoost + levels
            // entity.tell("FIRST TICK")
            // entity.tell(newTach)
            // entity.tell(realSpeed + (newTach))

            if (newTach <= 0) {newTach = 0}
            if (newTach >= 9) {newTach = 9}
            palladium.setProperty(entity, 'arrzenhanced.tachyonBoost', newTach);
            palladium.setProperty(entity, 'arrzenhanced.maxSpeed', realSpeed + (newTach + velocityBoost));
        };
    })
    .lastTick((entity, entry, holder, enabled) => {
        if (enabled) {
            var levels = entry.getPropertyByName('levels')
            var new_color = entry.getPropertyByName('new_color')
            var speedMax = palladium.getProperty(entity, 'arrzenhanced.maxSpeed')
            var tachyonBoost = palladium.getProperty(entity, 'arrzenhanced.tachyonBoost')
            var velocityBoost = palladium.getProperty(entity, 'arrzenhanced.velocityBoost')
            var oldSpeedColor = palladium.getProperty(entity, 'arrzenhanced.oldSpeedColor')

            if (new_color != -1) { // if there is a stored val AND we're changing back
                palladium.setProperty(entity, 'arrzenhanced.speedColor', oldSpeedColor); // restore it
            }

            // 3 - 3
            // (12 - 3) + (3 - 3)
            // console.log("LAST TICK")
            // console.log(tachyonBoost - levels)
            // console.log((speedMax - levels) + (tachyonBoost - levels))

            var realSpeed = speedMax - tachyonBoost
            var newTach = tachyonBoost - levels
            
            if (newTach < 0) {newTach = 0; levels = 0;}
            palladium.setProperty(entity, 'arrzenhanced.tachyonBoost', newTach)
            palladium.setProperty(entity, 'arrzenhanced.maxSpeed', realSpeed + (newTach + velocityBoost));
            
            var currentSpeed = palladium.getProperty(entity, 'arrzenhanced.speed')
            if (currentSpeed > realSpeed + (newTach + velocityBoost)) {
                palladium.setProperty(entity, 'arrzenhanced.speed', realSpeed + (newTach + velocityBoost))
                var nextSpeed = speedLevels[realSpeed + (newTach + velocityBoost)]
                entity.modifyAttribute("minecraft:generic.movement_speed", "45d66472-0057-4ecf-9785-aa1c36bc54de", nextSpeed, "ADDITION")
                entity.modifyAttribute("palladium:destroy_speed", "3529782e-8ce4-4d2b-9d74-0efd983c4034", (realSpeed + (newTach + velocityBoost)), "ADDITION")
            }
        }
    })
});

StartupEvents.registry('palladium:condition_serializer', (event) => {

    event.create('arrzenhanced:speed_above')
    .addProperty("speedforce_id", "string", "arrzenhanced.speed", "ID used for speed control")
    .addProperty("amount", "integer", 1, "Amount control needs to be over or meet")
    .test((entity, props) => {
        let speedforce_id = props.get("speedforce_id")
        let amount = props.get("amount")
        let playerSpeed = palladium.getProperty(entity, speedforce_id)
        return playerSpeed >= amount
    })

    event.create('arrzenhanced:speed_active')
    .test((entity, props) => {
        if (entity.type != 'minecraft:player') {return false}
        let speedStatus = resolveAllegedBooleanFromObject(palladium.getProperty(entity, 'arrzenhanced.speedActive'))
        // console.log(typeof speedStatus)
        // console.log(speedStatus == 'true')
        // console.log(speedStatus == 'false')
        return speedStatus
    })

    event.create('arrzenhanced:speed_below')
    .addProperty("speedforce_id", "string", "arrzenhanced.speed", "ID used for speed control")
    .addProperty("amount", "integer", 1, "Amount control needs to be under")
    .test((entity, props) => {
        let speedforce_id = props.get("speedforce_id")
        let amount = props.get("amount")
        let playerSpeed = palladium.getProperty(entity, speedforce_id)
        return playerSpeed < amount
    })

    event.create('arrzenhanced:speed_is')
    .addProperty("speedforce_id", "string", "arrzenhanced.speed", "ID used for speed control")
    .addProperty("amount", "integer", 1, "Amount control needs to be under")
    .test((entity, props) => {
        let speedforce_id = props.get("speedforce_id")
        let amount = props.get("amount")
        let playerSpeed = palladium.getProperty(entity, speedforce_id)
        return playerSpeed == amount
    })

    event.create('arrzenhanced:speed_color_is')
    .addProperty("color_id", "string", "arrzenhanced.speedColor", "ID used for speed color")
    .addProperty("number", "integer", 1, "Color number to test for")
    .test((entity, props) => {
        var Integer = Java.loadClass("java.lang.Integer")
        var Double = Java.loadClass("java.lang.Double")
        
        let color_id = props.get("color_id")
        let num = props.get("number")
        let playerColor = palladium.getProperty(entity, color_id)
        return Integer.valueOf(new Double(playerColor).intValue()) == Integer.valueOf(new Double(num).intValue())
        // return false
    })

});