/*
    @author PhantomPig
    @editor Hertz
    @source https://discord.com/channels/116908382878695430/1062032236297338900/1285412610715553832
    @version 1.0
*/

var PlayerUtil = Java.loadClass('net.threetag.palladium.util.PlayerUtil');

global.playSoundToAll = function(entity, range, sound, category, volume, pitch) {
    // PlayerUtil['playSoundToAll(net.minecraft.class_1937,double,double,double,double,net.minecraft.class_3414,net.minecraft.class_3419,float,float)'](entity.getLevel(), entity.x, entity.y, entity.z, range, sound, category, volume, pitch);
    PlayerUtil['playSoundToAll(net.minecraft.world.level.Level,double,double,double,double,net.minecraft.resources.ResourceLocation,net.minecraft.sounds.SoundSource,float,float)'](entity.getLevel(), entity.x, entity.y, entity.z, range, sound, category, volume, pitch);
}

StartupEvents.registry('palladium:abilities', (event) => {
    event.create('arrzenhanced:throw_lightning_offset')
    .icon(palladium.createItemIcon('minecraft:arrow'))
    .addProperty('entity_type', 'string', 'palladium:custom_projectile', 'Entity type')
    .addProperty('entity_data', 'compound_tag', null, 'NBT Data')
    .addProperty('yawOverride', 'integer', -999, 'Yaw Override')
    .addProperty('pitchOverride', 'integer', -999, 'Pitch Override')
    .addProperty('yawOffset', 'integer', -999, 'Yaw Offset')
    .addProperty('pitchOffset', 'integer', -999, 'Pitch Offset')
    .addProperty('speed', 'integer', 5, 'Speed')
    .tick((entity, entry, holder, enabled) => {
        if (enabled) {
            var p_type = entry.getPropertyByName('entity_type')
            var p_nbt = entry.getPropertyByName('entity_data')
            var p_yawOverride = entry.getPropertyByName('yawOverride')
            var p_pitchOverride = entry.getPropertyByName('pitchOverride')
            var p_yawOffset = entry.getPropertyByName('yawOffset')
            var p_pitchOffset = entry.getPropertyByName('pitchOffset')
            var p_speed = entry.getPropertyByName('speed')
    
            global.LightningAtOffset_conflictAvoidingSuffixDois(
                entity,
                p_type,
                p_nbt,
                p_yawOverride,
                p_pitchOverride,
                p_yawOffset,
                p_pitchOffset,
                p_speed
            )
        }
    })
})

global.toRadians = (deg) => {return deg * (JavaMath.PI / 180)}

global.LightningAtOffset_conflictAvoidingSuffixDois = function(entity, type, nbt, yawOverride, pitchOverride, yawOffset, pitchOffset, speed) {
    var projectile = entity.block.createEntity(type);
    var lightningColor = palladium.getProperty(entity, 'arrzenhanced.speedColor')
    var trailMappings = {
        0: "yellow_lightning",
        1: "orange_lightning",
        2: "white_lightning",
        3: "blue_lightning",
        4: "tachyon_lightning",
        5: "red_lightning",
        6: "green_lightning",
        7: "purple_lightning",
        8: "pink_lightning",
        9: "blue_lightning",
        10: "purple_lightning",
        11: "red_lightning",
        12: "yellow_lightning",
        13: "blue_lightning",
        // 9: "flashthetitan_lightning",
        // 10: "luna_lightning",
        // 11: "hertz_lightning",
        // 13: "quackers_lightning",
    }
    var resourceLocation = trailMappings[lightningColor] == undefined ? trailMappings[0] : trailMappings[lightningColor];
    if (nbt == null) {
        nbt = {
            "Damage": 15,
            "Gravity": 0,
            "Size": 1,
            "Lifetime": 120,
            "DieOnEntityHit": true,
            "DieOnBlockHit": true,
            "Appearances": [
                {
                    "Type": "trail",
                    "Trail": `arrzenhanced:speedforce/${resourceLocation}`
                }
            ]
        }
    }
    projectile.mergeNbt(nbt);

    var pitch = -global.toRadians(entity.getPitch() + pitchOffset);
    var yaw = -global.toRadians(entity.getYaw() + yawOffset);

    if (pitchOverride != -999) pitch = global.toRadians(pitchOverride);
    if (yawOverride != -999) yaw = global.toRadians(yawOverride);

    var x = entity.getX() + Math.cos(pitch) * Math.sin(yaw),
    y = entity.getY() + entity.getEyeHeight() + Math.sin(pitch),
    z = entity.getZ() + Math.cos(pitch) * Math.cos(yaw);
    
    projectile.setPos(x, y, z)
    projectile.setDeltaMovement(entity.getLookAngle().scale(speed))
    projectile.setRotation(-entity.getYaw(), -entity.getPitch())

    projectile.setOwner(entity)
    projectile.spawn()
    entity.swing("MAIN_HAND", true)

    global.playSoundToAll(entity, 12, 'arrzenhanced:speedforce.lightning_throw', "players", 1, 1)
}

StartupEvents.registry('sound_event', event => {
    event.create('arrzenhanced:speedforce.lightning_throw')
})