/*
    @author Hertz
    @version 1.0
*/
let $Vec3 = Java.loadClass('net.minecraft.world.phys.Vec3')
let ClientboundSetEntityMotionPacket = Java.loadClass('net.minecraft.network.protocol.game.ClientboundSetEntityMotionPacket');

StartupEvents.registry('palladium:abilities', (event) => {

    event.create('arrzenhanced:wall_run')
    .icon(palladium.createItemIcon('minecraft:ladder'))
    .tick((entity, entry, holder, enabled) => global.hertz_wallrun_script(entity, entry, holder, enabled));

});

global.hertz_wallrun_script = (entity, entry, holder, enabled) => {
    if (enabled) {
        let vec3 = entity.getDeltaMovement()
        let currentSpeed = palladium.getProperty(entity, 'arrzenhanced.speed')
        if (
            (entity.block.north != 'minecraft:air' ||
            entity.block.south != 'minecraft:air' ||
            entity.block.east != 'minecraft:air' ||
            entity.block.west != 'minecraft:air')
        ) {
            let scaling = currentSpeed*0.16
            if (scaling > 2) {scaling = 2}
            if (scaling < 0.6) {scaling = 0.6}
            // entity.tell(scaling)
            let newVec3 = new $Vec3(vec3.x(), scaling, vec3.z())
            entity.setDeltaMovement(newVec3)
            entity.connection.send(new ClientboundSetEntityMotionPacket(entity));
        }
    };
}