var positions = [
    { x: 0, y: 0, z: -10, scale: [10, 10, 0] }, { x: -10, y: 0, z: -10, scale: [10, 10, 0] },
    { x: 0, y: 10, z: -10, scale: [10, 10, 0] }, { x: -10, y: 10, z: -10, scale: [10, 10, 0] },

    { x: 0, y: 0, z: 10, scale: [10, 10, 0] }, { x: -10, y: 0, z: 10, scale: [10, 10, 0] },
    { x: 0, y: 10, z: 10, scale: [10, 10, 0] }, { x: -10, y: 10, z: 10, scale: [10, 10, 0] },

    { x: -10, y: 0, z: -0, scale: [0, 10, 10] }, { x: -10, y: 0, z: -10, scale: [0, 10, 10] },
    { x: -10, y: 10, z: -0, scale: [0, 10, 10] }, { x: -10, y: 10, z: -10, scale: [0, 10, 10] },

    { x: 10, y: 0, z: -10, scale: [0, 10, 10] }, { x: 10, y: 0, z: 0, scale: [0, 10, 10] },
    { x: 10, y: 10, z: -10, scale: [0, 10, 10] }, { x: 10, y: 10, z: 0, scale: [0, 10, 10] },
    
    { x: -10, y: 20, z: 0, scale: [10, 0, 10] }, { x: -10, y: 20, z: -10, scale: [10, 0, 10] },
    { x: 0, y: 20, z: 0, scale: [10, 0, 10] }, { x: 0, y: 20, z: -10, scale: [10, 0, 10] },

    { x: -10, y: 0.01, z: 0, scale: [10, 0, 10] }, { x: -10, y: 0.01, z: -10, scale: [10, 0, 10] },
    { x: 0, y: 0.01, z: 0, scale: [10, 0, 10] }, { x: 0, y: 0.01, z: -10, scale: [10, 0, 10] },
];

StartupEvents.registry('palladium:abilities', (event) => {
    event.create('arrzenhanced:shadow_dome')
        .icon(palladium.createItemIcon('minecraft:anvil'))
        .firstTick((entity, entry, holder, enabled) => {
            if (!enabled) return;

            /*
            const positions = [
                { x: -10, y: 0, z: -10, scale: [20, 20, 0] },
                { x: -10, y: 0, z: 10, scale: [20, 20, 0] },
                { x: -10, y: 0, z: -10, scale: [0, 20, 20] },
                { x: 10, y: 0, z: -10, scale: [0, 20, 20] },
                { x: -10, y: 20, z: -10, scale: [20, 0, 20] },
                { x: -10, y: 0.01, z: -10, scale: [20, 0, 20] }
            ];
            */

            positions.forEach(pos => {
                /*
                var projectile = entity.block.createEntity(type);
                projectile.mergeNbt(nbt);
                projectile.setPos(x, y, z)
                */
                var block_disp = entity.getLevel().createEntity('minecraft:block_display');
                block_disp.setPos(entity.getX() + pos.x, entity.getY() + pos.y, entity.getZ() + pos.z)
                block_disp.mergeNbt({
                    NoGravity: true,
                    Silent: true,
                    Tags: [`arrzenhanced.shadow_dome.${entity.getGameProfile().getName()}`],
                    width: 20,
                    height: 20,
                    transformation: {
                        left_rotation: [0, 0, 0, 1],
                        right_rotation: [0, 0, 0, 1],
                        translation: [0, 0, 0],
                        scale: pos.scale
                    },
                    block_state: { Name: 'minecraft:black_concrete' }
                })
                block_disp.noCulling = true
                block_disp.spawn()
            });
            
            var umbra_stand = entity.getLevel().createEntity('minecraft:armor_stand');
            umbra_stand.setPos(entity.getX(), entity.getY(), entity.getZ())
            umbra_stand.mergeNbt({
                NoGravity: true,
                Silent: true,
                Invisible: true,
                Marker: true,
                Tags: [`arrzenhanced.shadow_dome_effect.${entity.getGameProfile().getName()}`]
            })
            umbra_stand.spawn()
            // entity.tags.add('arrzenhanced.umbrakinesis.dome_active')
        })
        .tick((entity, entry, holder, enabled) => {
            if (!enabled) return;

            let header = entity.getLevel().getEntities().filter(e => e.tags.contains(`arrzenhanced.shadow_dome_effect.${entity.getGameProfile().getName()}`))
            if (header.length > 0) {
                let valid = header[0]
                var players = entity.getLevel().getEntitiesWithin(AABB.of(
                    valid.getX() - 10, valid.getY() - 10, valid.getZ() - 10,
                    valid.getX() + 10, valid.getY() + 10, valid.getZ() + 10
                )).filter(e => e.type == 'minecraft:player' && !palladium.superpowers.hasSuperpower(e, 'arrzenhanced:umbrakinesis'));

                var validHealTargets = entity.getLevel().getEntitiesWithin(AABB.of(
                    valid.getX() - 10, valid.getY() - 10, valid.getZ() - 10,
                    valid.getX() + 10, valid.getY() + 10, valid.getZ() + 10
                )).filter(e => e.type == 'minecraft:player' && palladium.superpowers.hasSuperpower(e, 'arrzenhanced:umbrakinesis'))

                players.forEach(player => {
                    player.potionEffects.add('minecraft:blindness', 2*20, 0, false, false)
                });

                validHealTargets.forEach(target => {
                    if (!target?.potionEffects) return
                    if (target.potionEffects.getDuration('minecraft:regeneration') <= 0) {
                        target.potionEffects.add('minecraft:regeneration', 3 * 20, 2, false, false)
                    }
                });
            }
        })
        .lastTick((entity, entry, holder, enabled) => {
            if (!enabled) return;

            // const entities = entity.getLevel().getEntitiesWithin(AABB.of(
            //     entity.x - 100, entity.y - 100, entity.z - 100,
            //     entity.x + 100, entity.y + 100, entity.z + 100
            // )).filter(e => e.tags.contains(`arrzenhanced.shadow_dome.${entity.getGameProfile().getName()}`) || e.tags.contains(`arrzenhanced.shadow_dome_effect.${entity.getGameProfile().getName()}`));

            var allentities = entity.getLevel().getEntities().filter(e => e.tags.contains(`arrzenhanced.shadow_dome.${entity.getGameProfile().getName()}`) || e.tags.contains(`arrzenhanced.shadow_dome_effect.${entity.getGameProfile().getName()}`));

            allentities.forEach(e => e.kill());
            entity.tags.remove('arrzenhanced.umbrakinesis.dome_active')
        });
});
