/*
    @author Hertz
    @version 1.0
*/

let ClientboundSetEntityMotionPacket = Java.loadClass('net.minecraft.network.protocol.game.ClientboundSetEntityMotionPacket');

let $ClipContext = Java.loadClass('net.minecraft.world.level.ClipContext')
let $ProjectileUtil = Java.loadClass('net.minecraft.world.entity.projectile.ProjectileUtil')

/**
 * 
 * @param {Internal.LivingEntity} entity 
 * @param {Internal.ServerLevel} level 
 * @param {number} distance
 * @returns {Object}
 * Returns the block and/or entity that the entity is looking at.
 * Ignores non-solid blocks and spectators.
 */
let advancedRayTrace = (entity, level, distance) => {
    let eyePos = entity.eyePosition;
    let viewVec = entity.getViewVector(1)
    let endPos = eyePos.add(viewVec.x() * distance, viewVec.y() * distance, viewVec.z() * distance)
    let aabb = AABB.of(eyePos.x(), eyePos.y(), eyePos.z(), endPos.x(), endPos.y(), endPos.z())

    let ray = $ProjectileUtil.getEntityHitResult(level, entity, eyePos, endPos, aabb, (e) => {
        return !e.isSpectator()
    }, 0)

    let clip = new $ClipContext(
        entity.getEyePosition(1), 
        entity.getEyePosition(1).add(entity.getLookAngle().scale(distance)), 
        'collider', 'none', 
        entity
    )
    let hit = level.clip(clip)
    if (ray == null) {
        return {
            block: hit.getBlockPos() ? level.getBlock(hit.getBlockPos()) : null,
            entity: null
        }
    }
    return {
        block: level.getBlock(hit.getBlockPos()),
        entity: ray.entity
    }
}

function resolveAllegedBooleanFromObject(thing) {
    if (thing.toString() == 'true') { return true; }
    if (thing.toString() == 'false') { return false; }
    return null
}

StartupEvents.registry('palladium:abilities', (event) => {

    event.create('arrzenhanced:knockback_raycast')
    .icon(palladium.createItemIcon('minecraft:piston'))
    .addProperty('distance', 'integer', 10, 'Raycast distance')
    .addProperty('strength', 'float', 1.2, 'Knockback strength')
    .tick((entity, entry, holder, enabled) => {
        if (enabled) {
            var distance = entry.getPropertyByName('distance');
            var knockbackStrength = entry.getPropertyByName('strength');

            let target = advancedRayTrace(entity, entity.getLevel(), distance).entity
            if (!target) {return}
            if (target != entity) {
                let dx = target.getX() - entity.getX()
                let dy = target.getY() - entity.getY()
                let dz = target.getZ() - entity.getZ()
                // override dist?
                let dist = Math.sqrt((dx * dx) + (dy * dy) + (dz * dz))
                let vx = (dx / dist) * knockbackStrength
                let vy = (dy / dist) * knockbackStrength
                let vz = (dz / dist) * knockbackStrength
                // target.tell(`X: ${target.getMotionX()}, Y: ${target.getMotionY()}, Z:${target.getMotionZ()}`)
                // target.tell(`VX: ${vx}, VY: ${vy}, VZ:${vz}`)
                target.setMotion(vx + target.getMotionX(), vy + target.getMotionY(), vz + target.getMotionZ())
                if (target.isPlayer()) {
                    target.connection.send(new ClientboundSetEntityMotionPacket(target));
                }
            }
        }
    })
});