const $EnchantmentCategory = Java.loadClass('net.minecraft.world.item.enchantment.EnchantmentCategory')

StartupEvents.registry("enchantment", (event) => {
    event.create("arrzenhanced:genetic_harvesting")
    .minLevel(1)
    .maxLevel(1)
    .category($EnchantmentCategory.WEAPON)
    .canEnchant((/** @type {Internal.ItemStack} */ i) => {
        return i.getItem().id == 'arrzenhanced:titanium_dagger'
    })
    .displayName('Genetic Harvesting')
    .postAttack(
        (source, target, lvl) => {
            if (!source || !source.isLiving() || !target || !target.isLiving()) return;
            if (!source.isPlayer()) {return}
            // if (source.mainHandItem.id != 'arrzenhanced:titanium_dagger') {return}
            if (source.offHandItem.id != 'minecraft:glass_bottle') {return}
            // if (!target || target.type != 'minecraft:villager') {return}

            if (Math.random() < 0.05) {
                source.offHandItem.count--
                source.give(Item.of('arrzenhanced:blood_bottle'))
            }
        }
    )
});
