StartupEvents.registry('palladium:abilities', (event) => {
    event.create('arrzenhanced:particles_at_hands')
    .icon(palladium.createItemIcon('minecraft:note_block'))
    .tick((entity, entry, holder, enabled) => global.particles_in_hands(entity, entry, holder, enabled));
});

global.particles_in_hands = (entity, entry, holder, enabled) => {
    if (enabled) {
        if (entity.age % 2 != 0) {return}
        var eyePos = entity.getEyePosition(1.0)
        var lookVec = entity.getLookAngle()
        var rightVec = lookVec.cross(Vec3d(0, 1, 0)).normalize()

        var forwardOffset = 0
        var sideOffset = 0.3
        var downOffset = 0.9

        var rightHandOffset = lookVec.scale(forwardOffset)
            .add(rightVec.scale(sideOffset))
            .add(Vec3d(0, -downOffset, 0))
        var rightHandPos = eyePos.add(rightHandOffset)

        var leftHandOffset = lookVec.scale(forwardOffset)
            .add(rightVec.scale(-sideOffset))
            .add(Vec3d(0, -downOffset, 0))
        var leftHandPos = eyePos.add(leftHandOffset)

        entity.getLevel().spawnParticles(
            'minecraft:flame',
            true,
            rightHandPos.x(), rightHandPos.y(), rightHandPos.z(),
            0.1, 0.1, 0.1,
            4, 0
        )
        
        entity.getLevel().spawnParticles(
            'minecraft:flame',
            true,
            leftHandPos.x(), leftHandPos.y(), leftHandPos.z(),
            0.1, 0.1, 0.1,
            4, 0
        )
    }
}