/*
    @author Hertz
    @version 1.0
*/


StartupEvents.registry('palladium:abilities', (event) => {
    
    event.create('arrzenhanced:temporary_overwrite_value')
    .icon(palladium.createItemIcon('minecraft:anvil'))
    .addProperty('main_prop', 'string', "arrzenhanced.warpwave.color", 'Main property name')
    .addProperty('new_value', 'integer', 2, 'Value to switch to')
    .addProperty('old_prop', 'string', "arrzenhanced.warpwave.color.old", 'Backup/old property name')
    .firstTick((entity, entry, holder, enabled) => {
        if (enabled) {
            var main_prop = entry.getPropertyByName('main_prop')
            var old_prop = entry.getPropertyByName('old_prop')

            var newValue = entry.getPropertyByName('new_value')
            var originalValue = palladium.getProperty(entity, main_prop)
            var backupValue = palladium.getProperty(entity, old_prop)
            
            palladium.setProperty(entity, main_prop, newValue)
            palladium.setProperty(entity, old_prop, originalValue)
        };
    })
    .lastTick((entity, entry, holder, enabled) => {
        if (enabled) {
            var main_prop = entry.getPropertyByName('main_prop')
            var old_prop = entry.getPropertyByName('old_prop')
            var backupValue = palladium.getProperty(entity, old_prop)

            palladium.setProperty(entity, old_prop, backupValue)
            palladium.setProperty(entity, main_prop, backupValue)
        }
    })
});