/*
    @author Hertz
    @version 1.0
*/

var STRENGTHS = [Text.green("LOW"), Text.yellow("MEDIUM"), Text.red("HIGH")]

StartupEvents.registry('palladium:abilities', (event) => {
    
    event.create('arrzenhanced:add_warpwave_strength')
    .icon(palladium.createItemIcon('minecraft:feather'))
    .addProperty("field", "string", "arrzenhanced.warpwave.strength", "Field to modify")
    .addProperty("value", "integer", 1, "Value to add")
    .tick((entity, entry, holder, enabled) => {
        if (enabled) {
            let field = entry.getPropertyByName("field")
            let value = Number(entry.getPropertyByName("value"))

            let definedField = palladium.getProperty(entity, field)

            if (definedField == 2) {return}
            if (definedField >= 2) {
                palladium.setProperty(entity, field, 2);
                return
            }
            entity.statusMessage = Text.of("Intensity: ").append(STRENGTHS[definedField+value])
            palladium.setProperty(entity, field, definedField+value);
        };
    });
    
    event.create('arrzenhanced:remove_warpwave_strength')
    .icon(palladium.createItemIcon('minecraft:anvil'))
    .addProperty("field", "string", "arrzenhanced.warpwave.strength", "Field to modify")
    .addProperty("value", "integer", 1, "Value to subtract")
    .tick((entity, entry, holder, enabled) => {
        if (enabled) {
            let field = entry.getPropertyByName("field")
            let value = Number(entry.getPropertyByName("value"))

            let definedField = palladium.getProperty(entity, field)
            
            if (definedField == 0) {return}
            if (definedField <= 0) {
                palladium.setProperty(entity, field, 0);
                return
            }
            entity.statusMessage = Text.of("Intensity: ").append(STRENGTHS[definedField-value])
            palladium.setProperty(entity, field, definedField-value);
        };
    });
});

StartupEvents.registry('palladium:condition_serializer', (event) => {

    // event.create('arrzenhanced:speed_color_is')
    // .addProperty("color_id", "string", "arrzenhanced.speedColor", "ID used for speed color")
    // .addProperty("number", "integer", 1, "Color number to test for")
    // .test((entity, props) => {
    //     var Integer = Java.loadClass("java.lang.Integer")
    //     var Double = Java.loadClass("java.lang.Double")
    //     let color_id = props.get("color_id")
    //     let num = props.get("number")
    //     let playerColor = palladium.getProperty(entity, color_id)
    //     return Integer.valueOf(new Double(playerColor).intValue()) == Integer.valueOf(new Double(num).intValue())
    //     // return false
    // })

});