/*
    @author Hertz
    @version 1.0
*/
let $Vec3 = Java.loadClass('net.minecraft.world.phys.Vec3')
let ClientboundSetEntityMotionPacket = Java.loadClass('net.minecraft.network.protocol.game.ClientboundSetEntityMotionPacket');

StartupEvents.registry('palladium:abilities', (event) => {

    event.create('arrzenhanced:wallclimb')
    .icon(palladium.createItemIcon('minecraft:ladder'))
    .addProperty('speed', 'float', 0.2, 'Climbing speed')
    .tick((entity, entry, holder, enabled) => {
        if (enabled) {
            let vec3 = entity.getDeltaMovement()
            let speed = entry.getPropertyByName('speed')
            if (
                (entity.block.north != 'minecraft:air' ||
                entity.block.south != 'minecraft:air' ||
                entity.block.east != 'minecraft:air' ||
                entity.block.west != 'minecraft:air')
            ) {
                if (entity.isCrouching()) {
                    let newVec3 = new $Vec3(vec3.x(), 0, vec3.z())
                    entity.setDeltaMovement(newVec3)
                    entity.connection.send(new ClientboundSetEntityMotionPacket(entity));
                } else {
                    let newVec3 = new $Vec3(vec3.x(), speed, vec3.z())
                    entity.setDeltaMovement(newVec3)
                    entity.connection.send(new ClientboundSetEntityMotionPacket(entity));
                }
            }
        };
    });
});