/*
    @author Hertz
    @version 1.0
*/

function resolveAllegedBooleanFromObject(thing) {
    if (thing.toString() == 'true') { return true; }
    if (thing.toString() == 'false') { return false; }
    return null
}

StartupEvents.registry('palladium:abilities', (event) => {
    event.create('arrzenhanced:hide_armor')
    .icon(palladium.createItemIcon('minecraft:shield'))
    .firstTick((entity, entry, holder, enabled) => {
        if (enabled) {
            var inventory = entity.getInventory()
            entity.persistentData['wraithArmor'] = {}
            entity.persistentData['wraithArmor'].helmetId = inventory.getArmor(3).id
            entity.persistentData['wraithArmor'].helmetNbt = NBT.toTag(inventory.getArmor(3).nbt)
            entity.persistentData['wraithArmor'].chestplateId = inventory.getArmor(2).id
            entity.persistentData['wraithArmor'].chestplateNbt = NBT.toTag(inventory.getArmor(2).nbt)
            entity.persistentData['wraithArmor'].leggingsId = inventory.getArmor(1).id
            entity.persistentData['wraithArmor'].leggingsNbt = NBT.toTag(inventory.getArmor(1).nbt)
            entity.persistentData['wraithArmor'].bootsId = inventory.getArmor(0).id
            entity.persistentData['wraithArmor'].bootsNbt = NBT.toTag(inventory.getArmor(0).nbt)
            entity.setItemSlot(2, Item.of('minecraft:air'))
            entity.setItemSlot(3, Item.of('minecraft:air'))
            entity.setItemSlot(4, Item.of('minecraft:air'))
            entity.setItemSlot(5, Item.of('minecraft:air'))
            entity.tags.add('Arrz.WraithArmorStored')
        }
    })
    .lastTick((entity, entry, holder, enabled) => {
        if (enabled) {
            entity.setItemSlot(2, Item.of(entity.persistentData['wraithArmor'].bootsId, 1, entity.persistentData['wraithArmor'].bootsNbt))
            entity.setItemSlot(3, Item.of(entity.persistentData['wraithArmor'].leggingsId, 1, entity.persistentData['wraithArmor'].leggingsNbt))
            entity.setItemSlot(4, Item.of(entity.persistentData['wraithArmor'].chestplateId, 1, entity.persistentData['wraithArmor'].chestplateNbt))
            entity.setItemSlot(5, Item.of(entity.persistentData['wraithArmor'].helmetId, 1, entity.persistentData['wraithArmor'].helmetNbt))
            entity.tags.remove('Arrz.WraithArmorStored')
        }
    })
});