PalladiumEvents.registerAnimations((event) => {
    event.register('arrzee/current', 1, (builder) => {
        let progress_shield_right = animationUtil.getAnimationTimerAbilityValue(builder.getPlayer(), 'arrzenhanced:electricity_conduction', 'shield_r_hold_anim', builder.getPartialTicks());

        if (progress_shield_right > 0.0) {
            if (builder.isFirstPerson()) {
                // do first-person animations
                builder.get('right_arm')
                    .moveY(-2)
                    .moveZ(0)
                    .moveX(-8)
                    .setXRotDegrees(-60)
                    .setZRotDegrees(-70)
                    .setYRotDegrees(10)
                    .animate('InOutBounce', progress_shield_right);
            } else {
                // do third-person animations
                builder.get('right_arm')
                    .setXRotDegrees(-50)
                    .setZRotDegrees(0)
                    .setYRotDegrees(-70)
                    .animate('InOutBounce', progress_shield_right);
            }
        }

        let progress_shield_left = animationUtil.getAnimationTimerAbilityValue(builder.getPlayer(), 'arrzenhanced:electricity_conduction', 'shield_l_hold_anim', builder.getPartialTicks());

        if (progress_shield_left > 0.0) {
            if (builder.isFirstPerson()) {
                // do first-person animations
                builder.get('left_arm')
                .moveY(-2)
                .moveZ(0)
                .moveX(8)
                .setXRotDegrees(-60)
                .setZRotDegrees(70)
                .setYRotDegrees(-10)
                    .animate('InOutBounce', progress_shield_left);
            } else {
                // do third-person animations
                builder.get('left_arm')
                .setXRotDegrees(-50)
                .setZRotDegrees(0)
                .setYRotDegrees(70)
                    .animate('InOutBounce', progress_shield_left);
            }
        }

        let progress_pickup = animationUtil.getAnimationTimerAbilityValue(builder.getPlayer(), 'arrzenhanced:electric_gamma_radiation', 'pick_entity_arms', builder.getPartialTicks());

        if (progress_pickup > 0.0) {
            if (builder.isFirstPerson()) {
                // do first-person animations
                builder.get('left_arm')
                    .setXRotDegrees(0)
                    .setYRotDegrees(0)
                    .setZRotDegrees(0)
                    .animate('InOutBack', progress_pickup);

                builder.get('right_arm')
                    .setXRotDegrees(0)
                    .setYRotDegrees(0)
                    .setZRotDegrees(0)
                    .animate('InOutBack', progress_pickup);
            } else {
                // do third-person animations
                builder.get('left_arm')
                    .setXRotDegrees(-110)
                    .setZRotDegrees(0)
                    .setYRotDegrees(0)
                    .animate('InOutBack', progress_pickup);

                builder.get('right_arm')
                    .setXRotDegrees(-110)
                    .setZRotDegrees(0)
                    .setYRotDegrees(0)
                    .animate('InOutBack', progress_pickup);
            }
        }
    });
});

PalladiumEvents.registerAnimations((event) => {
    event.register('arrzee/thundercrash_transform1', 1, (builder) => {
        
    if (abilityUtil.isEnabled(builder.getPlayer(), "arrzenhanced:electric_gamma_radiation", "transform")) {

        const progress_transform1 = animationUtil.getAnimationTimerAbilityValue(builder.getPlayer(), 'arrzenhanced:electric_gamma_radiation', 'transform', builder.getPartialTicks(), 1, 10);
        if (progress_transform1 > 0 && !builder.isFirstPerson()) {

            builder.get('head')
            .setXRotDegrees(25)
            .setYRotDegrees(0)
            .setZRotDegrees(0)
            .animate('InOutCubic', progress_transform1);

            builder.get('body')
            .moveY(3)
            .moveZ(10)
            .setXRotDegrees(-50)
            .setYRotDegrees(0)
            .setZRotDegrees(0)
            .animate('InOutCubic', progress_transform1);

        builder.get('right_arm')
            .setXRotDegrees(-110)
            .setYRotDegrees(-15)
            .setZRotDegrees(20)
            .animate('InOutCubic', progress_transform1);

        builder.get('left_arm')
            .setXRotDegrees(-110)
            .setYRotDegrees(15)
            .setZRotDegrees(-20)
            .animate('InOutCubic', progress_transform1);

            builder.get('right_leg')
            .setXRotDegrees(-50)
            .setYRotDegrees(0)
            .setZRotDegrees(15)
            .animate('InOutCubic', progress_transform1);

        builder.get('left_leg')
            .setXRotDegrees(-50)
            .setYRotDegrees(0)
            .setZRotDegrees(-15)
            .animate('InOutCubic', progress_transform1);
    }
    if (progress_transform1 > 0.0 && builder.isFirstPerson()) {
            }
        }
    });
});

PalladiumEvents.registerAnimations((event) => {
    event.register('arrzee/thundercrash_transform2', 1, (builder) => {

        const progress_transform2 = animationUtil.getAnimationTimerAbilityValue(builder.getPlayer(), 'arrzenhanced:electric_gamma_radiation', 'transform', builder.getPartialTicks(), 10, 19);
        if (progress_transform2 > 0 && !builder.isFirstPerson()) {

            builder.get('head')
            .setXRotDegrees(-15)
            .setYRotDegrees(0)
            .setZRotDegrees(0)
            .animate('InOutCubic', progress_transform2);

            builder.get('body')
            .moveY(-3.5)
            .moveZ(-10)
            .setXRotDegrees(0)
            .setYRotDegrees(0)
            .setZRotDegrees(0)
            .animate('InOutCubic', progress_transform2);

        builder.get('right_arm')
            .setXRotDegrees(25)
            .setYRotDegrees(0)
            .setZRotDegrees(70)
            .animate('InOutCubic', progress_transform2);

        builder.get('left_arm')
            .setXRotDegrees(25)
            .setYRotDegrees(0)
            .setZRotDegrees(-70)
            .animate('InOutCubic', progress_transform2);

            builder.get('right_leg')
            .moveX(-1)
            .setXRotDegrees(0)
            .setYRotDegrees(20)
            .setZRotDegrees(-5)
            .animate('InOutCubic', progress_transform2);

        builder.get('left_leg')
            .moveX(1)
            .setXRotDegrees(0)
            .setYRotDegrees(-20)
            .setZRotDegrees(5)
            .animate('InOutCubic', progress_transform2);
    }


    });
});

PalladiumEvents.registerAnimations((event) => {
    event.register('arrzee/thundercrash_transform3', 1, (builder) => {

        const progress_transform3 = animationUtil.getAnimationTimerAbilityValue(builder.getPlayer(), 'arrzenhanced:electric_gamma_radiation', 'transform', builder.getPartialTicks(), 19, 24);
        if (progress_transform3 > 0 && !builder.isFirstPerson()) {

            builder.get('head')
            .setXRotDegrees(0)
            .setYRotDegrees(0)
            .setZRotDegrees(0)
            .animate('InOutCubic', progress_transform3);

            builder.get('body')
            .moveY(0)
            .moveZ(0)
            .setXRotDegrees(0)
            .setYRotDegrees(0)
            .setZRotDegrees(0)
            .animate('InOutCubic', progress_transform3);

        builder.get('right_arm')
            .setXRotDegrees(0)
            .setYRotDegrees(0)
            .setZRotDegrees(0)
            .animate('InOutCubic', progress_transform3);

        builder.get('left_arm')
            .setXRotDegrees(0)
            .setYRotDegrees(0)
            .setZRotDegrees(0)
            .animate('InOutCubic', progress_transform3);

            builder.get('right_leg')
            .moveX(1)
            .setXRotDegrees(0)
            .setYRotDegrees(0)
            .setZRotDegrees(0)
            .animate('InOutCubic', progress_transform3);

        builder.get('left_leg')
            .moveX(-1)
            .setXRotDegrees(0)
            .setYRotDegrees(0)
            .setZRotDegrees(0)
            .animate('InOutCubic', progress_transform3);
    }


    });
});

PalladiumEvents.registerAnimations((event) => {
    event.register('arrzee/smash1', 1, (builder) => {
        
    if (abilityUtil.isEnabled(builder.getPlayer(), "arrzenhanced:electric_gamma_radiation", "shockwave")) {

        const progress_smash1 = animationUtil.getAnimationTimerAbilityValue(builder.getPlayer(), 'arrzenhanced:electric_gamma_radiation', 'shockwave', builder.getPartialTicks(), 1, 6);
        if (progress_smash1 > 0 && !builder.isFirstPerson()) {

        builder.get('right_arm')
            .setXRotDegrees(-190)
            .setYRotDegrees(12.5)
            .setZRotDegrees(-16.5)
            .animate('InOutCubic', progress_smash1);

        builder.get('left_arm')
            .setXRotDegrees(-190)
            .setYRotDegrees(-12.5)
            .setZRotDegrees(16.5)
            .animate('InOutCubic', progress_smash1);
    }
    if (progress_smash1 > 0.0 && builder.isFirstPerson()) {
                builder.get('right_arm')
                .setZRotDegrees(-45)
                .animate('InOutCubic', progress_smash1);

                builder.get('left_arm')
                .setZRotDegrees(45)
                .animate('InOutCubic', progress_smash1);
            }


        }
    });
});

PalladiumEvents.registerAnimations((event) => {
    event.register('arrzee/thundercrash_smash1', 1, (builder) => {
        
    if (abilityUtil.isEnabled(builder.getPlayer(), "arrzenhanced:electric_gamma_radiation", "shockwave")) {

        const progress_smash1 = animationUtil.getAnimationTimerAbilityValue(builder.getPlayer(), 'arrzenhanced:electric_gamma_radiation', 'shockwave', builder.getPartialTicks(), 1, 6);
        if (progress_smash1 > 0 && !builder.isFirstPerson()) {

        builder.get('right_arm')
            .setXRotDegrees(-190)
            .setYRotDegrees(12.5)
            .setZRotDegrees(-16.5)
            .animate('InOutCubic', progress_smash1);

        builder.get('left_arm')
            .setXRotDegrees(-190)
            .setYRotDegrees(-12.5)
            .setZRotDegrees(16.5)
            .animate('InOutCubic', progress_smash1);
            }
        }
    });
});

PalladiumEvents.registerAnimations((event) => {
    event.register('arrzee/thundercrash_smash2', 1, (builder) => {

        const progress_smash2 = animationUtil.getAnimationTimerAbilityValue(builder.getPlayer(), 'arrzenhanced:electric_gamma_radiation', 'shockwave', builder.getPartialTicks(), 5, 13);
        if (progress_smash2 > 0 && !builder.isFirstPerson()) {

            builder.get('body')
                .setX(0)
                .setY(-3)
                .setZ(0)
                .setXRotDegrees(0)
                .setYRotDegrees(0)
                .setZRotDegrees(0)
                .animate('InOutCubic', progress_smash2);

            builder.get('right_arm')
            .setX(-5)
            .setY(12.5)
            .setXRotDegrees(-40)
            .setYRotDegrees(-12.5)
            .setZRotDegrees(-3.5)
            .animate('InOutCubic', progress_smash2);

        builder.get('left_arm')
            .setX(5)
            .setY(12.5)
            .setXRotDegrees(-40)
            .setYRotDegrees(12.5)
            .setZRotDegrees(3.5)
            .animate('InOutCubic', progress_smash2);

            builder.get('head')
                .setX(0)
                .setY(9)
                .setZ(0)
                .animate('InOutCubic', progress_smash2);
        
            builder.get('chest')
                .setX(0)
                .setY(9)
                .setZ(0)
                .setXRotDegrees(0)
                .setYRotDegrees(0)
                .setZRotDegrees(0)
                .animate('InOutCubic', progress_smash2);
        
            builder.get('right_leg')
                .setX(-1.9)
                .setZ(-2)
                .setXRotDegrees(0)
                .setYRotDegrees(0)
                .setZRotDegrees(0)
                .animate('InOutCubic', progress_smash2);
        
            builder.get('left_leg')
                .setX(1.9)
                .setY(20)
                .setZ(-5)
                .setXRotDegrees(90)
                .setYRotDegrees(0)
                .setZRotDegrees(0)
                .animate('InOutCubic', progress_smash2);
    }


    });
});

PalladiumEvents.registerAnimations((event) => {
    event.register('arrzee/thundercrash_clap1', 1, (builder) => {
        
    if (abilityUtil.isEnabled(builder.getPlayer(), "arrzenhanced:electric_gamma_radiation", "shockwave_clap")) {

        const progress_clap1 = animationUtil.getAnimationTimerAbilityValue(builder.getPlayer(), 'arrzenhanced:electric_gamma_radiation', 'shockwave_clap', builder.getPartialTicks(), 1, 7);
        if (progress_clap1 > 0 && !builder.isFirstPerson()) {


            builder.get('left_arm')
            .setXRotDegrees(-90)
            .setZRotDegrees(0)
            .setYRotDegrees(-80)
            .animate('Linear', progress_clap1);

        builder.get('right_arm')
            .setXRotDegrees(-90)
            .setZRotDegrees(0)
            .setYRotDegrees(80)
            .animate('Linear', progress_clap1);
    }
    if (progress_clap1 > 0.0 && builder.isFirstPerson()) {
        builder.get('left_arm')
        .setX(0)
        .setY(3)
        .setZ(0)
        .setXRotDegrees(-30)
        .setYRotDegrees(-100)
        .setZRotDegrees(70)
            .animate('Linear', progress_clap1);

        builder.get('right_arm')
        .setX(0)
        .setY(3)
        .setZ(0)
            .setXRotDegrees(-30)
            .setYRotDegrees(100)
            .setZRotDegrees(-70)
            .animate('Linear', progress_clap1);
            }


        }
    });
});

PalladiumEvents.registerAnimations((event) => {
    event.register('arrzee/thundercrash_clap2', 1, (builder) => {

        const progress_clap2 = animationUtil.getAnimationTimerAbilityValue(builder.getPlayer(), 'arrzenhanced:electric_gamma_radiation', 'shockwave_clap', builder.getPartialTicks(), 6, 9);
        if (progress_clap2 > 0 && !builder.isFirstPerson()) {


            builder.get('left_arm')
            .setXRotDegrees(-90)
            .setZRotDegrees(0)
            .setYRotDegrees(30)
            .animate('Linear', progress_clap2);

        builder.get('right_arm')
            .setXRotDegrees(-90)
            .setZRotDegrees(0)
            .setYRotDegrees(-30)
            .animate('Linear', progress_clap2);

         }
         if (progress_clap2 > 0.0 && builder.isFirstPerson()) {
             builder.get('left_arm')
             .setX(0)
             .setY(3)
             .setZ(0)
             .setXRotDegrees(-30)
             .setYRotDegrees(0)
             .setZRotDegrees(70)
                 .animate('Linear', progress_clap2);
     
             builder.get('right_arm')
             .setX(0)
             .setY(3)
             .setZ(0)
                 .setXRotDegrees(-30)
                 .setYRotDegrees(0)
                 .setZRotDegrees(-70)
                 .animate('Linear', progress_clap2);
                 }


    });
});