PalladiumEvents.registerAnimations((event) => {
    event.register('gun_in_right', 1000, (builder) => {
        let right_inject_progress = animationUtil.getAnimationTimerAbilityValue(builder.getPlayer(), 'arrzenhanced:circuit_gun', 'left_hand_anim', builder.getPartialTicks());

        if (right_inject_progress > 0.0) {
            if (builder.isFirstPerson()) {
                // do first-person animations
            } else {
                // do third-person animations
                builder.get('left_arm')
                    .setXRotDegrees(-90)
                    .setYRotDegrees(50)
                    .setZRotDegrees(5)
                    .animate('InOutCubic', right_inject_progress);
                // builder.get('right_arm')
                //     .setXRotDegrees(-90)
                //     .setYRotDegrees(0)
                //     .animate('InOutCubic', right_inject_progress);
            }
        }
    });

    event.register('gun_in_left', 30, (builder) => {
        let left_inject_progress = animationUtil.getAnimationTimerAbilityValue(builder.getPlayer(), 'arrzenhanced:circuit_gun', 'right_hand_anim', builder.getPartialTicks());

        if (left_inject_progress > 0.0) {
            if (builder.isFirstPerson()) {
                // do first-person animations
            } else {
                // do third-person animations
                builder.get('right_arm')
                    .setXRotDegrees(90)
                    .animate('InOutCubic', left_inject_progress);
            }
        }
    });
});
