PalladiumEvents.registerAnimations((event) => {
    event.register('arrzee/hexios', 1, (builder) => {
        let progress_hexios_daggers = animationUtil.getAnimationTimerAbilityValue(builder.getPlayer(), 'arrzenhanced:hexios_magic', 'dagger_anim', builder.getPartialTicks());

        if (progress_hexios_daggers > 0.0) {
            if (builder.isFirstPerson()) {
                // do first-person animations
                builder.get('right_arm')
                    .setXRotDegrees(0)
                    .setZRotDegrees(0)
                    .setYRotDegrees(0)
                    .animate('InOutBounce', progress_hexios_daggers);
            } else {
                // do third-person animations
                builder.get('right_arm')
                    .moveY(-1)
                    .moveZ(-1)
                    .setXRotDegrees(-140)
                    .setZRotDegrees(-60)
                    .setYRotDegrees(0)
                    .animate('InOutBounce', progress_hexios_daggers);

                    builder.get('left_arm')
                    .moveY(-1)
                    .moveZ(-1)
                    .setXRotDegrees(-140)
                    .setZRotDegrees(60)
                    .setYRotDegrees(0)
                    .animate('InOutBounce', progress_hexios_daggers);
            }
        }

    });
});

PalladiumEvents.registerAnimations((event) => {
    event.register('arrzee/hexios_field', 1, (builder) => {
        let progress_hexios_daggers = animationUtil.getAnimationTimerAbilityValue(builder.getPlayer(), 'arrzenhanced:hexios_magic', 'forcefield', builder.getPartialTicks());

        if (progress_hexios_daggers > 0.0) {
            if (builder.isFirstPerson()) {
                // do first-person animations
                builder.get('right_arm')
                .moveY(2)
                .moveZ(0)
                .moveX(0)
                .setXRotDegrees(0)
                .setZRotDegrees(0)
                .setYRotDegrees(30)
                    .animate('InOutBounce', progress_hexios_daggers);

                    builder.get('left_arm')
                    .moveY(2)
                    .moveZ(0)
                    .moveX(0)
                    .setXRotDegrees(0)
                    .setZRotDegrees(0)
                    .setYRotDegrees(-30)
                        .animate('InOutBounce', progress_hexios_daggers);
            } else {
                // do third-person animations
                const halfPi = 1.57079632679;
                builder.get('right_arm')
                    .setXRot(builder.getModel().head.xRot - halfPi)
                    .setYRot(builder.getModel().head.yRot + 0.3)
					.setZRot(builder.getModel().head.zRot + 0.3)
                    .animate('InOutBounce', progress_hexios_daggers);

                    builder.get('left_arm')
                    .setXRot(builder.getModel().head.xRot - halfPi)
                    .setYRot(builder.getModel().head.yRot - 0.3)
					.setZRot(builder.getModel().head.zRot - 0.3)
                    .animate('InOutBounce', progress_hexios_daggers);
            }
        }

    });
});