PalladiumEvents.registerAnimations((event) => {
    event.register('arrzee/napturgy_power_nap', 1, (builder) => {
        let progress_power_nap = animationUtil.getAnimationTimerAbilityValue(builder.getPlayer(), 'arrzenhanced:napturgy', 'power_nap_anim', builder.getPartialTicks());

        if (progress_power_nap > 0.0) {
            if (builder.isFirstPerson()) {
                // do first-person animations
            } else {
                // do third-person animations
                builder.get('head')
                .setZRotDegrees(0)
                .setXRotDegrees(0)
                .setYRotDegrees(0)
                .animate('InOutCubic', progress_power_nap);

                builder.get('body')
                .setZRotDegrees(0)
                .setXRotDegrees(90)
                .setYRotDegrees(0)
                .setZ(-14)
                .setY(2)
                .animate('InOutCubic', progress_power_nap);

                builder.get('right_arm')
                .setZRotDegrees(0)
                .setXRotDegrees(0)
                .setYRotDegrees(0)
                .animate('InOutCubic', progress_power_nap);
                
                builder.get('left_arm')
                .setZRotDegrees(0)
                .setXRotDegrees(0)
                .setYRotDegrees(0)
                .animate('InOutCubic', progress_power_nap);

                builder.get('right_leg')
                .setZRotDegrees(0)
                .setXRotDegrees(0)
                .setYRotDegrees(0)
                .animate('InOutCubic', progress_power_nap);

                builder.get('left_leg')
                .setZRotDegrees(0)
                .setXRotDegrees(0)
                .setYRotDegrees(0)
                .animate('InOutCubic', progress_power_nap);
            }
        }

    });
});

PalladiumEvents.registerAnimations((event) => {
    event.register('arrzee/napturgy_flight', 1, (builder) => {
        let progress_flight = animationUtil.getAnimationTimerAbilityValue(builder.getPlayer(), 'arrzenhanced:napturgy', 'flight_anim', builder.getPartialTicks());

        if (progress_flight > 0.0) {
            if (builder.isFirstPerson()) {
                // do first-person animations
            } else {
                // do third-person animations
                builder.get('right_arm')
                .setZRotDegrees(15)
                .animate('InOutCubic', progress_flight);
                
                builder.get('left_arm')
                .setZRotDegrees(-15)
                .animate('InOutCubic', progress_flight);

                builder.get('right_leg')
                .setZ(-2)
                .setY(10)
                .setXRotDegrees(20)
                .animate('InOutCubic', progress_flight);
            }
        }

    });
});

PalladiumEvents.registerAnimations((event) => {
    event.register('arrzee/napturgy_rem_beam', 1, (builder) => {
        let progress_rem_beam = animationUtil.getAnimationTimerAbilityValue(builder.getPlayer(), 'arrzenhanced:napturgy', 'rem_beam', builder.getPartialTicks());

        if (progress_rem_beam > 0.0) {
            if (builder.isFirstPerson()) {
                // do first-person animations
            } else {
                // do third-person animations
                builder.get('right_arm')
                .setXRot(builder.getModel().head.xRot - 1.1)
                .setYRot(builder.getModel().head.yRot - 0.4)
                .setZRot(builder.getModel().head.zRot + 0.1)
                    .animate('InOutBounce', progress_rem_beam);

                    builder.get('left_arm')
                    .setXRot(builder.getModel().head.xRot - 1.4)
                    .setYRot(builder.getModel().head.yRot + 0.4)
					.setZRot(builder.getModel().head.zRot - 0.1)
                    .animate('InOutBounce', progress_rem_beam);
            }
        }

    });
});