PalladiumEvents.registerAnimations((event) => {
    event.register('speed_running_anim', 1, (builder) => {
        if (abilityUtil.isEnabled(builder.getPlayer(), "arrzenhanced:speedforce", "speed_running_anim") && !builder.isFirstPerson()) {
            const progress = animationUtil.getAnimationTimerAbilityValue(builder.getPlayer(), 'arrzenhanced:speedforce', 'speed_running_anim', builder.getPartialTicks());
            builder.get('chest')
            .setXRotDegrees(15.5)
            .moveZ(-3)
            builder.get('head')
            .moveZ(-3.5)
            if (progress < 1/3) {
                builder.get('left_arm')
                    .moveZ(-3)
                    .setXRotDegrees(30)
                    .setYRotDegrees(20)
                    .setZRotDegrees(-40)
                
                builder.get('right_arm')
                    .moveZ(-3)
                    .setXRotDegrees(-100)
                    .setYRotDegrees(-20)
                    .setZRotDegrees(40)
            } else if (progress < 2/3) {
                builder.get('left_arm')
                    .moveZ(-3)
                    .setXRotDegrees(-70)
                    .setYRotDegrees(20)
                    .setZRotDegrees(-40)

                builder.get('right_arm')
                    .moveZ(-3)
                    .setXRotDegrees(-70)
                    .setYRotDegrees(-10)
                    .setZRotDegrees(40)
            } else if (progress < 3/3) {
                builder.get('left_arm')
                    .moveZ(-3)
                    .setXRotDegrees(-100)
                    .setYRotDegrees(20)
                    .setZRotDegrees(-40)

                builder.get('right_arm')
                    .moveZ(-3)
                    .setXRotDegrees(30)
                    .setYRotDegrees(-20)
                    .setZRotDegrees(40)
            }


            if (progress < 1/3) {
                builder.get('left_leg')
                    .setXRotDegrees(65)
                    .setYRotDegrees(0)
                    .setZRotDegrees(0)
                
                builder.get('right_leg')
                    .setXRotDegrees(-65)
                    .setYRotDegrees(0)
                    .setZRotDegrees(0)
            } else if (progress < 2/3) {
                builder.get('left_leg')
                    .setXRotDegrees(20)
                    .setYRotDegrees(0)
                    .setZRotDegrees(0)

                builder.get('right_leg')
                    .setXRotDegrees(-20)
                    .setYRotDegrees(0)
                    .setZRotDegrees(0)
            } else if (progress < 3/3) {
                builder.get('left_leg')
                    .setXRotDegrees(-65)
                    .setYRotDegrees(0)
                    .setZRotDegrees(0)

                builder.get('right_leg')
                    .setXRotDegrees(65)
                    .setYRotDegrees(0)
                    .setZRotDegrees(0)
            }
        }
    })
});