PalladiumEvents.registerAnimations((event) => {
    event.register('arrzee/umbra', 1, (builder) => {
        let progress_dome_right = animationUtil.getAnimationTimerAbilityValue(builder.getPlayer(), 'arrzenhanced:umbrakinesis', 'dome_anim_right', builder.getPartialTicks());

        if (progress_dome_right > 0.0) {
            if (builder.isFirstPerson()) {
                // do first-person animations
                builder.get('left_arm')
                    .setZRotDegrees(0)
                    .setXRotDegrees(0)
                    .setYRotDegrees(0)
                    .animate('Linear', progress_dome_right);

                builder.get('right_arm')
                    .setZRotDegrees(0)
                    .setXRotDegrees(0)
                    .setYRotDegrees(0)
                    .animate('Linear', progress_dome_right);
            } else {
                // do third-person animations
                builder.get('left_arm')
                    .setZRotDegrees(0)
                    .setXRotDegrees(0)
                    .setYRotDegrees(0)
                    .animate('Linear', progress_dome_right);

                builder.get('right_arm')
                    .setZRotDegrees(0)
                    .setXRotDegrees(-180)
                    .setYRotDegrees(0)
                    .animate('Linear', progress_dome_right);
            }
        }

        let progress_dome_left = animationUtil.getAnimationTimerAbilityValue(builder.getPlayer(), 'arrzenhanced:umbrakinesis', 'dome_anim_left', builder.getPartialTicks());

        if (progress_dome_left > 0.0) {
            if (builder.isFirstPerson()) {
                // do first-person animations
                builder.get('left_arm')
                    .setZRotDegrees(0)
                    .setXRotDegrees(0)
                    .setYRotDegrees(0)
                    .animate('Linear', progress_dome_left);

                builder.get('right_arm')
                    .setZRotDegrees(0)
                    .setXRotDegrees(0)
                    .setYRotDegrees(0)
                    .animate('Linear', progress_dome_left);
            } else {
                // do third-person animations
                builder.get('left_arm')
                    .setZRotDegrees(0)
                    .setXRotDegrees(-180)
                    .setYRotDegrees(0)
                    .animate('Linear', progress_dome_left);

                builder.get('right_arm')
                    .setZRotDegrees(0)
                    .setXRotDegrees(0)
                    .setYRotDegrees(0)
                    .animate('Linear', progress_dome_left);
            }
        }

    });
});