var $ResourceKey_ = Java.loadClass("net.minecraft.resources.ResourceKey");
var DAMAGE_TYPE_KEY = $ResourceKey_.createRegistryKey("damage_type");

function getDamageSourceBothSides(
    /** @type {Internal.Level}*/ level,
    /** @type {Internal.DamageType_}*/ damageType,
    /** @type {Internal.LivingEntity}*/ destEntity,
    /** @type {Internal.LivingEntity}*/ sourceEntity
    ) {
    var resourceKey = $ResourceKey_.create(DAMAGE_TYPE_KEY, Utils.id(damageType));
    var holder = level.registryAccess().registryOrThrow(DAMAGE_TYPE_KEY).getHolderOrThrow(resourceKey);
    var damagesourceholder = holder;
    return new DamageSource(damagesourceholder, sourceEntity, destEntity);
}

// arrz.trick_arrow.dampening
EntityEvents.hurt(event => {
    var source = event.source.actual;
    var target = event.entity;
    var arrow = event.getSource().getImmediate()
    // console.log(arrow)

    if (!arrow || arrow.type != 'palladium:custom_projectile') {return}
    if (target.isPlayer()) {
        if (target.isCreative()) {return}
    }
    if (!arrow.tags.contains('arrz.ace_card')) {return}
    target.invulnerableTime = 0
    if (arrow.tags.contains('arrz.ace_card.joker')) {
        if (!target?.potionEffects) return
        target.potionEffects.add('dampened:dark_matter', 60 * 20, 0, false, false)
        target.potionEffects.add('dampened:genetic', 60 * 20, 0, false, false)
        target.potionEffects.add('dampened:magic', 60 * 20, 0, false, false)
        target.potionEffects.add('dampened:emp', 60 * 20, 0, false, false)
    }
    if (arrow.tags.contains('arrz.ace_card.ace.spades')) {
        if (!target?.potionEffects) return
        target.potionEffects.add('minecraft:wither', 10 * 20, 0, false, false)
    }
    if (arrow.tags.contains('arrz.ace_card.ace.hearts')) {
        source.health += event.damage
        // source.health += (event.damage / 2)
        // if (!target?.potionEffects) return
        // target.potionEffects.add('minecraft:wither', 60 * 20, 0, false, false)
    }
    if (arrow.tags.contains('arrz.ace_card.ace.diamonds')) {
        // nothing
    }
    if (arrow.tags.contains('arrz.ace_card.ace.clubs')) {
        // nothing
    }
    if (arrow.tags.contains('arrz.ace_card.jack')) {
        if (!target?.potionEffects) return
        target.potionEffects.add('minecraft:glowing', 10 * 20, 0, false, false)
        target.potionEffects.add('minecraft:darkness', 10 * 20, 0, false, false)
    }
    if (arrow.tags.contains('arrz.ace_card.queen')) {
        if (!target?.potionEffects) return
        target.potionEffects.add('arrzenhanced:concussed', 5 * 20, 0, false, false)
        target.potionEffects.add('minecraft:slowness', 10 * 20, 0, false, false)
    }
    if (arrow.tags.contains('arrz.ace_card.king')) {
        // AoE Damage
        let coords = arrow.position(),
        radius = 2.5,
        level = arrow.getLevel();
        let aabb = AABB.of(
            coords.x() - radius, coords.y() - radius, coords.z() - radius,
            coords.x() + radius, coords.y() + radius, coords.z() + radius
        )
        level.spawnParticles('minecraft:cloud', true, coords.x(), coords.y(), coords.z(), radius/2, 0, radius/2, 50, 0);

        level.getEntitiesWithin(aabb).forEach(target => {
            if (
                target !== source &&
                target !== arrow &&
                target.type !== "minecraft:item" &&
                target.type !== "minecraft:item_frame" &&
                target.type !== "minecraft:experience_orb" &&
                target.type !== "minecraft:glow_item_frame" &&
                target.type !== "minecraft:armor_stand" &&
                target.type !== "palladium:suit_stand"
            ) {
                let damageSource = getDamageSourceBothSides(level, "minecraft:player_attack", source, target);
                target.attack(damageSource, 4.5);
            }
        });

        if (!target?.potionEffects) return
        target.potionEffects.add('arrzenhanced:concussed', 5 * 20, 0, false, false)
        target.potionEffects.add('minecraft:slowness', 10 * 20, 0, false, false)
    }
})