let fabCols = [
    "lime",
    "black",
    "blue",
    "brown",
    "cyan",
    "gray",
    "green",
    "light_blue",
    "light_gray",
    "magenta",
    "orange",
    "pink",
    "purple",
    "red",
    "white",
    "yellow"
]

ServerEvents.commandRegistry(event => {
	const { commands: Commands, arguments: Arguments } = event

	event.register(
		Commands.literal("rollover")
        // .requires(src => src.hasPermission(2))
        .executes(ctx => rolloverCommand(ctx))
	)
})

let rolloverCommand = (ctx) => {
    let player = ctx.source.player
    let inventory = player.getInventory()
    for (let i = 0; i < inventory.INVENTORY_SIZE; i++) {
        let itemStack = inventory.getItem(i)
        if (itemStack != null) {
            if (itemStack.getId() == 'grave.core:titanium_ingot') {
                inventory.setItem(i, Item.of('arrzenhanced:titanium_ingot', itemStack.count))
            } else if (itemStack.getId() == 'grave.core:titanium_block') {
                inventory.setItem(i, Item.of('arrzenhanced:titanium_block', itemStack.count))
            } else if (itemStack.getId() == 'grave.core:titanium_nugget') {
                inventory.setItem(i, Item.of('palladium:lead_ingot', itemStack.count))
            } else {
                fabCols.forEach(color => {
                    if (itemStack.getId() == `grave.core:${color}_fabric`) {
                        inventory.setItem(i, Item.of(`arrzenhanced:${color}_fabric`, itemStack.count))
                    }
                })
            }
        }
    }
    player.tell('Rollover complete!')
    return 1
}